/*
 * Decompiled with CFR 0.152.
 */
package com.github.tkurz.sparqlmm.function.temporal.accessor;

import com.github.tkurz.media.ontology.type.TemporalEntity;
import com.github.tkurz.sparqlmm.doc.FunctionDoc;
import com.github.tkurz.sparqlmm.utils.FunctionHelper;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;

@FunctionDoc(title="TemporalFragment Test", properties={TemporalEntity.class}, reference=FunctionDoc.Reference.temporal, description="returns true is value is or includes a temporal fragment.", type=FunctionDoc.Type.accessorFunction)
public class TemporalFragmentTest
implements Function {
    public String getURI() {
        return "http://linkedmultimedia.org/sparql-mm/ns/2.0.0/function#hasTemporalFragment";
    }

    public Value evaluate(ValueFactory valueFactory, Value ... values) throws ValueExprEvaluationException {
        if (values.length != 1) {
            return FunctionHelper.BOOL_LITERAL_FALSE;
        }
        try {
            return FunctionHelper.toTemporalEntity(values[0]) == null ? FunctionHelper.BOOL_LITERAL_FALSE : FunctionHelper.BOOL_LITERAL_TRUE;
        }
        catch (IllegalArgumentException e) {
            return FunctionHelper.BOOL_LITERAL_FALSE;
        }
    }
}

