/*
 * Decompiled with CFR 0.152.
 */
package com.github.tkurz.sparqlmm.function.spatial.relation.topological;

import com.github.tkurz.media.ontology.function.SpatialFunction;
import com.github.tkurz.media.ontology.type.SpatialEntity;
import com.github.tkurz.sparqlmm.doc.FunctionDoc;
import com.github.tkurz.sparqlmm.utils.FunctionHelper;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;

@FunctionDoc(title="covers", properties={SpatialEntity.class, SpatialEntity.class}, reference=FunctionDoc.Reference.spatial, description="returns true if all points of p1.shape are points of p2.shape, else false. ")
public class CoversFunction
implements Function {
    public String getURI() {
        return "http://linkedmultimedia.org/sparql-mm/ns/2.0.0/function#covers";
    }

    public Value evaluate(ValueFactory valueFactory, Value ... values) throws ValueExprEvaluationException {
        try {
            if (values.length != 2 || !FunctionHelper.isComparable(values)) {
                return FunctionHelper.BOOL_LITERAL_FALSE;
            }
            SpatialEntity[] entities = FunctionHelper.toSpatialEntities(values);
            return valueFactory.createLiteral(SpatialFunction.TopologicalFunction.covers((SpatialEntity)entities[0], (SpatialEntity)entities[1]));
        }
        catch (IllegalArgumentException e) {
            return FunctionHelper.BOOL_LITERAL_FALSE;
        }
    }
}

