/*
 * Decompiled with CFR 0.152.
 */
package com.github.tkurz.sparqlmm.function.spatial.relation.directional;

import com.github.tkurz.media.ontology.function.SpatialFunction;
import com.github.tkurz.media.ontology.type.SpatialEntity;
import com.github.tkurz.sparqlmm.doc.FunctionDoc;
import com.github.tkurz.sparqlmm.utils.FunctionHelper;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;

@FunctionDoc(title="above", properties={SpatialEntity.class, SpatialEntity.class}, reference=FunctionDoc.Reference.spatial, description="returns true p1 if is above p2 (based on model m), else false.")
public class AboveFunction
implements Function {
    public String getURI() {
        return "http://linkedmultimedia.org/sparql-mm/ns/2.0.0/function#above";
    }

    public Value evaluate(ValueFactory valueFactory, Value ... values) throws ValueExprEvaluationException {
        try {
            if (values.length != 2 || !FunctionHelper.isComparable(values)) {
                return FunctionHelper.BOOL_LITERAL_FALSE;
            }
            SpatialEntity[] entities = FunctionHelper.toSpatialEntities(values);
            return valueFactory.createLiteral(SpatialFunction.DirectionalFunction.above((SpatialEntity)entities[0], (SpatialEntity)entities[1]));
        }
        catch (IllegalArgumentException e) {
            return FunctionHelper.BOOL_LITERAL_FALSE;
        }
    }
}

