/*
 * Decompiled with CFR 0.152.
 */
package com.github.tkurz.sparqlmm.function.spatial.aggregation;

import com.github.tkurz.media.ontology.function.SpatialFunction;
import com.github.tkurz.media.ontology.type.SpatialEntity;
import com.github.tkurz.sparqlmm.doc.FunctionDoc;
import com.github.tkurz.sparqlmm.utils.FunctionHelper;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;

@FunctionDoc(title="spatialBoundingBox", properties={SpatialEntity.class, SpatialEntity.class}, reference=FunctionDoc.Reference.spatial, description="returns new MediaFragment / MediaFragmentURI with spatial fragment out of existing resources p1 and p2, so that x = min( p1.x, p2.x ) and y = min( p1.y, p2.y ) and w = max( p1.x + p1.w, p2.x + p2.w ) and h = max( p1.y + p1.h, p2.y + p2.h ).", type=FunctionDoc.Type.extensionAggregate)
public class BoundingBoxFunction
implements Function {
    public String getURI() {
        return "http://linkedmultimedia.org/sparql-mm/ns/2.0.0/function#spatialBoundingBox";
    }

    public Value evaluate(ValueFactory valueFactory, Value ... values) throws ValueExprEvaluationException {
        try {
            if (values.length < 2 || !FunctionHelper.isComparable(values)) {
                return null;
            }
            SpatialEntity[] entities = FunctionHelper.toSpatialEntities(values);
            String box = SpatialFunction.getBoundingBox((SpatialEntity[])entities).stringValue();
            if (values[0] instanceof IRI) {
                String uri = FunctionHelper.getCleanURI(values[0]);
                return valueFactory.createIRI(uri + "#" + box);
            }
            return valueFactory.createLiteral(box);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

