/*
 * Decompiled with CFR 0.152.
 */
package com.github.tkurz.sparqlmm.function.general.relation;

import com.github.tkurz.media.ontology.exception.NotComparableException;
import com.github.tkurz.media.ontology.function.SpatialFunction;
import com.github.tkurz.media.ontology.function.TemporalFunction;
import com.github.tkurz.media.ontology.type.SpatialEntity;
import com.github.tkurz.media.ontology.type.SpatialTemporalEntity;
import com.github.tkurz.media.ontology.type.TemporalEntity;
import com.github.tkurz.sparqlmm.doc.FunctionDoc;
import com.github.tkurz.sparqlmm.utils.FunctionHelper;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;

@FunctionDoc(title="contains", properties={SpatialTemporalEntity.class, SpatialTemporalEntity.class}, reference=FunctionDoc.Reference.combined, description="returns if mm:temporalContains(p1,p2) and mm:spatialContains(p1,p2).")
public class ContainsFunction
implements Function {
    public String getURI() {
        return "http://linkedmultimedia.org/sparql-mm/ns/2.0.0/function#contains";
    }

    public Value evaluate(ValueFactory valueFactory, Value ... values) throws ValueExprEvaluationException {
        try {
            if (values.length != 2 || !FunctionHelper.isComparable(values)) {
                return FunctionHelper.BOOL_LITERAL_FALSE;
            }
            TemporalEntity[] temporalEntities = FunctionHelper.toTemporalEntities(values);
            SpatialEntity[] spatialEntities = FunctionHelper.toSpatialEntities(values);
            if (TemporalFunction.contains((TemporalEntity)temporalEntities[0], (TemporalEntity)temporalEntities[1]) && SpatialFunction.TopologicalFunction.contains((SpatialEntity)spatialEntities[0], (SpatialEntity)spatialEntities[0])) {
                return FunctionHelper.BOOL_LITERAL_TRUE;
            }
            return FunctionHelper.BOOL_LITERAL_FALSE;
        }
        catch (NotComparableException | IllegalArgumentException e) {
            return FunctionHelper.BOOL_LITERAL_FALSE;
        }
    }
}

