/*
 * Decompiled with CFR 0.152.
 */
package com.github.tkurz.sparqlmm.function.general.accessor;

import com.github.tkurz.media.ontology.type.SpatialTemporalEntity;
import com.github.tkurz.sparqlmm.doc.FunctionDoc;
import com.github.tkurz.sparqlmm.utils.FunctionHelper;
import org.apache.commons.lang3.NotImplementedException;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;

@FunctionDoc(title="MediaFragment", properties={SpatialTemporalEntity.class}, reference=FunctionDoc.Reference.combined, description="returns a string representation of a media fragment.", type=FunctionDoc.Type.accessorFunction)
public class MediaFragment
implements Function {
    public String getURI() {
        return "http://linkedmultimedia.org/sparql-mm/ns/2.0.0/function#mediaFragment";
    }

    public Value evaluate(ValueFactory valueFactory, Value ... values) throws ValueExprEvaluationException {
        if (values.length == 1) {
            try {
                return valueFactory.createLiteral(FunctionHelper.toSpatialTemporalEntity(values[0]).stringValue());
            }
            catch (IllegalArgumentException | NullPointerException e) {
                return null;
            }
        }
        if (values.length == 2) {
            throw new NotImplementedException("Not implemented");
        }
        return null;
    }
}

