/*
 * Decompiled with CFR 0.152.
 */
package com.github.tkurz.sparqlmm.doc;

import com.github.tkurz.sparqlmm.vocabularies.SSD;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.eclipse.rdf4j.model.IRI;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface FunctionDoc {
    public static final String SPATIAL = "Spatial";
    public static final String TEMPORAL = "Temporal";
    public static final String GENERAL = "General";
    public static final String R = "R";
    public static final String A = "A";
    public static final String F = "F";
    public static final String RELATION = "Relation";
    public static final String AGGREGATION = "Aggregation";
    public static final String ACCESSOR = "Accessor";

    public String title();

    public String description() default "";

    public Type type() default Type.extensionFunction;

    public Reference reference();

    public Class[] properties();

    public static enum Type {
        extensionFunction("R", "Relation", SSD.extensionFunction),
        extensionAggregate("A", "Aggregation", SSD.extensionAggregate),
        accessorFunction("F", "Accessor", SSD.extensionFunction);

        private IRI uri;
        private String name;
        private String id;

        private Type(String id, String name, IRI uri) {
            this.name = name;
            this.uri = uri;
            this.id = id;
        }

        public IRI getUri() {
            return this.uri;
        }

        public String getName() {
            return this.name;
        }

        public String getId() {
            return this.id;
        }
    }

    public static enum Reference {
        spatial("Spatial"),
        temporal("Temporal"),
        combined("General");

        private String value;

        private Reference(String value) {
            this.value = value;
        }

        public String getName() {
            return this.value;
        }
    }
}

