/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.subscriptions;

import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.platform.GraphQlFieldArgumentBuilder;
import com.ontotext.platform.GraphQlQueryBuilderExtension;
import com.ontotext.platform.GraphQlRbac;
import com.ontotext.platform.GraphQlSchemaBuilderExtension;
import com.ontotext.platform.GraphQlTypeUtil;
import com.ontotext.platform.Utils;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLTypeReference;
import org.apache.commons.lang3.StringUtils;

public class SubscriptionsGraphQlQueryFields
implements GraphQlQueryBuilderExtension {
    @Override
    public void build(SomlSchema soml, GraphQLObjectType.Builder queryBuilder, GraphQlSchemaBuilderExtension.Options options) {
        if (!options.isSubscriptionsEnabled()) {
            return;
        }
        GraphQlRbac rbacBuilder = new GraphQlRbac(soml, options.isRbacEnabled());
        Utils.getObjectsNames(soml).forEach((name, object) -> {
            if (object.isApplicableForSubscription()) {
                GraphQLFieldDefinition.Builder fieldBuilder = this.buildObjectSubscriptionField((String)name);
                rbacBuilder.addQueryRoles(arg_0 -> ((GraphQLFieldDefinition.Builder)fieldBuilder).withDirective(arg_0), (Shape)object);
                queryBuilder.field(fieldBuilder.build());
            }
        });
    }

    private GraphQLFieldDefinition.Builder buildObjectSubscriptionField(String name) {
        GraphQLArgument whereArg = GraphQlFieldArgumentBuilder.where(name).build();
        return GraphQLFieldDefinition.newFieldDefinition().name(StringUtils.uncapitalize((String)name) + "_Subscription".toLowerCase()).description("Subscribe to " + name + " Mutation events from stream.transactionNumber to stream.transactionLimit. Filter the stream using the " + whereArg.getName() + " argument").argument(whereArg).argument(this.streamArg()).argument(this.subscriptionOp()).argument(GraphQlFieldArgumentBuilder.repository()).argument(GraphQlFieldArgumentBuilder.errorsFormat()).type((GraphQLOutputType)GraphQlTypeUtil.newNonNullList(name + "_Subscription"));
    }

    private GraphQLArgument streamArg() {
        return GraphQLArgument.newArgument().name("stream").type((GraphQLInputType)new GraphQLTypeReference("_SubscriptionStream")).build();
    }

    private GraphQLArgument subscriptionOp() {
        return GraphQLArgument.newArgument().name("subscriptionOp").type((GraphQLInputType)new GraphQLTypeReference("SubscriptionOp")).build();
    }
}

