/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.subscriptions;

import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.subscriptions.SubscriptionOp;
import com.ontotext.platform.GraphQlSchemaBuilderExtension;
import com.ontotext.platform.Utils;
import com.ontotext.platform.extended.scalars.DateTimeScalars;
import graphql.Scalars;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class GraphQlSubscriptionsBuilder
implements GraphQlSchemaBuilderExtension {
    public static final String SUBSCRIPTION_OP_ENUM = "SubscriptionOp";
    private static final String MUTATION_TYPE_ENUM = "SubscriptionMutationTypeEnum";

    @Override
    public void build(SomlSchema soml, GraphQLSchema.Builder schemaBuilder, GraphQlSchemaBuilderExtension.Options options) {
        schemaBuilder.additionalType(this.buildSubscriptionStreamInput());
        GraphQLEnumType mutationTypeEnum = GraphQlSubscriptionsBuilder.buildMutationTypeEnum();
        schemaBuilder.additionalType((GraphQLType)mutationTypeEnum);
        schemaBuilder.additionalType((GraphQLType)GraphQlSubscriptionsBuilder.buildSubscriptionOpEnum());
        schemaBuilder.additionalTypes(this.buildObjectsSubscriptionTypes(soml, mutationTypeEnum));
    }

    private GraphQLType buildSubscriptionStreamInput() {
        return GraphQLInputObjectType.newInputObject().name("_SubscriptionStream").field(this.transactionInputField()).field(this.transactionLimitInputField()).field(this.paginationOffsetField()).field(this.paginationLimitField()).field(this.excludeDeleteField()).build();
    }

    private GraphQLInputObjectField excludeDeleteField() {
        return GraphQLInputObjectField.newInputObjectField().name("excludeDeleted").description("Forces the stream to exclude deleted objects").type((GraphQLInputType)Scalars.GraphQLBoolean).defaultValue((Object)Boolean.FALSE).build();
    }

    private GraphQLInputObjectField paginationOffsetField() {
        return GraphQLInputObjectField.newInputObjectField().name("offset").description("The request pagination offset for the returned changes.").type((GraphQLInputType)Scalars.GraphQLInt).build();
    }

    private GraphQLInputObjectField paginationLimitField() {
        return GraphQLInputObjectField.newInputObjectField().name("limit").description("The request pagination limit for the returned changes.").type((GraphQLInputType)Scalars.GraphQLInt).build();
    }

    private GraphQLInputObjectField transactionInputField() {
        return GraphQLInputObjectField.newInputObjectField().name("transaction").description("The GraphDB transaction to retrieve mutation changes from the number of transactions").type((GraphQLInputType)Scalars.GraphQLString).build();
    }

    private GraphQLInputObjectField transactionLimitInputField() {
        return GraphQLInputObjectField.newInputObjectField().name("transactionLimit").description("Specifies the maximum number of transactions to read within GraphDB. These transactions will read and if required transformed into subscription events/objects. There will also need to be a GraphDB configurable size limit of {x} MB on the response that takes precedence over the number of objects specified in the limit argument.").type((GraphQLInputType)Scalars.GraphQLInt).build();
    }

    private static GraphQLEnumType buildMutationTypeEnum() {
        return GraphQLEnumType.newEnum().name(MUTATION_TYPE_ENUM).value("CREATE").value("UPDATE").value("DELETE").build();
    }

    private static GraphQLEnumType buildSubscriptionOpEnum() {
        return GraphQLEnumType.newEnum().name(SUBSCRIPTION_OP_ENUM).value(SubscriptionOp.READ.name()).value(SubscriptionOp.CREATE.name()).value(SubscriptionOp.DELETE.name()).build();
    }

    private Set<GraphQLType> buildObjectsSubscriptionTypes(SomlSchema soml, GraphQLEnumType mutationType) {
        return Utils.getObjectsNames(soml).entrySet().stream().filter(entry -> ((Shape)entry.getValue()).isApplicableForSubscription()).map(Map.Entry::getKey).map(name -> this.buildObjectSubscriptionType((String)name, mutationType)).collect(Collectors.toSet());
    }

    private GraphQLType buildObjectSubscriptionType(String shapeName, GraphQLEnumType mutationType) {
        return GraphQLObjectType.newObject().name(shapeName + "_Subscription").field(GraphQlSubscriptionsBuilder.mutationTypeField(shapeName, mutationType)).field(this.transactionOutputField()).field(this.transactionTimeField()).field(this.objectReferenceField(shapeName)).build();
    }

    private static GraphQLFieldDefinition mutationTypeField(String name, GraphQLEnumType mutationTypeEnum) {
        return GraphQLFieldDefinition.newFieldDefinition().name("_mutationType").description("Whether the " + name + " mutation was CREATE or UPDATE or DELETE").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)mutationTypeEnum)).build();
    }

    private GraphQLFieldDefinition transactionOutputField() {
        return GraphQLFieldDefinition.newFieldDefinition().name("_transaction").description("GraphDB transaction number that gave rise to the mutation").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).build();
    }

    private GraphQLFieldDefinition transactionTimeField() {
        return GraphQLFieldDefinition.newFieldDefinition().name("_transactionTime").description("GraphDB date/time stamp of the transaction").type((GraphQLOutputType)DateTimeScalars.DATE).build();
    }

    private GraphQLFieldDefinition objectReferenceField(String name) {
        return GraphQLFieldDefinition.newFieldDefinition().name(StringUtils.uncapitalize((String)name)).description("The " + name + " object which is CREATED or UPDATED or DELETED").type((GraphQLOutputType)new GraphQLTypeReference(name)).build();
    }
}

