/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.extended.scalars;

import com.google.common.primitives.UnsignedLong;
import com.ontotext.platform.extended.scalars.NumericScalarsUtil;
import graphql.GraphQLContext;
import graphql.GraphQLException;
import graphql.language.IntValue;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class UnsignedLongCoericing
implements Coercing<UnsignedLong, String> {
    public String serialize(Object input) {
        return this.convert(input, CoercingSerializeException::new).toString();
    }

    @NotNull
    public UnsignedLong parseValue(Object input) {
        return this.convert(input, CoercingParseValueException::new);
    }

    private UnsignedLong convert(Object input, Function<String, GraphQLException> excProvider) {
        if (input instanceof UnsignedLong) {
            return (UnsignedLong)input;
        }
        BigDecimal decimal = NumericScalarsUtil.toDecimal(input);
        if (decimal != null) {
            try {
                return UnsignedLong.valueOf((String)decimal.toBigIntegerExact().toString());
            }
            catch (ArithmeticException | NumberFormatException runtimeException) {
                // empty catch block
            }
        }
        throw excProvider.apply(String.format("Expected type 'UnsignedLong', but was '%s'.", NumericScalarsUtil.typeName(input)));
    }

    public UnsignedLong parseLiteral(Object input) {
        if (input instanceof StringValue) {
            String value = ((StringValue)input).getValue();
            try {
                return UnsignedLong.valueOf((String)value);
            }
            catch (NumberFormatException nfe) {
                throw new CoercingParseLiteralException(String.format("Unable to turn AST input into an 'UnsignedLong' : '%s'", value), (Throwable)nfe);
            }
        }
        try {
            if (input instanceof IntValue) {
                return UnsignedLong.valueOf((BigInteger)((IntValue)input).getValue());
            }
            if (input instanceof Long) {
                return UnsignedLong.valueOf((long)((Long)input));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        throw new CoercingParseLiteralException(String.format("Expected AST type 'IntValue', 'StringValue' or 'FloatValue' but was '%s'.", NumericScalarsUtil.typeName(input)));
    }

    public Value<?> valueToLiteral(Object input, GraphQLContext graphQlContext, Locale locale) {
        return IntValue.newIntValue((BigInteger)this.parseValue(input).bigIntegerValue()).build();
    }
}

