/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.extended.scalars;

import com.google.common.primitives.UnsignedInteger;
import com.ontotext.platform.extended.scalars.DecimalCoercing;
import com.ontotext.platform.extended.scalars.FloatCoercing;
import com.ontotext.platform.extended.scalars.IntegerCoercing;
import com.ontotext.platform.extended.scalars.UnsignedCoericing;
import com.ontotext.platform.extended.scalars.UnsignedLongCoericing;
import graphql.schema.Coercing;
import graphql.schema.GraphQLScalarType;
import java.math.BigInteger;

public class NumericScalars {
    private static final UnsignedInteger UNSIGNED_SHORT_MAX = UnsignedInteger.valueOf((long)65535L);
    private static final UnsignedInteger UNSIGNED_BYTE_MAX = UnsignedInteger.valueOf((long)255L);
    public static final GraphQLScalarType DECIMAL = GraphQLScalarType.newScalar().name("Decimal").description("Decimal infinite-precision number").coercing((Coercing)new DecimalCoercing()).build();
    public static final GraphQLScalarType UNSIGNED_LONG = GraphQLScalarType.newScalar().name("UnsignedLong").description("Unsigned 64-bit integer").coercing((Coercing)new UnsignedLongCoericing()).build();
    public static final GraphQLScalarType UNSIGNED_INTEGER = GraphQLScalarType.newScalar().name("UnsignedInteger").description("Unsigned 32-bit integer").coercing(new UnsignedCoericing<Long>("UnsignedInteger", UnsignedInteger.MAX_VALUE, UnsignedInteger::longValue)).build();
    public static final GraphQLScalarType UNSIGNED_SHORT = GraphQLScalarType.newScalar().name("UnsignedShort").description("Unsigned 16-bit integer").coercing(new UnsignedCoericing<Integer>("UnsignedShort", UNSIGNED_SHORT_MAX, UnsignedInteger::intValue)).build();
    public static final GraphQLScalarType UNSIGNED_BYTE = GraphQLScalarType.newScalar().name("UnsignedByte").description("Unsigned 8-bit integer").coercing(new UnsignedCoericing<Integer>("UnsignedByte", UNSIGNED_BYTE_MAX, UnsignedInteger::intValue)).build();
    public static final GraphQLScalarType INTEGER = GraphQLScalarType.newScalar().name("Integer").description("Integer, unlimited digits").coercing((Coercing)new IntegerCoercing("Integer", bigInt -> true)).build();
    public static final GraphQLScalarType POSITIVE_INTEGER = GraphQLScalarType.newScalar().name("PositiveInteger").description("Positive integer (>0), unlimited digits").coercing((Coercing)new IntegerCoercing("PositiveInteger", bigInt -> bigInt.compareTo(BigInteger.ZERO) > 0)).build();
    public static final GraphQLScalarType NON_POSITIVE_INTEGER = GraphQLScalarType.newScalar().name("NonPositiveInteger").description("Non-positive integer (<=0), unlimited digits").coercing((Coercing)new IntegerCoercing("NonPositiveInteger", bigInt -> bigInt.compareTo(BigInteger.ZERO) <= 0)).build();
    public static final GraphQLScalarType NEGATIVE_INTEGER = GraphQLScalarType.newScalar().name("NegativeInteger").description("Negative integer (<0), unlimited digits").coercing((Coercing)new IntegerCoercing("NegativeInteger", bigInt -> bigInt.compareTo(BigInteger.ZERO) < 0)).build();
    public static final GraphQLScalarType NON_NEGATIVE_INTEGER = GraphQLScalarType.newScalar().name("NonNegativeInteger").description("Non-negative integer (>=0), unlimited digits").coercing((Coercing)new IntegerCoercing("NonNegativeInteger", bigInt -> bigInt.compareTo(BigInteger.ZERO) >= 0)).build();
    public static final GraphQLScalarType NEGATIVE_FLOAT = GraphQLScalarType.newScalar().name("NegativeFloat").description("An Float scalar that must be a negative value").coercing((Coercing)new FloatCoercing("NegativeFloat", val -> val.compareTo(0.0) < 0)).build();
    public static final GraphQLScalarType NON_NEGATIVE_FLOAT = GraphQLScalarType.newScalar().name("NonNegativeFloat").description("An Float scalar that must be greater than or equal to zero").coercing((Coercing)new FloatCoercing("NonNegativeFloat", val -> val.compareTo(0.0) >= 0)).build();
    public static final GraphQLScalarType NON_POSITIVE_FLOAT = GraphQLScalarType.newScalar().name("NonPositiveFloat").description("An Float scalar that must be less than or equal to zero").coercing((Coercing)new FloatCoercing("NonPositiveFloat", val -> val.compareTo(0.0) <= 0)).build();
    public static final GraphQLScalarType POSITIVE_FLOAT = GraphQLScalarType.newScalar().name("PositiveFloat").description("An Float scalar that must be a positive value").coercing((Coercing)new FloatCoercing("PositiveFloat", dVal -> dVal.compareTo(0.0) > 0)).build();
}

