/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.extended.scalars;

import com.ontotext.platform.extended.scalars.NumericScalarsUtil;
import graphql.GraphQLContext;
import graphql.GraphQLException;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Predicate;

class IntegerCoercing
implements Coercing<BigInteger, String> {
    private final String expectedType;
    private final Predicate<BigInteger> valueVerifier;

    IntegerCoercing(String expectedType, Predicate<BigInteger> valueVerifier) {
        this.expectedType = expectedType;
        this.valueVerifier = valueVerifier;
    }

    public String serialize(Object dataFetcherResult) {
        BigInteger value = this.convert(dataFetcherResult, CoercingSerializeException::new);
        return this.verifyBeforeReturn(value, CoercingSerializeException::new).toString();
    }

    public BigInteger parseValue(Object input) {
        BigInteger value = this.convert(input, CoercingParseValueException::new);
        return this.verifyBeforeReturn(value, CoercingParseValueException::new);
    }

    private BigInteger convert(Object value, Function<String, GraphQLException> excProvider) throws GraphQLException {
        BigDecimal decimal = NumericScalarsUtil.toDecimal(value);
        if (decimal != null) {
            return decimal.toBigIntegerExact();
        }
        throw excProvider.apply(String.format("Expected type '%s' but was '%s'.", this.expectedType, NumericScalarsUtil.typeName(value)));
    }

    public BigInteger parseLiteral(Object input) {
        if (input instanceof StringValue) {
            return this.processStringValue(input);
        }
        if (input instanceof IntValue) {
            return this.processIntValue(input);
        }
        if (input instanceof FloatValue) {
            return this.processFloatValue(input);
        }
        throw new CoercingParseLiteralException(String.format("Expected AST type 'IntValue', 'StringValue' or 'FloatValue' but was '%s'.", NumericScalarsUtil.typeName(input)));
    }

    public Value<?> valueToLiteral(Object input, GraphQLContext graphQlContext, Locale locale) {
        return IntValue.newIntValue((BigInteger)this.parseValue(input)).build();
    }

    private BigInteger processStringValue(Object value) throws CoercingParseLiteralException {
        String valueAsString = ((StringValue)StringValue.class.cast(value)).getValue();
        try {
            BigInteger bigInt = new BigDecimal(valueAsString).toBigIntegerExact();
            return this.verifyBeforeReturn(bigInt, CoercingParseLiteralException::new);
        }
        catch (ArithmeticException | NumberFormatException exc) {
            throw new CoercingParseLiteralException(String.format("Unable to turn AST input into a 'BigInteger' : '%s'", valueAsString));
        }
    }

    private BigInteger processIntValue(Object value) throws CoercingParseLiteralException {
        BigInteger bigInt = ((IntValue)IntValue.class.cast(value)).getValue();
        return this.verifyBeforeReturn(bigInt, CoercingParseLiteralException::new);
    }

    private BigInteger processFloatValue(Object value) throws CoercingParseLiteralException {
        try {
            BigInteger bigInt = ((FloatValue)FloatValue.class.cast(value)).getValue().toBigIntegerExact();
            return this.verifyBeforeReturn(bigInt, CoercingParseLiteralException::new);
        }
        catch (ArithmeticException arite) {
            throw new CoercingParseLiteralException(String.format("Unable to turn AST input into a 'BigInteger' : '%s'", value));
        }
    }

    private BigInteger verifyBeforeReturn(BigInteger bigInt, Function<String, GraphQLException> excProvider) {
        if (!this.valueVerifier.test(bigInt)) {
            throw excProvider.apply(String.format("Expected value to be in the '%s' range, but it was '%s'", this.expectedType, bigInt));
        }
        return bigInt;
    }
}

