/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.extended.scalars;

import graphql.GraphQLContext;
import graphql.GraphQLException;
import graphql.Scalars;
import graphql.language.FloatValue;
import graphql.language.Value;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Predicate;

class FloatCoercing
implements Coercing<Double, String> {
    private final String type;
    private final Predicate<Double> valueVerifier;

    FloatCoercing(String type, Predicate<Double> valueVerifier) {
        this.type = type;
        this.valueVerifier = valueVerifier;
    }

    public String serialize(Object dataFetcherResult) {
        Double value = (Double)Scalars.GraphQLFloat.getCoercing().serialize(dataFetcherResult);
        return this.verify(value, CoercingSerializeException::new).toString();
    }

    public Double parseValue(Object input) {
        Double value = (Double)Scalars.GraphQLFloat.getCoercing().parseValue(input);
        return this.verify(value, CoercingParseValueException::new);
    }

    public Double parseLiteral(Object input) {
        Double value = (Double)Scalars.GraphQLFloat.getCoercing().parseLiteral(input);
        return this.verify(value, CoercingParseLiteralException::new);
    }

    public Value<?> valueToLiteral(Object input, GraphQLContext graphQlContext, Locale locale) {
        return FloatValue.of((double)this.parseValue(input));
    }

    private Double verify(Double value, Function<String, GraphQLException> exceptionProvider) {
        if (!this.valueVerifier.test(value)) {
            throw exceptionProvider.apply(String.format("Value is not of type '%s', got %s", this.type, value));
        }
        return value;
    }
}

