/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform;

import com.ontotext.models.SomlConversionException;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.SomlSchemaConverter;
import com.ontotext.platform.GraphQlPrinterUtil;
import com.ontotext.platform.GraphQlSchemaBuilderExtension;
import com.ontotext.platform.transformer.ApolloGraphQlSchemaTransformer;
import com.ontotext.platform.transformer.FullGraphQlSchemaTransformer;
import com.ontotext.platform.transformer.GraphQlSchemaTransformer;
import com.ontotext.soaas.plugin.PluginsManager;
import graphql.GraphQLException;
import graphql.schema.GraphQLSchema;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SomlToGraphQlSchemaConverter
implements SomlSchemaConverter<GraphQLSchema> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SomlToGraphQlSchemaConverter.class);
    private final boolean enableMutations;
    private final boolean enableGeneration;
    private final boolean enableFederation;
    private final boolean enableRbac;
    private final boolean enableSubscriptions;
    private final boolean reducedGraphqlSchema;
    private List<GraphQlSchemaBuilderExtension> builders;
    private List<GraphQlSchemaTransformer> transformers;

    public SomlToGraphQlSchemaConverter() {
        this(true, true, false, true, false, true);
    }

    public SomlToGraphQlSchemaConverter(boolean enableMutations, boolean enableGeneration, boolean enableFederation, boolean enableRbac, boolean enableSubscriptions, boolean reducedGraphqlSchema) {
        this.enableMutations = enableMutations;
        this.enableGeneration = enableGeneration;
        this.enableFederation = enableFederation;
        this.enableRbac = enableRbac;
        this.enableSubscriptions = enableSubscriptions;
        this.reducedGraphqlSchema = reducedGraphqlSchema;
        this.getBuilders();
        this.getTransformers();
    }

    public GraphQLSchema convert(SomlSchema somlSchema) throws SomlConversionException {
        long startTime = System.currentTimeMillis();
        GraphQLSchema.Builder schemaBuilder = GraphQLSchema.newSchema();
        GraphQlSchemaBuilderExtension.Options options = this.buildOptions(somlSchema);
        for (GraphQlSchemaBuilderExtension builder : this.getBuilders()) {
            try {
                builder.build(somlSchema, schemaBuilder, options);
            }
            catch (GraphQLException gqe) {
                throw new SomlConversionException(gqe.getMessage(), (Throwable)gqe);
            }
        }
        for (GraphQlSchemaTransformer transformer : this.getTransformers()) {
            transformer.transform(schemaBuilder);
        }
        GraphQLSchema schema = schemaBuilder.build();
        for (GraphQlSchemaTransformer transformer : this.getTransformers()) {
            schema = transformer.transform(schema);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(GraphQlPrinterUtil.print(schema));
        }
        LOGGER.info("Outputting GraphQL schema. Conversion took {} ms.", (Object)(System.currentTimeMillis() - startTime));
        return schema;
    }

    private GraphQlSchemaBuilderExtension.Options buildOptions(SomlSchema somlSchema) throws SomlConversionException {
        boolean localMutationsEnabled = this.areMutationsEnabled(somlSchema);
        Set objectPropertyRanges = somlSchema.getObjects().getAllObjectPropertyRanges();
        return new GraphQlSchemaBuilderExtension.Options(localMutationsEnabled, this.enableGeneration, this.enableRbac, this.enableSubscriptions, this.enableFederation, this.reducedGraphqlSchema, objectPropertyRanges);
    }

    private boolean areMutationsEnabled(SomlSchema somlSchema) throws SomlConversionException {
        boolean localMutationsEnabled;
        boolean mutationsExplicitlyEnabledInModel = somlSchema.getConfig().areMutationsEnabled().filter(Predicate.isEqual(Boolean.TRUE)).isPresent();
        if (!this.enableMutations && mutationsExplicitlyEnabledInModel) {
            LOGGER.warn("Mutations are disabled for the SOAAS instance. Cannot enable them for model: {}", (Object)somlSchema.getId());
            throw new SomlConversionException("Mutations are disabled for the SOAAS instance");
        }
        boolean bl = localMutationsEnabled = this.enableMutations && somlSchema.getConfig().areMutationsEnabled().orElse(this.enableMutations) != false;
        if (!localMutationsEnabled) {
            LOGGER.warn("Mutations are disabled for model: {}", (Object)somlSchema.getId());
        }
        return localMutationsEnabled;
    }

    private List<GraphQlSchemaBuilderExtension> getBuilders() {
        if (this.builders == null) {
            this.builders = PluginsManager.loadPlugins(GraphQlSchemaBuilderExtension.class);
        }
        return this.builders;
    }

    private List<GraphQlSchemaTransformer> getTransformers() {
        if (this.transformers == null) {
            List schemaTransformers = PluginsManager.loadPlugins(GraphQlSchemaTransformer.class);
            if (!this.enableFederation) {
                schemaTransformers.removeIf(FullGraphQlSchemaTransformer.class::isInstance);
                schemaTransformers.removeIf(ApolloGraphQlSchemaTransformer.class::isInstance);
            }
            schemaTransformers.forEach(transformer -> transformer.init(this.builders));
            this.transformers = schemaTransformers;
        }
        return this.transformers;
    }
}

