/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform;

import com.ontotext.models.EnumValueDef;
import com.ontotext.models.Properties;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.ScalarType;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.templates.Template;
import com.ontotext.models.templates.TemplateArgs;
import com.ontotext.platform.FilterMap;
import com.ontotext.platform.GraphQlSchemaBuilderExtension;
import com.ontotext.platform.GraphQlTypeUtil;
import graphql.Scalars;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedInputType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

public class GraphQlScalarTypesBuilder
implements GraphQlSchemaBuilderExtension {
    private Map<String, GraphQLScalarType> scalarTypeMap = new HashMap<String, GraphQLScalarType>(GraphQlTypeUtil.getScalarTypeMap());
    private static final String FILTER_OBJECTS_SUFFIX = "_Where";
    private static final String FILTER_MULTI_SUFFIX = "_Multi";
    private static final String MULTIVALUE_INPUT = "_Multi_Value_Input";

    @Override
    public void build(SomlSchema somlSchema, GraphQLSchema.Builder schemaBuilder, GraphQlSchemaBuilderExtension.Options options) {
        UsedPropertiesCollector usedProperties = new UsedPropertiesCollector(options);
        usedProperties.collectUsedTypes(somlSchema);
        this.addGraphQlScalars(schemaBuilder, usedProperties);
        this.addSchemaEnums(somlSchema, schemaBuilder, usedProperties);
    }

    private void addGraphQlScalars(GraphQLSchema.Builder schemaBuilder, UsedPropertiesCollector usedProperties) {
        for (GraphQLScalarType scalarType : this.scalarTypeMap.values()) {
            if (!usedProperties.shouldAddType(scalarType.getName())) continue;
            if (usedProperties.isMultiScalarAllowed(scalarType.getName())) {
                this.buildScalarFilterInputObject(schemaBuilder, (GraphQLNamedInputType)scalarType, true);
            }
            if (usedProperties.isSingleScalarAllowed(scalarType.getName())) {
                this.buildScalarFilterInputObject(schemaBuilder, (GraphQLNamedInputType)scalarType, false);
            }
            if (!usedProperties.isMultiScalarInMutationAllowed(scalarType.getName())) continue;
            this.buildScalarUpdateInputObject(schemaBuilder, (GraphQLNamedInputType)scalarType);
        }
    }

    private void addSchemaEnums(SomlSchema somlSchema, GraphQLSchema.Builder schemaBuilder, UsedPropertiesCollector usedProperties) {
        for (ScalarType scalarType : somlSchema.getTypes().values()) {
            if (!scalarType.isEnum() || !usedProperties.isTypeUsed(scalarType.getGraphql())) continue;
            GraphQLEnumType enumType = this.registerEnumType(schemaBuilder, scalarType);
            if (usedProperties.isMultiScalarAllowed(scalarType.getGraphql())) {
                this.buildScalarFilterInputObject(schemaBuilder, (GraphQLNamedInputType)enumType, true);
            }
            if (usedProperties.isSingleScalarAllowed(scalarType.getGraphql())) {
                this.buildScalarFilterInputObject(schemaBuilder, (GraphQLNamedInputType)enumType, false);
            }
            if (!usedProperties.isMultiScalarInMutationAllowed(scalarType.getGraphql())) continue;
            this.buildScalarUpdateInputObject(schemaBuilder, (GraphQLNamedInputType)enumType);
        }
    }

    private GraphQLEnumType registerEnumType(GraphQLSchema.Builder schemaBuilder, ScalarType scalarType) {
        GraphQLEnumType.Builder builder = GraphQLEnumType.newEnum().name(scalarType.getGraphql());
        for (EnumValueDef typeValue : scalarType.getValues()) {
            builder.value(typeValue.getName(), typeValue.getValue(), typeValue.getLabel());
        }
        GraphQLEnumType enumType = builder.build();
        schemaBuilder.additionalType((GraphQLType)enumType);
        return enumType;
    }

    private void buildScalarFilterInputObject(GraphQLSchema.Builder schemaBuilder, GraphQLNamedInputType scalarType, boolean addMultiComparisons) {
        String scalarName = scalarType.getName();
        Object ioName = scalarName;
        ioName = (String)ioName + FILTER_OBJECTS_SUFFIX;
        String description = scalarName + " comparisons";
        if (addMultiComparisons) {
            ioName = (String)ioName + FILTER_MULTI_SUFFIX;
            description = description + " for multi-value fields";
        } else {
            description = description + " for single-value fields";
        }
        GraphQLInputObjectType.Builder ioBuilder = GraphQLInputObjectType.newInputObject().name((String)ioName).description(description);
        ioBuilder.fields(this.addScalarFieldsIo(FilterMap.getCommonFiltersMap(), scalarName, (GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)new GraphQLTypeReference((String)ioName)))));
        ioBuilder.fields(this.addScalarFieldsIo(FilterMap.getEqualityFiltersMap(), scalarName, (GraphQLInputType)scalarType));
        if (!scalarName.equals(Scalars.GraphQLID.getName())) {
            ioBuilder.fields(this.addScalarFieldsIo(FilterMap.getStringNumberFiltersMap(), scalarName, (GraphQLInputType)scalarType));
        }
        ioBuilder.fields(this.addScalarFieldsIo(FilterMap.getListFiltersMap(), scalarName, (GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)scalarType))));
        if (scalarName.equals(Scalars.GraphQLString.getName()) || scalarName.equals(Scalars.GraphQLID.getName())) {
            ioBuilder.fields(this.addScalarFieldsIo(FilterMap.getStringFiltersMap(), scalarName, (GraphQLInputType)Scalars.GraphQLString));
        }
        if (addMultiComparisons) {
            ioBuilder.fields(this.addScalarFieldsIo(FilterMap.getObjectAllFiltersMap(), scalarName, (GraphQLInputType)new GraphQLTypeReference((String)ioName)));
        }
        schemaBuilder.additionalType((GraphQLType)ioBuilder.build());
    }

    private List<GraphQLInputObjectField> addScalarFieldsIo(Map<String, String> filterMap, String scalarName, GraphQLInputType inputType) {
        ArrayList<GraphQLInputObjectField> newFields = new ArrayList<GraphQLInputObjectField>();
        for (Map.Entry<String, String> entry : filterMap.entrySet()) {
            String description = String.format(entry.getValue(), scalarName);
            newFields.add(GraphQLInputObjectField.newInputObjectField().name(entry.getKey()).description(description).type(inputType).build());
        }
        return newFields;
    }

    private void buildScalarUpdateInputObject(GraphQLSchema.Builder schemaBuilder, GraphQLNamedInputType scalarType) {
        String name = scalarType.getName() + MULTIVALUE_INPUT;
        GraphQLInputObjectType.Builder ioBuilder = GraphQLInputObjectType.newInputObject().name(name);
        ioBuilder.description("Input for updating multi-value " + scalarType.getName() + " fields");
        ioBuilder.field(GraphQLInputObjectField.newInputObjectField().name("value").description("Values to add to the affected property").type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)scalarType)))).field(GraphQLInputObjectField.newInputObjectField().name("patch").type((GraphQLInputType)scalarType).description("Replace values matching this property. Cannot be combined with replace")).field(GraphQLInputObjectField.newInputObjectField().name("replace").description("Overwrite all values for this property. Defaults to false.").type((GraphQLInputType)Scalars.GraphQLBoolean).defaultValueProgrammatic((Object)false));
        schemaBuilder.additionalType((GraphQLType)ioBuilder.build());
    }

    private static class UsedPropertiesCollector {
        private final Set<String> singleProperties = new HashSet<String>();
        private final Set<String> multiProperties = new HashSet<String>();
        private final boolean fullGraphqlSchema;
        private final boolean mutationsEnabled;

        UsedPropertiesCollector(GraphQlSchemaBuilderExtension.Options options) {
            this.fullGraphqlSchema = !options.isReducedGraphqlSchema();
            this.mutationsEnabled = options.areMutationsEnabled();
        }

        public void collectUsedTypes(SomlSchema schema) {
            ScalarType stringType = (ScalarType)schema.getTypes().get((Object)"string");
            BiConsumer<Boolean, String> consumer = (singleValued, type) -> {
                if (Boolean.TRUE.equals(singleValued)) {
                    this.singleProperties.add((String)type);
                } else {
                    this.multiProperties.add((String)type);
                }
            };
            for (Shape shape : schema.getObjects().values()) {
                this.collectPropertiesTypes(schema, stringType, shape.getAllProperties(), consumer);
            }
            this.collectPropertiesTypes(schema, stringType, schema.getProperties(), consumer);
        }

        private void collectPropertiesTypes(SomlSchema schema, ScalarType stringType, Properties properties, BiConsumer<Boolean, String> consume) {
            for (PropertyShape prop : properties.values()) {
                Template template;
                ScalarType scalarType = prop.getScalarType();
                if (scalarType != null) {
                    consume.accept(prop.isSingleValued(), scalarType.getGraphql());
                }
                if ((template = prop.getSparqlTemplate()) == null || !template.hasArgs()) continue;
                for (TemplateArgs arg : template.getKeys().values()) {
                    ScalarType type = (ScalarType)schema.getTypes().getOrDefault((Object)arg.getType(), (Object)stringType);
                    consume.accept(prop.isSingleValued(), type.getGraphql());
                }
            }
        }

        boolean isTypeUsed(String name) {
            return this.singleProperties.contains(name) || this.multiProperties.contains(name);
        }

        boolean shouldAddType(String name) {
            return this.fullGraphqlSchema || this.isTypeUsed(name);
        }

        boolean isSingleScalarAllowed(String name) {
            return this.fullGraphqlSchema || this.singleProperties.contains(name);
        }

        boolean isMultiScalarAllowed(String name) {
            return this.fullGraphqlSchema || this.multiProperties.contains(name);
        }

        boolean isMultiScalarInMutationAllowed(String name) {
            return this.fullGraphqlSchema || this.multiProperties.contains(name) && this.mutationsEnabled;
        }
    }
}

