/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform;

import com.ontotext.models.SomlSchema;
import com.ontotext.platform.GraphQlRbac;
import com.ontotext.platform.GraphQlSchemaBuilderExtension;
import com.ontotext.platform.GraphQlTypeUtil;
import graphql.Scalars;
import graphql.introspection.Introspection;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import java.util.Collections;

public class GraphQlRbacBuilder
implements GraphQlSchemaBuilderExtension {
    public static final String ROLE_TYPE_NAME = "_Role";

    @Override
    public void build(SomlSchema somlSchema, GraphQLSchema.Builder schemaBuilder, GraphQlSchemaBuilderExtension.Options options) {
        if (options.isRbacEnabled()) {
            this.createHasRoleInputType(schemaBuilder);
            this.addRoleDirectiveToSchema(schemaBuilder);
        }
    }

    private void addRoleDirectiveToSchema(GraphQLSchema.Builder schemaBuilder) {
        GraphQLDirective.Builder roleDirective = GraphQlRbac.createHasRolesDirective(Collections.emptyMap());
        schemaBuilder.additionalDirective(roleDirective.validLocations(new Introspection.DirectiveLocation[]{Introspection.DirectiveLocation.QUERY, Introspection.DirectiveLocation.MUTATION, Introspection.DirectiveLocation.OBJECT, Introspection.DirectiveLocation.INTERFACE, Introspection.DirectiveLocation.FIELD_DEFINITION, Introspection.DirectiveLocation.INPUT_OBJECT, Introspection.DirectiveLocation.INPUT_FIELD_DEFINITION, Introspection.DirectiveLocation.UNION}).build());
    }

    private void createHasRoleInputType(GraphQLSchema.Builder schemaBuilder) {
        GraphQLInputObjectType.Builder roleBuilder = GraphQLInputObjectType.newInputObject().name(ROLE_TYPE_NAME).description("Available roles for the hasRole directive");
        GraphQLInputObjectField.Builder nameField = GraphQLInputObjectField.newInputObjectField().name("name").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString));
        GraphQLInputObjectField.Builder actionsField = GraphQLInputObjectField.newInputObjectField().name("actions").type((GraphQLInputType)GraphQlTypeUtil.newNonNullListType((GraphQLType)Scalars.GraphQLString));
        GraphQLInputObjectField.Builder notActionsField = GraphQLInputObjectField.newInputObjectField().name("not_actions").type((GraphQLInputType)GraphQlTypeUtil.newNonNullListType((GraphQLType)Scalars.GraphQLString));
        roleBuilder.field(nameField).field(actionsField).field(notActionsField);
        schemaBuilder.additionalType((GraphQLType)roleBuilder.build());
    }
}

