/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform;

import com.ontotext.models.RoleAction;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.security.ModelRestrictions;
import com.ontotext.models.security.ShapeRestrictions;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GraphQlRbac {
    static final String ROLE_TYPE = "Role";
    static final String ROLE_NAME = "name";
    static final String ROLE_ACTIONS = "actions";
    static final String ROLE_NOT_ACTIONS = "not_actions";
    private final SomlSchema somlSchema;
    private final boolean rbacEnabled;

    public GraphQlRbac(SomlSchema somlSchema, boolean rbacEnabled) {
        this.somlSchema = somlSchema;
        this.rbacEnabled = rbacEnabled;
    }

    static GraphQLDirective.Builder createHasRolesDirective(Map<String, Set<RoleAction>> roles) {
        GraphQLArgument.Builder rolesArgument = GraphQLArgument.newArgument().name("roles").type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)new GraphQLTypeReference("_Role"))));
        if (!roles.isEmpty()) {
            GraphQlRbac.createRolesList(roles, rolesArgument);
        }
        return GraphQLDirective.newDirective().name("hasRole").argument(rolesArgument);
    }

    private static void createRolesList(Map<String, Set<RoleAction>> roles, GraphQLArgument.Builder rolesArgument) {
        ArrayList list = new ArrayList(roles.size());
        roles.forEach((key, value) -> {
            LinkedHashMap<String, Object> roleObject = new LinkedHashMap<String, Object>(3);
            roleObject.put(ROLE_NAME, key);
            roleObject.put(ROLE_ACTIONS, GraphQlRbac.roleActionToString(value, GraphQlRbac::actionsProvider));
            roleObject.put(ROLE_NOT_ACTIONS, GraphQlRbac.roleActionToString(value, GraphQlRbac::notActionsProvider));
            list.add(roleObject);
        });
        rolesArgument.value(list);
    }

    private static Stream<RoleAction> actionsProvider(RoleAction roleAction) {
        return roleAction.getContainedIn().getActions().stream().sorted(Comparator.comparing(RoleAction::getAction));
    }

    private static Stream<RoleAction> notActionsProvider(RoleAction roleAction) {
        return roleAction.getContainedIn().getNotActions().stream().sorted(Comparator.comparing(RoleAction::getAction));
    }

    private static Object roleActionToString(Set<RoleAction> roleActions, Function<RoleAction, Stream<RoleAction>> actionsProvider) {
        return roleActions.stream().flatMap(actionsProvider).map(RoleAction::getAction).collect(Collectors.toList());
    }

    void addTypeLevelRoles(Consumer<GraphQLDirective.Builder> directiveConsumer, Shape shape) {
        Map<String, Set<RoleAction>> allRoles;
        if (this.rbacEnabled && !(allRoles = this.getAllRoles(shape.getId())).isEmpty()) {
            directiveConsumer.accept(GraphQlRbac.createHasRolesDirective(allRoles));
        }
    }

    public void addQueryRoles(Consumer<GraphQLDirective.Builder> directiveConsumer, Shape shape) {
        Map<String, Set<RoleAction>> readRoles;
        if (this.rbacEnabled && !(readRoles = this.getReadRoles(shape.getId())).isEmpty()) {
            directiveConsumer.accept(GraphQlRbac.createHasRolesDirective(readRoles));
        }
    }

    void addEditRoles(Consumer<GraphQLDirective.Builder> directiveConsumer, Shape shape) {
        Map<String, Set<RoleAction>> writeRoles;
        if (this.rbacEnabled && !(writeRoles = this.getWriteRoles(shape.getId())).isEmpty()) {
            directiveConsumer.accept(GraphQlRbac.createHasRolesDirective(writeRoles));
        }
    }

    void addDeleteRoles(Consumer<GraphQLDirective.Builder> directiveConsumer, Shape shape) {
        Map<String, Set<RoleAction>> deleteRoles;
        if (this.rbacEnabled && !(deleteRoles = this.getDeleteRoles(shape.getId())).isEmpty()) {
            directiveConsumer.accept(GraphQlRbac.createHasRolesDirective(deleteRoles));
        }
    }

    Map<String, Set<RoleAction>> getAllRoles(String shapeId) {
        return this.getRestrictions(shapeId, ModelRestrictions::getAllRoleActions);
    }

    Map<String, Set<RoleAction>> getReadRoles(String shapeId) {
        if (this.rbacEnabled) {
            return this.getRestrictions(shapeId, ModelRestrictions::getReadRoleActions);
        }
        return Collections.emptyMap();
    }

    Map<String, Set<RoleAction>> getWriteRoles(String shapeId) {
        return this.getRestrictions(shapeId, ModelRestrictions::getWriteRoleActions);
    }

    Map<String, Set<RoleAction>> getDeleteRoles(String shapeId) {
        return this.getRestrictions(shapeId, ModelRestrictions::getDeleteRoleActions);
    }

    private Map<String, Set<RoleAction>> getRestrictions(String shapeId, Function<ShapeRestrictions, Map<String, Set<RoleAction>>> mapper) {
        ShapeRestrictions shapeRestrictions = this.somlSchema.getRbac().getRestrictions().getShapeRestrictions(shapeId);
        if (shapeRestrictions != null) {
            return mapper.apply(shapeRestrictions);
        }
        return Collections.emptyMap();
    }

    Map<String, Set<RoleAction>> getAllPropertyRoles(String shapeName, String propertyShape) {
        if (this.rbacEnabled) {
            return this.getPropertyRestrictions(shapeName, propertyShape, ModelRestrictions::getAllRoleActions);
        }
        return Collections.emptyMap();
    }

    Map<String, Set<RoleAction>> getPropertyReadRoles(String shapeName, String propertyShape) {
        if (this.rbacEnabled) {
            return this.getPropertyRestrictions(shapeName, propertyShape, ModelRestrictions::getReadRoleActions);
        }
        return Collections.emptyMap();
    }

    Map<String, Set<RoleAction>> getPropertyWriteRoles(String shapeName, String propertyShape) {
        if (this.rbacEnabled) {
            return this.getPropertyRestrictions(shapeName, propertyShape, ModelRestrictions::getWriteRoleActions);
        }
        return Collections.emptyMap();
    }

    Consumer<GraphQLInputObjectField.Builder> createTypeReadBuilder(String shapeId) {
        Map<String, Set<RoleAction>> readRoles = this.getReadRoles(shapeId);
        if (readRoles.isEmpty()) {
            return builder -> {};
        }
        return builder -> builder.withDirective(GraphQlRbac.createHasRolesDirective(readRoles));
    }

    Consumer<GraphQLInputObjectField.Builder> createPropertyReadBuilder(String shapeId, String propertyName) {
        Map<String, Set<RoleAction>> readRoles = this.getPropertyReadRoles(shapeId, propertyName);
        if (readRoles.isEmpty()) {
            return builder -> {};
        }
        return builder -> builder.withDirective(GraphQlRbac.createHasRolesDirective(readRoles));
    }

    Consumer<GraphQLInputObjectField.Builder> createPropertyWriteBuilder(String shapeId, String propertyName) {
        Map<String, Set<RoleAction>> writeRoles = this.getPropertyWriteRoles(shapeId, propertyName);
        if (writeRoles.isEmpty()) {
            return builder -> {};
        }
        return builder -> builder.withDirective(GraphQlRbac.createHasRolesDirective(writeRoles));
    }

    private Map<String, Set<RoleAction>> getPropertyRestrictions(String shapeName, String propertyShape, Function<ModelRestrictions, Map<String, Set<RoleAction>>> mapper) {
        ShapeRestrictions shapeRestrictions = this.somlSchema.getRbac().getRestrictions().getShapeRestrictions(shapeName);
        if (shapeRestrictions != null) {
            return mapper.apply(shapeRestrictions.getPropertyRestrictions(propertyShape));
        }
        return Collections.emptyMap();
    }

    void addAllPropertyRoles(String shapeName, String propertyName, GraphQLFieldDefinition.Builder fieldDefinitionBuilder) {
        Map<String, Set<RoleAction>> allRoles;
        if (this.rbacEnabled && !(allRoles = this.getAllPropertyRoles(shapeName, propertyName)).isEmpty()) {
            fieldDefinitionBuilder.withDirective(GraphQlRbac.createHasRolesDirective(allRoles));
        }
    }
}

