/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform;

import com.ontotext.models.SomlConversionException;
import com.ontotext.models.SomlSchema;
import com.ontotext.platform.GraphQlQueryBuilderExtension;
import com.ontotext.platform.GraphQlSchemaBuilderExtension;
import com.ontotext.soaas.plugin.PluginsManager;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import java.util.List;

public class GraphQlQueryBuilder
implements GraphQlSchemaBuilderExtension {
    private List<GraphQlQueryBuilderExtension> queryBuilderExtensions;

    @Override
    public void build(SomlSchema somlSchema, GraphQLSchema.Builder schemaBuilder, GraphQlSchemaBuilderExtension.Options options) throws SomlConversionException {
        GraphQLObjectType.Builder queryBuilder = GraphQLObjectType.newObject().name("Query").description("Root queries");
        for (GraphQlQueryBuilderExtension extension : this.getQueryBuilderExtensions()) {
            extension.build(somlSchema, queryBuilder, options);
        }
        schemaBuilder.query(queryBuilder.build());
    }

    private List<GraphQlQueryBuilderExtension> getQueryBuilderExtensions() {
        if (this.queryBuilderExtensions == null) {
            this.queryBuilderExtensions = PluginsManager.loadPlugins(GraphQlQueryBuilderExtension.class);
        }
        return this.queryBuilderExtensions;
    }
}

