/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform;

import com.ontotext.platform.GraphQlTypeUtil;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import org.apache.commons.lang3.StringUtils;

public class GraphQlPropertyTypeCalculator {
    private GraphQlPropertyTypeCalculator() {
    }

    public static GraphQLType computeInputGraphQlType(String rawType, boolean isRequired, boolean multivalued, boolean isInternalTypeRequired) {
        GraphQLType type = GraphQlPropertyTypeCalculator.getGraphqlType(rawType);
        if (multivalued) {
            type = GraphQlPropertyTypeCalculator.makeList(type, isInternalTypeRequired);
        }
        return isRequired ? new GraphQLNonNull(type) : type;
    }

    private static GraphQLType getGraphqlType(String rawType) {
        String type = (String)StringUtils.defaultIfBlank((CharSequence)rawType, (CharSequence)"String");
        return GraphQlTypeUtil.getScalarOrReference(type);
    }

    private static GraphQLType makeList(GraphQLType type, boolean isTypeRequired) {
        return isTypeRequired ? GraphQlTypeUtil.newNonNullListType(type) : new GraphQLList(type);
    }

    public static GraphQLOutputType computeOutputGraphQlType(String rawType, boolean isNonNullable, boolean multivalued, Boolean nonNullableElements) {
        GraphQLType type = GraphQlPropertyTypeCalculator.getGraphqlType(rawType);
        if (multivalued) {
            type = GraphQlPropertyTypeCalculator.makeList(type, nonNullableElements);
        }
        return isNonNullable ? new GraphQLNonNull(type) : (GraphQLOutputType)type;
    }
}

