/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform;

import com.google.common.collect.ImmutableSet;
import com.ontotext.models.Configs;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.platform.DirectivesBuilder;
import com.ontotext.platform.GraphQlFieldArgumentBuilder;
import com.ontotext.platform.GraphQlPropertyTypeCalculator;
import com.ontotext.platform.GraphQlRbac;
import com.ontotext.platform.GraphQlSchemaBuilderExtension;
import com.ontotext.platform.GraphQlTypeUtil;
import graphql.Scalars;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQlMutationBuilder
implements GraphQlSchemaBuilderExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String MUTATION_RESPONSE_SUFFIX = "_Mutation_Response";
    private static final String OBJECTS_ARGUMENT = "objects";
    private static final String CREATE_INPUT_SUFFIX = "_Create_Input";
    private static final String UPDATE_INPUT_SUFFIX = "_Update_Input";
    private static final String DELETE_INPUT_FILTER = "_Delete_Filter";
    private static final String CREATE_PREFIX = "create_";
    private static final String UPDATE_PREFIX = "update_";
    private static final String DELETE_PREFIX = "delete_";
    private static final String WHERE = "where";
    private static final String FILTER_OBJECTS_SUFFIX = "_Where";
    private static final String FILTER_MULTI_SUFFIX = "_Multi";
    private static final String NESTED_SUFFIX = "_Nested";
    private static final String MULTIVALUE_INPUT = "_Multi_Value_Input";
    private static final String ID_NAME = "ID";
    private static final Set<String> NONE_MUTATION_INPUTS = ImmutableSet.builder().add((Object)"Nameable").addAll((Iterable)Shapes.AFFECTED_TYPES).addAll((Iterable)Shapes.RESPONSE_TYPES).build();
    private static final String GRAPH_ARGUMENT = "graph";
    private static Set<String> ignoreShapeIds = new HashSet<String>();

    @Override
    public void build(SomlSchema somlSchema, GraphQLSchema.Builder schemaBuilder, GraphQlSchemaBuilderExtension.Options options) {
        if (!options.areMutationsEnabled()) {
            return;
        }
        GraphQlRbac rbacBuilder = new GraphQlRbac(somlSchema, options.isRbacEnabled());
        GraphQLObjectType.Builder mutationBuilder = GraphQLObjectType.newObject().name("Mutation");
        mutationBuilder.description("Root mutations");
        for (Shape singleShape : somlSchema.getObjects().values()) {
            if (ignoreShapeIds.contains(singleShape.getId()) || Boolean.TRUE.equals(singleShape.isSynthetic())) continue;
            if (!GraphQlTypeUtil.getNotQueryableTypes().contains(singleShape.getId()) && this.hasMutableProperties(singleShape)) {
                if (singleShape.isMutable() && !singleShape.isUnion()) {
                    this.buildMutationFields(somlSchema, rbacBuilder, mutationBuilder, singleShape);
                    schemaBuilder.additionalType(this.buildMutationResponseType(singleShape));
                }
                this.addMutationInputTypes(singleShape, schemaBuilder, options, rbacBuilder);
                continue;
            }
            if (!this.isLiteral(singleShape)) continue;
            this.addMutationLiteralInputTypes(singleShape, schemaBuilder, options, rbacBuilder);
        }
        GraphQLObjectType mutation = mutationBuilder.build();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(mutation.toString());
        }
        schemaBuilder.mutation(mutation);
    }

    private boolean hasMutableProperties(Shape shape) {
        SomlSchema somlSchema = shape.getContainedIn().getContainedIn();
        if (shape.isUnion()) {
            return shape.getUnionOfShapes().stream().anyMatch(this::hasMutableProperties);
        }
        return Stream.concat(shape.getProps().values().stream(), somlSchema.getObjects().getHierarchy(shape.getId()).stream().flatMap(subType -> subType.getProps().values().stream())).anyMatch(PropertyShape::isMutable);
    }

    private void buildMutationFields(SomlSchema somlSchema, GraphQlRbac rbacBuilder, GraphQLObjectType.Builder mutationBuilder, Shape singleShape) {
        if (!singleShape.isAbstract() && !singleShape.isUnion()) {
            if (singleShape.getAccessMode().canWrite()) {
                mutationBuilder.field(this.getCreateType(singleShape, somlSchema.getConfig(), rbacBuilder));
                mutationBuilder.field(this.getUpdateType(singleShape, somlSchema.getConfig(), rbacBuilder));
            }
            if (singleShape.getAccessMode().canDelete() && !singleShape.isUnion()) {
                mutationBuilder.field(this.getDeleteType(singleShape, somlSchema.getConfig(), rbacBuilder));
            }
        } else if (singleShape.getAccessMode().canWrite()) {
            mutationBuilder.field(this.getUpdateType(singleShape, somlSchema.getConfig(), rbacBuilder));
        }
    }

    private void addMutationLiteralInputTypes(Shape literal, GraphQLSchema.Builder builder, GraphQlSchemaBuilderExtension.Options options, GraphQlRbac rbacBuilder) {
        this.buildLiteralUpdateInputObject(builder);
        boolean generationEnabled = options.isGenerationEnabled();
        builder.additionalType((GraphQLType)this.createRootMutationType(literal, generationEnabled, true, rbacBuilder));
    }

    private void buildLiteralUpdateInputObject(GraphQLSchema.Builder schemaBuilder) {
        String name = "Literal_Update_Input_Multi_Value_Input";
        GraphQLInputObjectType.Builder ioBuilder = GraphQLInputObjectType.newInputObject().name(name);
        ioBuilder.description("Input for updating multi-value Literal fields");
        String literalCreate = "Literal_Create_Input";
        ioBuilder.field(GraphQLInputObjectField.newInputObjectField().name("value").description("Literal value to add to the affected property").type((GraphQLInputType)GraphQlTypeUtil.newNonNullListReferenceType(literalCreate))).field(GraphQLInputObjectField.newInputObjectField().name("patch").type((GraphQLInputType)new GraphQLTypeReference(literalCreate)).description("Replace values matching this property. Cannot be combined with replace")).field(GraphQLInputObjectField.newInputObjectField().name(WHERE).type((GraphQLInputType)new GraphQLTypeReference("Literal_Where")).description("Replace values matching this filter. Cannot be combined with patch")).field(GraphQLInputObjectField.newInputObjectField().name("replace").description("Overwrite all values for this property. Defaults to false.").type((GraphQLInputType)Scalars.GraphQLBoolean).defaultValue((Object)false));
        schemaBuilder.additionalType((GraphQLType)ioBuilder.build());
    }

    public static void ignoreShapeId(String id) {
        ignoreShapeIds.add(id);
    }

    private GraphQLFieldDefinition.Builder getCreateType(Shape shape, Configs config, GraphQlRbac rbacBuilder) {
        String refName = shape.asGraphQl();
        String creationName = CREATE_PREFIX + refName;
        GraphQLFieldDefinition.Builder createFieldDefinitionBuilder = GraphQLFieldDefinition.newFieldDefinition().name(config.getMutationName(creationName)).description("Create mutation for " + refName).type((GraphQLOutputType)new GraphQLTypeReference(refName + MUTATION_RESPONSE_SUFFIX)).argument(GraphQlTypeUtil.newArgument(GRAPH_ARGUMENT, (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument(OBJECTS_ARGUMENT, (GraphQLInputType)GraphQlTypeUtil.newNonNullListReferenceType(refName + CREATE_INPUT_SUFFIX))).argument(GraphQlFieldArgumentBuilder.includeInferred()).argument(GraphQlFieldArgumentBuilder.expandOverSameAs()).argument(GraphQlFieldArgumentBuilder.repository()).argument(GraphQlFieldArgumentBuilder.using()).argument(GraphQlFieldArgumentBuilder.with()).argument(GraphQlFieldArgumentBuilder.errorsFormat());
        rbacBuilder.addEditRoles(arg_0 -> ((GraphQLFieldDefinition.Builder)createFieldDefinitionBuilder).withDirective(arg_0), shape);
        return createFieldDefinitionBuilder;
    }

    private GraphQLFieldDefinition.Builder getUpdateType(Shape shape, Configs config, GraphQlRbac rbacBuilder) {
        String refName = shape.asGraphQl();
        String updateName = UPDATE_PREFIX + refName;
        GraphQLFieldDefinition.Builder updateFieldDefinitionBuilder = GraphQLFieldDefinition.newFieldDefinition().name(config.getMutationName(updateName)).description("Update mutation for " + refName).type((GraphQLOutputType)new GraphQLTypeReference(refName + MUTATION_RESPONSE_SUFFIX)).argument(GraphQlTypeUtil.newArgument(GRAPH_ARGUMENT, (GraphQLInputType)Scalars.GraphQLString)).argument(GraphQlTypeUtil.newArgument(OBJECTS_ARGUMENT, (GraphQLInputType)GraphQlTypeUtil.newNonNullReference(refName + UPDATE_INPUT_SUFFIX))).argument(GraphQlFieldArgumentBuilder.where(refName)).argument(GraphQlFieldArgumentBuilder.includeInferred()).argument(GraphQlFieldArgumentBuilder.expandOverSameAs()).argument(GraphQlFieldArgumentBuilder.repository()).argument(GraphQlFieldArgumentBuilder.using()).argument(GraphQlFieldArgumentBuilder.with()).argument(GraphQlFieldArgumentBuilder.errorsFormat());
        rbacBuilder.addEditRoles(arg_0 -> ((GraphQLFieldDefinition.Builder)updateFieldDefinitionBuilder).withDirective(arg_0), shape);
        return updateFieldDefinitionBuilder;
    }

    private GraphQLFieldDefinition.Builder getDeleteType(Shape shape, Configs config, GraphQlRbac rbacBuilder) {
        String refName = shape.asGraphQl();
        String deleteName = DELETE_PREFIX + refName;
        GraphQLFieldDefinition.Builder deleteFieldDefinitionBuilder = GraphQLFieldDefinition.newFieldDefinition().name(config.getMutationName(deleteName)).description("Delete mutation for " + refName).type((GraphQLOutputType)new GraphQLTypeReference(refName + MUTATION_RESPONSE_SUFFIX)).argument(GraphQlTypeUtil.newArgument(WHERE, (GraphQLInputType)GraphQlTypeUtil.newNonNullReference(refName + DELETE_INPUT_FILTER))).argument(GraphQlFieldArgumentBuilder.includeInferred()).argument(GraphQlFieldArgumentBuilder.expandOverSameAs()).argument(GraphQlFieldArgumentBuilder.repository()).argument(GraphQlFieldArgumentBuilder.using()).argument(GraphQlFieldArgumentBuilder.with()).argument(GraphQlFieldArgumentBuilder.errorsFormat());
        rbacBuilder.addDeleteRoles(arg_0 -> ((GraphQLFieldDefinition.Builder)deleteFieldDefinitionBuilder).withDirective(arg_0), shape);
        return deleteFieldDefinitionBuilder;
    }

    private void addMutationInputTypes(Shape shape, GraphQLSchema.Builder schemaBuilder, GraphQlSchemaBuilderExtension.Options options, GraphQlRbac rbacBuilder) {
        if (!this.isAllowedAsInputType(shape)) {
            return;
        }
        schemaBuilder.additionalTypes(this.buildMutationTypes(shape, options, rbacBuilder));
        if (shape.getAccessMode().canDelete() && !shape.isUnion()) {
            schemaBuilder.additionalType((GraphQLType)this.generateMutationFilter(shape, DELETE_INPUT_FILTER, (GraphQLInputType)new GraphQLNonNull((GraphQLType)GraphQlTypeUtil.newNonNullListType((GraphQLType)Scalars.GraphQLID)), rbacBuilder::addDeleteRoles));
        }
    }

    private boolean isAllowedAsInputType(Shape shape) {
        return !NONE_MUTATION_INPUTS.contains(shape.getId()) && shape.isSynthetic() == false;
    }

    private GraphQLInputObjectType generateMutationFilter(Shape shape, String suffix, GraphQLInputType fixedType, BiConsumer<Consumer<GraphQLDirective.Builder>, Shape> rolesAppender) {
        String objName = shape.asGraphQl();
        GraphQLInputObjectField.Builder inputObjectFieldBuilder = GraphQLInputObjectField.newInputObjectField().name(ID_NAME).type(fixedType);
        GraphQLInputObjectType.Builder mutationFilterBuilder = GraphQLInputObjectType.newInputObject().name(objName + suffix);
        rolesAppender.accept(arg_0 -> ((GraphQLInputObjectField.Builder)inputObjectFieldBuilder).withDirective(arg_0), shape);
        rolesAppender.accept(arg_0 -> ((GraphQLInputObjectType.Builder)mutationFilterBuilder).withDirective(arg_0), shape);
        mutationFilterBuilder.field(inputObjectFieldBuilder.build());
        return mutationFilterBuilder.build();
    }

    private GraphQLType buildMutationResponseType(Shape singleShape) {
        String shapeId = singleShape.asGraphQl();
        Objects.requireNonNull(shapeId, "Cannot build mutation with null name.");
        String mutationName = shapeId + MUTATION_RESPONSE_SUFFIX;
        GraphQLObjectType.Builder classBuilder = GraphQLObjectType.newObject().name(mutationName);
        classBuilder.description("Mutation response for " + mutationName);
        GraphQLFieldDefinition affectedCount = GraphQLFieldDefinition.newFieldDefinition().name("affected_count").description("Count of objects affected by the mutation").type((GraphQLOutputType)GraphQlTypeUtil.newNonNullListReferenceType("AffectedCount")).build();
        GraphQLFieldDefinition affectedContents = GraphQLFieldDefinition.newFieldDefinition().name(Character.toLowerCase(shapeId.charAt(0)) + shapeId.substring(1)).description("Contains references to all affected " + shapeId + " objects").type((GraphQLOutputType)GraphQlTypeUtil.newList(shapeId)).argument(GraphQlFieldArgumentBuilder.lang()).argument(GraphQlFieldArgumentBuilder.order(shapeId)).argument(GraphQlFieldArgumentBuilder.limit()).argument(GraphQlFieldArgumentBuilder.offset()).argument(GraphQlFieldArgumentBuilder.where(shapeId)).argument(GraphQlFieldArgumentBuilder.includeInferred()).argument(GraphQlFieldArgumentBuilder.expandOverSameAs()).argument(GraphQlFieldArgumentBuilder.from()).build();
        GraphQLFieldDefinition affectedIds = GraphQLFieldDefinition.newFieldDefinition().name("affected_objects").description("List of IDs affected by the mutation").type((GraphQLOutputType)GraphQlTypeUtil.newNonNullListReferenceType("AffectedObjects")).build();
        classBuilder.field(affectedCount);
        classBuilder.field(affectedContents);
        classBuilder.field(affectedIds);
        return classBuilder.build();
    }

    private GraphQLInputObjectField.Builder createTypeField(Shape childShape, boolean isCreate, GraphQlRbac rbacBuilder) {
        String inputType = isCreate ? CREATE_INPUT_SUFFIX : UPDATE_INPUT_SUFFIX;
        String normalizedChildId = childShape.asGraphQl();
        String referenceName = normalizedChildId + inputType;
        GraphQLList type = isCreate ? GraphQlTypeUtil.newNonNullListReferenceType(referenceName) : new GraphQLTypeReference(referenceName);
        GraphQLInputObjectField.Builder newField = GraphQLInputObjectField.newInputObjectField().name(StringUtils.uncapitalize((String)normalizedChildId)).type((GraphQLInputType)type);
        rbacBuilder.addEditRoles(arg_0 -> ((GraphQLInputObjectField.Builder)newField).withDirective(arg_0), childShape);
        return newField;
    }

    private Set<GraphQLType> buildMutationTypes(Shape singleShape, GraphQlSchemaBuilderExtension.Options options, GraphQlRbac rbacBuilder) {
        HashSet<GraphQLType> types = new HashSet<GraphQLType>();
        if (singleShape.isMutable() || singleShape.isMutableThroughOtherTypes()) {
            if (!singleShape.isAbstract() && !singleShape.isUnion()) {
                types.add((GraphQLType)this.createRootMutationType(singleShape, options.isGenerationEnabled(), true, rbacBuilder));
            }
            if (!singleShape.isUnion()) {
                types.add((GraphQLType)this.createRootMutationType(singleShape, options.isGenerationEnabled(), false, rbacBuilder));
            }
        }
        if (options.getObjectPropertyRanges().contains(singleShape.getId())) {
            types.add((GraphQLType)this.createNestedMutationType(singleShape, true, rbacBuilder).build());
            types.add((GraphQLType)this.createNestedMutationType(singleShape, false, rbacBuilder).build());
        }
        return types;
    }

    private boolean isLiteral(Shape singleShape) {
        return "Literal".equals(singleShape.getId());
    }

    private GraphQLInputObjectType createRootMutationType(Shape shape, boolean enableGeneration, boolean isCreate, GraphQlRbac rbacBuilder) {
        String normalizedId = shape.asGraphQl();
        String type = isCreate ? CREATE_INPUT_SUFFIX : UPDATE_INPUT_SUFFIX;
        GraphQLInputObjectType.Builder builder = GraphQLInputObjectType.newInputObject().name(normalizedId + type);
        SomlSchema somlSchema = shape.getContainedIn().getContainedIn();
        ArrayList shapeHierarchy = new ArrayList(somlSchema.getObjects().getHierarchy(shape.getId()));
        for (Shape parentShape : shapeHierarchy) {
            parentShape.getProps().values().stream().filter(PropertyShape::isMutable).forEach(propertyShape -> {
                Consumer<GraphQLInputObjectField.Builder> propertyWriteBuilder = rbacBuilder.createPropertyWriteBuilder(shape.getId(), propertyShape.getName());
                if (propertyShape.isScalarType() && !propertyShape.isLiteral()) {
                    GraphQLInputObjectField newField = this.generateScalarMutationField((PropertyShape)propertyShape, isCreate, propertyWriteBuilder, enableGeneration, parentShape.getName());
                    builder.field(newField);
                } else if (propertyShape.isLiteral()) {
                    builder.field(this.generateLiteralMutationField((PropertyShape)propertyShape, propertyWriteBuilder, isCreate, parentShape.getName()));
                } else {
                    builder.field(this.generateObjectMutationField((PropertyShape)propertyShape, propertyWriteBuilder, isCreate));
                }
            });
        }
        rbacBuilder.addEditRoles(arg_0 -> ((GraphQLInputObjectType.Builder)builder).withDirective(arg_0), shape);
        return builder.build();
    }

    private GraphQLInputObjectType.Builder createNestedMutationType(Shape shape, boolean isCreate, GraphQlRbac rbacBuilder) {
        String normalizedId = shape.asGraphQl();
        String type = isCreate ? CREATE_INPUT_SUFFIX : UPDATE_INPUT_SUFFIX;
        String nestedKey = normalizedId + type + NESTED_SUFFIX;
        GraphQLInputObjectType.Builder nestedBuilder = GraphQLInputObjectType.newInputObject().name(nestedKey);
        shape.getConcreteSubTypes().stream().filter(subType -> !GraphQlTypeUtil.getBaseTypes().contains(subType.getId()) && subType.isMutable()).map(subType -> this.createTypeField((Shape)subType, isCreate, rbacBuilder)).forEach(arg_0 -> ((GraphQLInputObjectType.Builder)nestedBuilder).field(arg_0));
        if (!(!shape.isMutable() && !shape.isMutableThroughOtherTypes() || shape.isAbstract() && isCreate || shape.isUnion())) {
            nestedBuilder.field(this.createTypeField(shape, isCreate, rbacBuilder));
        }
        this.addDefaultMutationInputs(normalizedId, nestedBuilder, isCreate);
        rbacBuilder.addEditRoles(arg_0 -> ((GraphQLInputObjectType.Builder)nestedBuilder).withDirective(arg_0), shape);
        return nestedBuilder;
    }

    private void addDefaultMutationInputs(String normalizedId, GraphQLInputObjectType.Builder nestedBuilder, boolean isCreate) {
        nestedBuilder.field(GraphQLInputObjectField.newInputObjectField().name("ids").description("Non-conditional ID insertions").type((GraphQLInputType)GraphQlTypeUtil.newNonNullListType((GraphQLType)Scalars.GraphQLID)));
        nestedBuilder.field(GraphQLInputObjectField.newInputObjectField().name(WHERE).description("Conditional insertions").type((GraphQLInputType)new GraphQLTypeReference(normalizedId + "_Where_Multi")));
        if (!isCreate) {
            nestedBuilder.field(GraphQLInputObjectField.newInputObjectField().name("patch").description("Replace values matching this property. Cannot be combined with replace").type((GraphQLInputType)GraphQlTypeUtil.newNonNullListType((GraphQLType)Scalars.GraphQLID)));
            nestedBuilder.field(GraphQLInputObjectField.newInputObjectField().name("replace").description("Overwrite all values for this property. Defaults to false.").type((GraphQLInputType)Scalars.GraphQLBoolean).defaultValue((Object)Boolean.FALSE));
        }
    }

    private GraphQLInputObjectField generateLiteralMutationField(PropertyShape propertyShape, Consumer<GraphQLInputObjectField.Builder> onNewProperty, boolean isCreate, String nameAlias) {
        Object range = propertyShape.getScalarType().getGraphql();
        range = (String)range + (isCreate ? CREATE_INPUT_SUFFIX : UPDATE_INPUT_SUFFIX);
        if (!isCreate) {
            range = (String)range + MULTIVALUE_INPUT;
        }
        GraphQLInputType inputType = this.createGraphQlMutationInput(propertyShape, isCreate, (String)range);
        String fieldName = propertyShape.asGraphQl();
        GraphQLInputObjectField.Builder inputObjectField = GraphQLInputObjectField.newInputObjectField().name(fieldName).type(inputType);
        onNewProperty.accept(inputObjectField);
        if (propertyShape.getName().equals(nameAlias)) {
            inputObjectField.withDirective(DirectivesBuilder.createNameAliasDirective(false));
        }
        return inputObjectField.build();
    }

    private GraphQLInputObjectField generateObjectMutationField(PropertyShape propertyShape, Consumer<GraphQLInputObjectField.Builder> onNewProperty, boolean isCreate) {
        String range = propertyShape.getRangeShape().asGraphQl();
        String type = isCreate ? CREATE_INPUT_SUFFIX : UPDATE_INPUT_SUFFIX;
        GraphQLInputType inputType = this.createGraphQlMutationInput(propertyShape, isCreate, range + type + NESTED_SUFFIX);
        String fieldName = propertyShape.asGraphQl();
        GraphQLInputObjectField.Builder inputObjectField = GraphQLInputObjectField.newInputObjectField().name(fieldName).type(inputType);
        onNewProperty.accept(inputObjectField);
        return inputObjectField.build();
    }

    private GraphQLInputType createGraphQlMutationInput(PropertyShape propertyShape, boolean isCreate, String referencedType) {
        GraphQLTypeReference inputType = new GraphQLTypeReference(referencedType);
        if (isCreate) {
            if (propertyShape.isMultivalued()) {
                inputType = GraphQlTypeUtil.newNonNullListType((GraphQLType)inputType);
            }
        } else {
            inputType = GraphQlTypeUtil.newNonNullListType((GraphQLType)inputType);
        }
        if (isCreate && propertyShape.isRequired()) {
            inputType = new GraphQLNonNull((GraphQLType)inputType);
        }
        return inputType;
    }

    private GraphQLInputObjectField generateScalarMutationField(PropertyShape propertyShape, boolean isCreate, Consumer<GraphQLInputObjectField.Builder> onNewProperty, boolean enableGeneration, String nameAlias) {
        String propertyKey = propertyShape.asGraphQl();
        Object typeRaw = propertyShape.getScalarType().getGraphql();
        boolean required = propertyShape.isRequired();
        if (isCreate) {
            if (enableGeneration && ("id".equals(propertyKey) || StringUtils.isNotBlank((CharSequence)propertyShape.getGen()))) {
                required = false;
            }
        } else {
            if (propertyShape.isMultivalued()) {
                typeRaw = (String)typeRaw + MULTIVALUE_INPUT;
            }
            required = false;
        }
        GraphQLType type = this.calculateType((String)typeRaw, propertyShape, required);
        GraphQLInputObjectField.Builder propertyBuilder = GraphQLInputObjectField.newInputObjectField().name(propertyKey).type((GraphQLInputType)type);
        onNewProperty.accept(propertyBuilder);
        if (propertyShape.getName().equals(nameAlias)) {
            propertyBuilder.withDirective(DirectivesBuilder.createNameAliasDirective(false));
        }
        return propertyBuilder.build();
    }

    private GraphQLType calculateType(String type, PropertyShape property, boolean required) {
        return GraphQlPropertyTypeCalculator.computeInputGraphQlType(type, required, property.isMultivalued(), true);
    }
}

