/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.graphexplore.service;

import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.graphexplore.model.SavedGraph;
import com.ontotext.forest.graphexplore.model.config.VisualGraphConfig;
import com.ontotext.forest.graphexplore.model.config.VisualGraphConfigSample;
import com.ontotext.forest.graphexplore.service.SavedGraphService;
import com.ontotext.forest.graphexplore.service.VisualGraphConfigEvent;
import com.ontotext.forest.persistence.UsersConfig;
import com.ontotext.raft.GraphDBReplicationCluster;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.common.io.IOUtil;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.stereotype.Service;

@Service
public class VisualGraphConfigService
implements ApplicationEventPublisherAware {
    private static final String PERSISTENCE_PROPERTY = "graphConfigs";
    public static final String DEFAULT_ID = "default";
    @Autowired
    private UsersConfig usersConfig;
    @Autowired
    private SavedGraphService savedGraphService;
    @Autowired
    private SemanticDataManagement dataManagement;
    private VisualGraphConfigSample bareMinimumConfig;
    private VisualGraphConfigSample advancedConfig;
    private ApplicationEventPublisher applicationEventPublisher;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @PostConstruct
    public void addSampleData() throws IOException {
        this.advancedConfig = this.loadSampleConfig("Advanced", "advanced");
        this.bareMinimumConfig = this.loadSampleConfig("Minimal", "minimal");
    }

    public VisualGraphConfig getVisualGraphConfig(String id) {
        if (id == null || id.equals(DEFAULT_ID)) {
            return null;
        }
        VisualGraphConfig visualGraphConfig = this.getConfigs().get(id);
        if (visualGraphConfig == null) {
            throw new GraphDBWorkbenchException("Unknown config: " + String.valueOf(this.usersConfig));
        }
        if (!visualGraphConfig.isShared() && !visualGraphConfig.getOwner().equals(this.savedGraphService.getLoggedInUser())) {
            throw new GraphDBWorkbenchException("Cannot view config: " + visualGraphConfig.getName());
        }
        return visualGraphConfig;
    }

    public void createVisualGraphConfig(VisualGraphConfig visConfig) {
        this.validateLeadership();
        Collection<VisualGraphConfig> visualGraphConfigs = this.getAllConfigs();
        if (!visualGraphConfigs.isEmpty() && visualGraphConfigs.stream().anyMatch(v -> v.getName().equals(visConfig.getName()))) {
            throw new IllegalArgumentException(visConfig.getName() + " already exists. Please choose another name for configuration.");
        }
        visConfig.setId(this.newId());
        visConfig.setOwner(this.savedGraphService.getLoggedInUser());
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new VisualGraphConfigEvent(visConfig, null, false));
        this.updateVisualGraphConfigNoEvent(visConfig);
    }

    public void updateVisualGraphConfig(VisualGraphConfig visualGraphConfig) {
        this.validateLeadership();
        Map<String, VisualGraphConfig> map = this.getConfigs();
        VisualGraphConfig conf = map.get(visualGraphConfig.getId());
        if (conf == null) {
            throw new IllegalArgumentException("Config not found: " + visualGraphConfig.getName());
        }
        if (!conf.getOwner().equals(this.savedGraphService.getLoggedInUser())) {
            throw new IllegalArgumentException("Cannot update config: " + visualGraphConfig.getName());
        }
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new VisualGraphConfigEvent(visualGraphConfig, null, false));
        this.updateVisualGraphConfigNoEvent(visualGraphConfig);
    }

    public void updateVisualGraphConfigNoEvent(VisualGraphConfig visualGraphConfig) {
        this.usersConfig.updateMapEntry(PERSISTENCE_PROPERTY, VisualGraphConfig.class, visualGraphConfig.getId(), (Object)visualGraphConfig);
    }

    public Collection<VisualGraphConfig> getAllConfigs() {
        String user = this.savedGraphService.getLoggedInUser();
        if (this.savedGraphService.getSecurityConfig().isUsernameFreeAccess(user)) {
            if (this.savedGraphService.isDisabledFreeAccess()) {
                return Collections.emptyList();
            }
            return this.getConfigs().values().stream().filter(VisualGraphConfig::isShared).sorted().collect(Collectors.toList());
        }
        return this.getConfigs().values().stream().filter(v -> user.equals(v.getOwner()) || v.isShared()).sorted().collect(Collectors.toList());
    }

    private String newId() {
        String newId;
        Set<String> existingIds = this.getConfigs().keySet();
        if (existingIds.contains(newId = UUID.randomUUID().toString().replaceAll("-", ""))) {
            return this.newId();
        }
        return newId;
    }

    private Map<String, VisualGraphConfig> getConfigs() {
        return this.usersConfig.getMap(PERSISTENCE_PROPERTY, VisualGraphConfig.class);
    }

    public void deleteConfig(String id) {
        this.validateLeadership();
        List<SavedGraph> savedGraphs = this.savedGraphService.getSavedGraphs();
        for (SavedGraph sg : savedGraphs) {
            if (!id.equals(sg.getConfig())) continue;
            sg.setConfig(null);
            this.savedGraphService.editSavedGraph(sg);
        }
        VisualGraphConfig visualGraphConfig = this.getConfigs().get(id);
        if (!visualGraphConfig.getOwner().equals(this.savedGraphService.getLoggedInUser())) {
            throw new IllegalArgumentException("Unauthorized to delete this graph");
        }
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new VisualGraphConfigEvent(null, id, true));
        this.deleteConfigNoEvent(id);
    }

    public void deleteConfigNoEvent(String id) {
        this.usersConfig.deleteMapEntry(PERSISTENCE_PROPERTY, VisualGraphConfig.class, id);
    }

    public VisualGraphConfig getBareMinimumConfig() {
        return this.bareMinimumConfig;
    }

    public VisualGraphConfig getAdvancedConfig() {
        return this.advancedConfig;
    }

    private VisualGraphConfigSample loadSampleConfig(String name, String directory) throws IOException {
        Path path = Paths.get("graph-explore-config", "samples", directory);
        VisualGraphConfigSample sample = new VisualGraphConfigSample(name);
        sample.setStartGraphQuery(this.readStringOrNull(path.resolve("startGraphQuery")));
        sample.setExpandQuery(this.readStringOrNull(path.resolve("expandQuery")));
        sample.setResourceQuery(this.readStringOrNull(path.resolve("resourceQuery")));
        sample.setResourcePropertiesQuery(this.readStringOrNull(path.resolve("resourcePropertiesQuery")));
        sample.setPredicateLabelQuery(this.readStringOrNull(path.resolve("predicateLabelQuery")));
        try (InputStream inp = VisualGraphConfigService.class.getResourceAsStream("/" + path.resolve("queryDescription.properties").toString());){
            if (inp != null) {
                Properties properties = new Properties();
                properties.load(inp);
                sample.startGraphQueryDescription = (String)properties.get("startGraphQuery");
                sample.expandQueryDescription = (String)properties.get("expandQuery");
                sample.resourceQueryDescription = (String)properties.get("resourceQuery");
                sample.resourcePropertiesQueryDescription = (String)properties.get("resourcePropertiesQuery");
                sample.predicateLabelQueryDescription = (String)properties.get("predicateLabelQuery");
            }
        }
        return sample;
    }

    private String readStringOrNull(Path resourcePath) throws IOException {
        try (InputStream is = this.getClass().getResourceAsStream("/" + resourcePath.toString() + ".sparql");){
            if (is != null) {
                String string = IOUtil.readString((InputStream)is);
                return string;
            }
        }
        return null;
    }

    private void validateLeadership() {
        GraphDBReplicationCluster replicationCluster = this.dataManagement.getCurrentLocationOrThrow().getReplicationCluster();
        if (replicationCluster != null) {
            try {
                replicationCluster.validateLeadership();
            }
            catch (UpdateExecutionException e) {
                throw new GraphDBWorkbenchException(e.getMessage());
            }
            if (!replicationCluster.isPrimaryCluster()) {
                throw new GraphDBWorkbenchException("Unable to execute operation as node is in secondary cluster mode.");
            }
        }
    }
}

