/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.graphexplore.service;

import com.ontotext.trree.util.IRIUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Service;

@Service
public class EquivalentClassesService {
    Map<String, EquivalentClass> class2equivalence = new HashMap<String, EquivalentClass>();

    public void addEquivalentClasses(String classA, String classB) {
        EquivalentClass eq = this.class2equivalence.get(classA);
        if (eq != null) {
            eq.addMember(classB);
            this.class2equivalence.put(classB, eq);
        } else {
            eq = this.class2equivalence.get(classB);
            if (eq != null) {
                eq.addMember(classA);
                this.class2equivalence.put(classA, eq);
            } else {
                eq = new EquivalentClass();
                eq.addMember(classA);
                eq.addMember(classB);
                this.class2equivalence.put(classA, eq);
                this.class2equivalence.put(classB, eq);
            }
        }
    }

    public String getNormalisedClass(String cla\u00df) {
        EquivalentClass eq = this.class2equivalence.get(cla\u00df);
        if (eq != null) {
            return eq.normalised;
        }
        return cla\u00df;
    }

    private static double letterProportion(String localPart) {
        int letters = 0;
        for (char ch : localPart.toCharArray()) {
            if (!Character.isLetter(ch)) continue;
            ++letters;
        }
        return (double)letters / (double)localPart.length();
    }

    static class EquivalentClass {
        String normalised;
        double normalisedLetterProportion;
        Set<String> equivalent = new HashSet<String>();

        EquivalentClass() {
        }

        void addMember(String cla\u00df) {
            this.equivalent.add(cla\u00df);
            String localName = IRIUtil.makeLabelFromIri((String)cla\u00df);
            if (!cla\u00df.contains(":")) {
                return;
            }
            double letterProportion = EquivalentClassesService.letterProportion(localName);
            double ratio = letterProportion / this.normalisedLetterProportion;
            if (this.normalised == null || this.normalised.length() > cla\u00df.length() && ratio > 0.8 || ratio > 2.0) {
                this.normalised = cla\u00df;
                this.normalisedLetterProportion = letterProportion;
            }
        }
    }
}

