/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.graphexplore.model;

import com.ontotext.forest.graphexplore.model.DependencyEdge;
import jakarta.validation.constraints.NotNull;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class DependencyClass
implements Comparable<DependencyClass> {
    private String name;
    private long outConnectionsSum;
    private long inConnectionsSum;
    private long selfConnections;
    private List<DependencyEdge> connections = new LinkedList<DependencyEdge>();

    public DependencyClass(String name, List<DependencyEdge> connections) {
        this.name = name;
        this.connections = connections;
        this.inConnectionsSum = connections.stream().filter(dependencyEdge -> dependencyEdge.getInWeight() > 0L).mapToLong(DependencyEdge::getInWeight).sum();
        this.outConnectionsSum = connections.stream().filter(dependencyEdge -> dependencyEdge.getOutWeight() > 0L).mapToLong(DependencyEdge::getOutWeight).sum();
        this.selfConnections = connections.stream().filter(dependencyEdge -> dependencyEdge.getDependencyClass().equals(name)).mapToLong(DependencyEdge::getOutWeight).sum();
    }

    public String getName() {
        return this.name;
    }

    public List<DependencyEdge> getInConnections() {
        return this.connections.stream().filter(dependencyEdge -> dependencyEdge.getInWeight() > 0L).collect(Collectors.toList());
    }

    public List<DependencyEdge> getOutConnections() {
        return this.connections.stream().filter(dependencyEdge -> dependencyEdge.getOutWeight() > 0L).collect(Collectors.toList());
    }

    public List<DependencyEdge> getConnections() {
        return this.connections;
    }

    public long getOutConnectionsSum() {
        return this.outConnectionsSum;
    }

    public long getInConnectionsSum() {
        return this.inConnectionsSum;
    }

    public long getTotalSum() {
        return this.inConnectionsSum + this.outConnectionsSum;
    }

    @Override
    public int compareTo(@NotNull DependencyClass o) {
        return new Long(o.getTotalSum() - o.getSelfConnections()).compareTo(this.getTotalSum() - this.getSelfConnections());
    }

    public long getSelfConnections() {
        return this.selfConnections;
    }
}

