/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.graphexplore;

import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.SemanticLocation;
import com.ontotext.forest.core.semantic.SparqlService;
import com.ontotext.forest.core.semantic.repository.SemanticRepository;
import com.ontotext.forest.core.service.URIPrefixService;
import com.ontotext.forest.core.util.QueryUtils;
import com.ontotext.forest.graphexplore.model.SavedGraph;
import com.ontotext.forest.graphexplore.model.config.QueryValidator;
import com.ontotext.forest.graphexplore.model.config.VisualGraphConfig;
import com.ontotext.forest.graphexplore.model.config.VisualQuery;
import com.ontotext.forest.graphexplore.model.explore.Link;
import com.ontotext.forest.graphexplore.model.explore.Node;
import com.ontotext.forest.graphexplore.service.SavedGraphService;
import com.ontotext.forest.graphexplore.service.VisualGraphConfigService;
import com.ontotext.forest.repositories.RepositoryUtils;
import com.ontotext.trree.util.IRIUtil;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.validation.Valid;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.query.parser.ParsedDescribeQuery;
import org.eclipse.rdf4j.query.parser.ParsedGraphQuery;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.query.parser.QueryParserUtil;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/rest/explore-graph"})
@RestController
public class GraphExploreController {
    private static final Logger LOG = LoggerFactory.getLogger(GraphExploreController.class);
    public static final String LINE_COMMENTS_REGEX = "(?m)^(\\s*)\\#[^\\n]+[\\n]";
    public static final String MAPPING = "/rest/explore-graph";
    private static final ValueFactory VF = SimpleValueFactory.getInstance();
    private final SparqlService sparqlService;
    private final SemanticDataManagement semanticDataManagement;
    private final URIPrefixService uriPrefixService;
    @Autowired
    private SavedGraphService savedGraphService;
    @Autowired
    private VisualGraphConfigService graphConfigService;

    @Autowired
    public GraphExploreController(SparqlService sparqlService, SemanticDataManagement semanticDataManagement, URIPrefixService uriPrefixService) {
        this.sparqlService = sparqlService;
        this.uriPrefixService = uriPrefixService;
        this.semanticDataManagement = semanticDataManagement;
    }

    private Node loadNode(final Value resource, final VisualGraphConfig config, final List<String> languages, final boolean includeInferred, final boolean sameAsState) throws Exception {
        SemanticRepository semanticRepository = this.getRepository();
        final boolean isOntop = RepositoryUtils.isOntopRepository((SemanticRepository)semanticRepository, (SemanticLocation)this.semanticDataManagement.getLocationFromHeaderOrThrow());
        SemanticRepository semanticRepository2 = semanticRepository;
        Objects.requireNonNull(semanticRepository2);
        Node node = (Node)new SemanticRepository.WithConnection<Node>(semanticRepository2){

            protected Node doInConnection() throws RepositoryException {
                try {
                    String queryString;
                    Node n = new Node();
                    double rdfRank = -1.0;
                    double defaultRankForSize = 0.1;
                    if (config == null) {
                        queryString = GraphExploreController.this.sparqlService.readQueryString("graph-explore-queries/describeResource");
                        queryString = queryString.replaceAll(Pattern.quote("{{langMatches}}"), isOntop ? "1" : QueryUtils.generateLangMatchesIfs((String)"?langLabel", (Collection)languages));
                        queryString = queryString.replaceAll(Pattern.quote("{{langCommentMatches}}"), isOntop ? "1" : QueryUtils.generateLangMatchesIfs((String)"?langComment", (Collection)languages));
                    } else {
                        queryString = config.getResourceQuery();
                        if (StringUtils.isBlank((CharSequence)queryString)) {
                            queryString = GraphExploreController.this.graphConfigService.getBareMinimumConfig().getResourceQuery();
                        }
                    }
                    if (StringUtils.isBlank((CharSequence)queryString)) {
                        throw new GraphDBWorkbenchException("Resource query is not configured.");
                    }
                    TupleQuery tupleQuery = this.prepare(queryString);
                    tupleQuery.setBinding("node", resource);
                    if (!isOntop) {
                        tupleQuery.setIncludeInferred(includeInferred);
                        GraphExploreController.this.addSameAsGraph((Query)tupleQuery, sameAsState);
                    }
                    try (TupleQueryResult tupleQueryResult = this.evaluate(tupleQuery);){
                        n.setIri(resource);
                        while (tupleQueryResult.hasNext()) {
                            Literal rank;
                            Literal comment;
                            BindingSet bs = (BindingSet)tupleQueryResult.next();
                            Literal label = GraphExploreController.this.getLiteralBindingOrNull(bs, "label");
                            if (label != null) {
                                String language = label.getLanguage().orElse("");
                                n.addLabel(language, label.stringValue(), 0);
                            }
                            if ((comment = GraphExploreController.this.getLiteralBindingOrNull(bs, "comment")) != null && n.getComment() == null) {
                                n.setComment(comment.stringValue());
                            }
                            if ((rank = GraphExploreController.this.getLiteralBindingOrNull(bs, "rank")) != null) {
                                try {
                                    rdfRank = rank.doubleValue();
                                    n.setRdfRank(rdfRank);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!bs.hasBinding("type")) continue;
                            n.addType(bs.getValue("type").stringValue());
                        }
                    }
                    if (n.getLabels().isEmpty()) {
                        n.addLabel("", IRIUtil.makeLabelFromValue((Value)resource), 0);
                    }
                    n.setSize(Math.round(40.0 + 80.0 * Math.min(1.0, Math.max(n.getRdfRank(), defaultRankForSize))));
                    return n;
                }
                catch (Exception e) {
                    LOG.error("Could not get uri node", (Throwable)e);
                    return null;
                }
            }
        }.run();
        if (node == null) {
            throw new GraphDBWorkbenchException("Cannot load node data for " + String.valueOf(resource));
        }
        return node;
    }

    private void addSameAsGraph(Query tupleQuery, boolean enableSameAs) {
        if (!enableSameAs) {
            IRI ontoSameAs = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/disable-sameAs");
            if (tupleQuery.getDataset() != null) {
                tupleQuery.getDataset().getNamedGraphs().add(ontoSameAs);
            } else {
                SimpleDataset sample = new SimpleDataset();
                sample.addNamedGraph(ontoSameAs);
                tupleQuery.setDataset((Dataset)sample);
            }
        }
    }

    @RequestMapping(value={"/node"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<?> describeNode(@RequestParam Value iri, @RequestParam String config, @RequestParam(required=false) List<String> languages, @RequestParam(required=false, defaultValue="true") boolean includeInferred, @RequestParam(required=false, defaultValue="false") boolean sameAsState) throws Exception {
        VisualGraphConfig visualGraphConfig = this.graphConfigService.getVisualGraphConfig(config);
        return new ResponseEntity((Object)this.loadNode(iri, visualGraphConfig, languages, includeInferred, sameAsState), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/graph"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<?> graph(@RequestParam String query, @RequestParam(required=false, defaultValue="true") boolean includeInferred, @RequestParam(required=false) List<String> languages, @RequestParam(required=false, defaultValue="100") Integer linksLimit, @RequestParam(required=false, defaultValue="false") boolean sameAsState) {
        SemanticRepository semanticRepository = this.getRepository();
        Collection<Link> returnLinks = this.getLinks(query, includeInferred, languages, linksLimit, sameAsState, semanticRepository);
        return new ResponseEntity(returnLinks, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/graph"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<?> graph(@RequestBody VisualQuery visualQuery) {
        String query = visualQuery.getQuery();
        boolean includeInferred = visualQuery.getIncludeInferred();
        List<String> languages = visualQuery.getLanguages();
        int linksLimit = visualQuery.getLinksLimit();
        boolean sameAsState = visualQuery.getSameAsState();
        SemanticRepository semanticRepository = this.getRepository();
        Collection<Link> returnLinks = this.getLinks(query, includeInferred, languages, linksLimit, sameAsState, semanticRepository);
        return new ResponseEntity(returnLinks, (HttpStatusCode)HttpStatus.OK);
    }

    private Collection<Link> getLinks(final String query, final boolean includeInferred, final List<String> languages, final int linksLimit, final boolean sameAsState, SemanticRepository semanticRepository) {
        final boolean isOntopRepo = RepositoryUtils.isOntopRepository((SemanticRepository)semanticRepository, (SemanticLocation)this.semanticDataManagement.getLocationFromHeaderOrThrow());
        SemanticRepository semanticRepository2 = semanticRepository;
        Objects.requireNonNull(semanticRepository2);
        return (Collection)new SemanticRepository.WithRawConnection<Collection<Link>>(semanticRepository2){

            protected Collection<Link> doInConnection(RepositoryConnection repositoryConnection) throws RepositoryException {
                String cleanedQuery = query;
                if (isOntopRepo) {
                    cleanedQuery = query.replaceAll(GraphExploreController.LINE_COMMENTS_REGEX, "");
                }
                GraphQuery graphQuery = repositoryConnection.prepareGraphQuery(cleanedQuery);
                if (!isOntopRepo) {
                    graphQuery.setIncludeInferred(includeInferred);
                    GraphExploreController.this.addSameAsGraph((Query)graphQuery, sameAsState);
                }
                try (GraphQueryResult graphQueryResult = graphQuery.evaluate();){
                    Collection<Link> collection = GraphExploreController.this.getLinksFromGraphResult(repositoryConnection, graphQueryResult, includeInferred, sameAsState, linksLimit, null, languages, isOntopRepo);
                    return collection;
                }
            }
        }.run();
    }

    @RequestMapping(value={"/properties"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<?> properties(final @RequestParam Value iri, @RequestParam String config, final @RequestParam(required=false) List<String> languages, final @RequestParam(required=false, defaultValue="true") boolean includeInferred, final @RequestParam(required=false, defaultValue="false") boolean sameAsState, final @RequestParam(required=false) List<String> rejectedPredicates) {
        final VisualGraphConfig visualGraphConfig = this.graphConfigService.getVisualGraphConfig(config);
        SemanticRepository semanticRepository = this.getRepository();
        final boolean isOntopRepo = RepositoryUtils.isOntopRepository((SemanticRepository)semanticRepository, (SemanticLocation)this.semanticDataManagement.getLocationFromHeaderOrThrow());
        SemanticRepository semanticRepository2 = semanticRepository;
        Objects.requireNonNull(semanticRepository2);
        Map returnLinks = (Map)new SemanticRepository.WithConnection<Map<String, List<Map<String, String>>>>(semanticRepository2){

            protected Map<String, List<Map<String, String>>> doInConnection() throws RepositoryException {
                LinkedHashMap<String, List<Map<String, String>>> properties = new LinkedHashMap<String, List<Map<String, String>>>();
                String queryString = null;
                try {
                    if (visualGraphConfig == null) {
                        queryString = GraphExploreController.this.sparqlService.readQueryString("graph-explore-queries/resourceProperties");
                        queryString = queryString.replaceAll(Pattern.quote("{{langMatches}}"), isOntopRepo ? "1" : QueryUtils.generateLangMatchesIfs((String)"?langProperty", (Collection)languages));
                        queryString = GraphExploreController.this.replaceRejectedPredicates(queryString, rejectedPredicates);
                    } else {
                        queryString = visualGraphConfig.getResourcePropertiesQuery();
                        if (StringUtils.isBlank((CharSequence)queryString)) {
                            queryString = GraphExploreController.this.graphConfigService.getBareMinimumConfig().getResourcePropertiesQuery();
                        }
                        if (StringUtils.isBlank((CharSequence)queryString)) {
                            throw new GraphDBWorkbenchException("No properties query configured.");
                        }
                    }
                    TupleQuery tupleQuery = this.prepare(queryString);
                    if (!isOntopRepo) {
                        tupleQuery.setIncludeInferred(includeInferred);
                        GraphExploreController.this.addSameAsGraph((Query)tupleQuery, sameAsState);
                    }
                    tupleQuery.setBinding("node", iri);
                    try (TupleQueryResult tupleQueryResult = this.evaluate(tupleQuery);){
                        while (tupleQueryResult.hasNext()) {
                            String property;
                            BindingSet next = (BindingSet)tupleQueryResult.next();
                            Map<Object, Object> propertyValue = new HashMap(2);
                            if (next.hasBinding("image")) {
                                property = "image";
                                propertyValue = GraphExploreController.this.makePropertyValue("image", next.getValue("image").stringValue());
                            } else {
                                if (next.getValue("property") == null || next.getValue("value") == null) continue;
                                property = next.getValue("property").stringValue();
                                Value value = next.getValue("value");
                                String stringValue = value.stringValue();
                                if (value instanceof IRI) {
                                    propertyValue = GraphExploreController.this.makePropertyValue("i", stringValue);
                                } else if (value instanceof Literal) {
                                    Object type = "l";
                                    String language = ((Literal)value).getLanguage().orElse(null);
                                    if (language != null) {
                                        type = "ll:" + language;
                                    } else {
                                        IRI dataType = ((Literal)value).getDatatype();
                                        if (dataType != null) {
                                            type = "lt:" + dataType.stringValue();
                                        }
                                    }
                                    propertyValue = GraphExploreController.this.makePropertyValue((String)type, stringValue);
                                } else {
                                    propertyValue = GraphExploreController.this.makePropertyValue("b", stringValue);
                                }
                            }
                            if (!properties.containsKey(property)) {
                                properties.put(property, new LinkedList());
                            }
                            ((List)properties.get(property)).add(propertyValue);
                        }
                    }
                }
                catch (IOException e) {
                    throw new GraphDBWorkbenchException("Could not get node links", (Throwable)e);
                }
                return properties;
            }
        }.run();
        return new ResponseEntity((Object)returnLinks, (HttpStatusCode)HttpStatus.OK);
    }

    private Map<String, String> makePropertyValue(String type, String value) {
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("t", type);
        map.put("v", value);
        return map;
    }

    @RequestMapping(value={"/links"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<?> links(final @RequestParam IRI iri, @RequestParam String config, final @RequestParam(required=false, defaultValue="20") Integer linksLimit, final @RequestParam(required=false, defaultValue="true") boolean includeInferred, final @RequestParam(required=false) List<String> preferredTypes, final @RequestParam(required=false) List<String> rejectedTypes, final @RequestParam(required=false) List<String> preferredPredicates, final @RequestParam(required=false) List<String> rejectedPredicates, final @RequestParam(required=false, defaultValue="false") boolean preferredTypesOnly, final @RequestParam(required=false, defaultValue="false") boolean preferredPredicatesOnly, final @RequestParam(required=false) List<String> languages, final @RequestParam(required=false, defaultValue="false") boolean sameAsState, final @RequestParam(required=false, defaultValue="true") boolean includeSchema) {
        Collection returnLinks;
        SemanticRepository semanticRepository = this.getRepository();
        final boolean isOntopRepo = RepositoryUtils.isOntopRepository((SemanticRepository)semanticRepository, (SemanticLocation)this.semanticDataManagement.getLocationFromHeaderOrThrow());
        final VisualGraphConfig visualGraphConfig = this.graphConfigService.getVisualGraphConfig(config);
        if (visualGraphConfig != null) {
            SemanticRepository semanticRepository2 = semanticRepository;
            Objects.requireNonNull(semanticRepository2);
            returnLinks = (Collection)new SemanticRepository.WithRawConnection<Collection<Link>>(semanticRepository2){

                protected Collection<Link> doInConnection(RepositoryConnection connection) throws RepositoryException {
                    Collection<Link> collection;
                    block11: {
                        LinkedList<Link> links = new LinkedList<Link>();
                        String expandQuery = visualGraphConfig.getExpandQuery();
                        if (StringUtils.isBlank((CharSequence)expandQuery)) {
                            expandQuery = GraphExploreController.this.graphConfigService.getBareMinimumConfig().getExpandQuery();
                        }
                        if (StringUtils.isBlank((CharSequence)expandQuery)) {
                            throw new GraphDBWorkbenchException("Expand query is not configured.");
                        }
                        GraphQuery graphQuery = connection.prepareGraphQuery(expandQuery);
                        graphQuery.setBinding("node", (Value)iri);
                        if (!isOntopRepo) {
                            graphQuery.setIncludeInferred(includeInferred);
                            GraphExploreController.this.addSameAsGraph((Query)graphQuery, sameAsState);
                        }
                        GraphQueryResult graphQueryResult = graphQuery.evaluate();
                        try {
                            collection = GraphExploreController.this.getLinksFromGraphResult(connection, graphQueryResult, includeInferred, sameAsState, linksLimit, visualGraphConfig, languages, isOntopRepo);
                            if (graphQueryResult == null) break block11;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (graphQueryResult != null) {
                                    try {
                                        graphQueryResult.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Exception e) {
                                LOG.error("Could not get node links", (Throwable)e);
                                return links;
                            }
                        }
                        graphQueryResult.close();
                    }
                    return collection;
                }
            }.run();
        } else {
            SemanticRepository semanticRepository3 = semanticRepository;
            Objects.requireNonNull(semanticRepository3);
            returnLinks = (Collection)new SemanticRepository.WithRawConnection<Collection<Link>>(semanticRepository3){

                protected Collection<Link> doInConnection(RepositoryConnection connection) throws RepositoryException {
                    LinkedList<Link> links = new LinkedList<Link>();
                    String queryString = null;
                    try {
                        queryString = GraphExploreController.this.sparqlService.readQueryString("graph-explore-queries/resourceLinks");
                        queryString = queryString.replaceAll(Pattern.quote("{{limit}}"), linksLimit.toString());
                        queryString = queryString.replaceAll(Pattern.quote("{{filterSchema}}"), includeSchema ? "" : GraphExploreController.this.sparqlService.readQueryString("graph-explore-queries/filterSchemaSnippet"));
                        if (isOntopRepo) {
                            if (rejectedTypes != null && !rejectedTypes.isEmpty()) {
                                LOG.warn("Ignored types not supported for Ontop Repositories. Use a custom visual graph to filter nodes by type.");
                            }
                            queryString = queryString.replace("# Rejected types filter\n    FILTER NOT EXISTS {\n        VALUES (?rt) { {{rejectedTypes}} }\n        ?peer a ?rt .\n    }", "");
                        }
                        queryString = GraphExploreController.this.getReplacePreferredRejectedTypes(queryString, preferredPredicates, rejectedPredicates, preferredTypes, rejectedTypes, preferredPredicatesOnly, preferredTypesOnly);
                        GraphExploreController.this.getLinksFromQuery(links, connection, queryString, (Resource)iri, isOntopRepo, includeInferred, sameAsState);
                    }
                    catch (Exception e) {
                        LOG.error("Could not get node links", (Throwable)e);
                    }
                    GraphExploreController.this.addLinksPredicateLabels(connection, includeInferred, sameAsState, visualGraphConfig, languages, links, isOntopRepo);
                    return links;
                }
            }.run();
        }
        returnLinks = returnLinks.stream().sorted((o1, o2) -> {
            if (o1 == null || o2 == null || o1.getPredicates() == null || o2.getPredicates() == null || o1.getPredicates().size() == 0 || o2.getPredicates().size() == 0) {
                return 0;
            }
            return o1.getPredicates().iterator().next().compareTo(o2.getPredicates().iterator().next());
        }).collect(Collectors.toList());
        return new ResponseEntity((Object)returnLinks, (HttpStatusCode)HttpStatus.OK);
    }

    private Collection<Link> getLinksFromGraphResult(RepositoryConnection connection, GraphQueryResult graphQueryResult, Boolean includeInferred, Boolean sameAsState, int linksLimit, VisualGraphConfig visualGraphConfig, List<String> languages, boolean isOntopRepo) {
        LinkedList<Link> links = new LinkedList<Link>();
        int limitCounter = 0;
        while (graphQueryResult.hasNext() && limitCounter++ < linksLimit) {
            Statement next = (Statement)graphQueryResult.next();
            Resource subject = next.getSubject();
            Value object = next.getObject();
            if (!(subject instanceof IRI) && !(subject instanceof Triple) || !(object instanceof IRI) && !(object instanceof Triple)) continue;
            Link l = new Link();
            l.setSource((Value)subject);
            l.setTarget(object);
            this.createLinkFromTriple(links, (Value)subject);
            this.createLinkFromTriple(links, object);
            this.addPredicate(links, next.getPredicate(), l);
        }
        graphQueryResult.close();
        this.addLinksPredicateLabels(connection, includeInferred, sameAsState, visualGraphConfig, languages, links, isOntopRepo);
        return links;
    }

    private void addLinksPredicateLabels(RepositoryConnection connection, Boolean includeInferred, Boolean sameAsState, VisualGraphConfig visualGraphConfig, List<String> languages, List<Link> links, boolean isOntopRepo) {
        HashMap<String, String> predicateLabels = new HashMap<String, String>();
        for (Link l : links) {
            for (IRI rawPredicate : l.getRawPredicates()) {
                String rawPredicateString = rawPredicate.stringValue();
                predicateLabels.putIfAbsent(rawPredicateString, this.getPredicateLabel(connection, includeInferred, sameAsState, rawPredicate, languages, visualGraphConfig, isOntopRepo));
                l.addPredicate((String)predicateLabels.get(rawPredicateString));
            }
        }
    }

    @RequestMapping(value={"/validate"}, method={RequestMethod.POST})
    public void validateQuery(@RequestBody QueryValidator queryValidator) {
        if (queryValidator.params == null) {
            queryValidator.params = Collections.emptyList();
        }
        if (queryValidator.all == null) {
            queryValidator.all = Collections.emptyList();
        }
        if (queryValidator.oneOf == null) {
            queryValidator.oneOf = Collections.emptyList();
        }
        try {
            boolean bl;
            ParsedQuery parsedQuery = QueryParserUtil.parseQuery((QueryLanguage)QueryLanguage.SPARQL, (String)queryValidator.query, (String)"urn:base");
            if ("tuple".equals(queryValidator.queryType)) {
                if (!(parsedQuery instanceof ParsedTupleQuery)) {
                    throw new GraphDBWorkbenchException("Query must be a SELECT query.");
                }
            } else if ("graph".equals(queryValidator.queryType)) {
                if (!(parsedQuery instanceof ParsedGraphQuery)) {
                    throw new GraphDBWorkbenchException("Query must be a CONSTRUCT or DESCRIBE query.");
                }
            } else if ("construct".equals(queryValidator.queryType)) {
                if (!(parsedQuery instanceof ParsedGraphQuery) || parsedQuery instanceof ParsedDescribeQuery) {
                    throw new GraphDBWorkbenchException("Query must be a CONSTRUCT query.");
                }
            } else if ("describe".equals(queryValidator.queryType)) {
                if (!(parsedQuery instanceof ParsedDescribeQuery)) {
                    throw new GraphDBWorkbenchException("Query must be a DESCRIBE query.");
                }
            } else {
                throw new GraphDBWorkbenchException("Unsupported query type: " + queryValidator.queryType);
            }
            TupleExpr tupleExpr = parsedQuery.getTupleExpr();
            VarNamesVisitor varNamesVisitor = new VarNamesVisitor(tupleExpr);
            for (String string : queryValidator.params) {
                if (varNamesVisitor.hasVarName(string)) continue;
                throw new GraphDBWorkbenchException("The variable ?" + string + " must be used in the query.");
            }
            Set bindings = tupleExpr.getBindingNames();
            for (String string : queryValidator.all) {
                if (bindings.contains(string)) continue;
                throw new GraphDBWorkbenchException("The variable ?" + string + " must be selected.");
            }
            boolean bl2 = false;
            for (String b : queryValidator.oneOf) {
                if (!bindings.contains(b)) continue;
                bl = true;
                break;
            }
            if (!bl && !queryValidator.oneOf.isEmpty()) {
                String string = queryValidator.oneOf.stream().map("?"::concat).collect(Collectors.joining(", "));
                throw new GraphDBWorkbenchException("At least one of the variables " + string + " must be selected.");
            }
        }
        catch (IllegalArgumentException | MalformedQueryException iae) {
            throw new GraphDBWorkbenchException("Invalid query: " + iae.getMessage());
        }
    }

    @RequestMapping(value={"/config"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> createGraphConfig(@RequestBody VisualGraphConfig visualGraphConfig) {
        try {
            this.graphConfigService.createVisualGraphConfig(visualGraphConfig);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new ResponseEntity((Object)illegalArgumentException.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity((Object)"Saved graph config", (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/config/{id}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<?> updateGraphConfig(@PathVariable(value="id") String id, @RequestBody VisualGraphConfig visualGraphConfig) {
        this.graphConfigService.updateVisualGraphConfig(visualGraphConfig);
        return new ResponseEntity((Object)"Saved graph config", (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/config"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> getGraphConfigs() {
        return new ResponseEntity(this.graphConfigService.getAllConfigs(), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/config/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<?> deleteGraphConfig(@PathVariable(value="id") String id) {
        this.graphConfigService.deleteConfig(id);
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/config/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> getGraphConfig(@PathVariable(value="id") String id) {
        VisualGraphConfig visualGraphConfig = this.graphConfigService.getVisualGraphConfig(id);
        return new ResponseEntity((Object)visualGraphConfig, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/config/graph/{config}"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<?> startGraphFromConfig(@PathVariable String config, @RequestParam(required=false, defaultValue="true") boolean includeInferred, @RequestParam(required=false, defaultValue="100") Integer linksLimit, @RequestParam(required=false, defaultValue="false") boolean sameAsState) {
        VisualGraphConfig visualGraphConfig = null;
        visualGraphConfig = this.graphConfigService.getVisualGraphConfig(config);
        if (visualGraphConfig.getStartGraphQuery() != null) {
            return this.graph(visualGraphConfig.getStartGraphQuery(), includeInferred, null, linksLimit, sameAsState);
        }
        if (visualGraphConfig.getStartIRI() != null) {
            return this.links(visualGraphConfig.getStartIRI(), config, null, includeInferred, null, null, null, null, false, false, null, sameAsState, false);
        }
        return new ResponseEntity((Object)"Cannot load graph config. No start IRI or graph query.", (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    private String getPredicateLabel(RepositoryConnection connection, boolean includeInferred, boolean sameAsState, IRI predicate, List<String> languages, VisualGraphConfig visualGraphConfig, boolean isOntopRepo) {
        String resultLabel;
        block13: {
            resultLabel = null;
            try {
                String queryString;
                if (visualGraphConfig == null) {
                    queryString = this.sparqlService.readQueryString("graph-explore-queries/predicateLabel");
                    queryString = queryString.replaceAll(Pattern.quote("{{langMatches}}"), isOntopRepo ? "1" : QueryUtils.generateLangMatchesIfs((String)"?langLabel", languages));
                } else {
                    queryString = visualGraphConfig.getPredicateLabelQuery();
                }
                if (!StringUtils.isNotBlank((CharSequence)queryString)) break block13;
                TupleQuery tupleQuery = connection.prepareTupleQuery(queryString);
                if (!isOntopRepo) {
                    tupleQuery.setIncludeInferred(includeInferred);
                    this.addSameAsGraph((Query)tupleQuery, sameAsState);
                }
                tupleQuery.setBinding("edge", (Value)predicate);
                try (TupleQueryResult tupleQueryResult = tupleQuery.evaluate();){
                    BindingSet bs;
                    Literal label;
                    if (tupleQueryResult.hasNext() && (label = this.getLiteralBindingOrNull(bs = (BindingSet)tupleQueryResult.next(), "label")) != null) {
                        resultLabel = label.stringValue();
                    }
                }
            }
            catch (IOException e) {
                LOG.error("Could not read edge label query", (Throwable)e);
            }
        }
        if (resultLabel != null) {
            return resultLabel;
        }
        return IRIUtil.makeLabelFromValue((Value)predicate);
    }

    private String replaceRejectedPredicates(String queryString, List<String> rejectedPredicates) {
        String rejectedPredicatesString = "";
        Object rejectedPredicatesStringStartsWith = "";
        if (CollectionUtils.isNotEmpty(rejectedPredicates)) {
            List rejectedPredicatesStartsWith;
            List rejectedPredicatesFullMatch = rejectedPredicates.stream().filter(rp -> !rp.endsWith("*")).map(rp -> "<" + rp + ">").collect(Collectors.toList());
            if (!rejectedPredicatesFullMatch.isEmpty()) {
                rejectedPredicatesString = String.join((CharSequence)" , ", rejectedPredicatesFullMatch);
            }
            if (!(rejectedPredicatesStartsWith = rejectedPredicates.stream().filter(rp -> rp.endsWith("*")).map(rp -> "!strstarts(str(?p), \"" + rp.substring(0, rp.length() - 1) + "\")").collect(Collectors.toList())).isEmpty()) {
                rejectedPredicatesStringStartsWith = "FILTER(" + String.join((CharSequence)" && ", rejectedPredicatesStartsWith) + ")";
            }
        }
        queryString = queryString.replaceAll(Pattern.quote("{{rejectedPredicates}}"), rejectedPredicatesString);
        queryString = queryString.replaceAll(Pattern.quote("{{rejectedPredicatesStartsWith}}"), (String)rejectedPredicatesStringStartsWith);
        return queryString;
    }

    private String getReplacePreferredRejectedTypes(String queryString, List<String> preferredPredicates, List<String> rejectedPredicates, List<String> preferredTypes, List<String> rejectedTypes, boolean onlyPreferredPredicates, boolean onlyPreferredTypes) {
        queryString = GraphExploreController.replacePreferredString(preferredPredicates, queryString, "{{preferredPredicates}}", "VALUES ( ?p ?preferredPredicates )", "?preferredPredicates", onlyPreferredPredicates);
        queryString = this.replaceRejectedPredicates(queryString, rejectedPredicates);
        queryString = GraphExploreController.replacePreferredString(preferredTypes, queryString, "{{preferredTypes}}", "?peer a ?type. VALUES ( ?type ?preferredTypes ) ", "?preferredTypes", onlyPreferredTypes);
        if (rejectedTypes != null) {
            String rejectedTypesString = rejectedTypes.stream().map(rt -> "( <" + rt + "> )").collect(Collectors.joining());
            queryString = queryString.replaceAll(Pattern.quote("{{rejectedTypes}}"), rejectedTypesString);
        } else {
            queryString = queryString.replaceAll(Pattern.quote("{{rejectedTypes}}"), "");
        }
        return queryString;
    }

    private static String replacePreferredString(List<String> preferredCollection, String queryString, String mainPlaceHolder, String valuesClause, String variable, boolean onlyPreferred) {
        if (preferredCollection != null && !preferredCollection.isEmpty()) {
            String preferredTypesString = (onlyPreferred ? "" : "OPTIONAL { ") + valuesClause + " { " + IntStream.range(0, preferredCollection.size()).mapToObj(i -> "(<" + (String)preferredCollection.get(i) + "> " + i + ")").collect(Collectors.joining()) + "}" + (onlyPreferred ? "" : " } ") + " BIND (IF(BOUND(" + variable + "), " + variable + ", 10000000 ) AS " + variable + "Norm)";
            queryString = queryString.replaceAll(Pattern.quote(mainPlaceHolder), preferredTypesString);
        } else {
            queryString = queryString.replaceAll(Pattern.quote(mainPlaceHolder), "BIND(10000000 AS " + variable + "Norm)");
        }
        return queryString;
    }

    @Hidden
    @RequestMapping(value={"/saved/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<SavedGraph> getSavedGraph(@PathVariable String id) {
        SavedGraph savedGraph = this.savedGraphService.getSavedGraph(id);
        if (savedGraph != null) {
            return new ResponseEntity((Object)savedGraph, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @Hidden
    @RequestMapping(value={"/saved"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<List<SavedGraph>> getSavedGraphs() {
        return new ResponseEntity(this.savedGraphService.getSavedGraphs(), (HttpStatusCode)HttpStatus.OK);
    }

    @Hidden
    @RequestMapping(value={"/saved"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> createSavedGraph(@Valid @RequestBody SavedGraph savedGraph) {
        SavedGraph existing = this.savedGraphService.getSavedGraphByName(savedGraph.getName());
        if (existing == null) {
            SavedGraph saved = this.savedGraphService.createSavedGraph(savedGraph);
            return new ResponseEntity(GraphExploreController.singletonHeader("X-Saved-Graph-Id", saved.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        return new ResponseEntity((Object)"Saved graph with that name already exists.", GraphExploreController.singletonHeader("X-Saved-Graph-Id", existing.getId()), (HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @Hidden
    @RequestMapping(value={"/saved/{id}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<?> editSavedGraph(@PathVariable String id, @Valid @RequestBody SavedGraph savedGraph) {
        savedGraph.setId(id);
        this.savedGraphService.editSavedGraph(savedGraph);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @Hidden
    @RequestMapping(value={"/saved/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<?> deleteSavedGraph(@PathVariable String id) {
        this.savedGraphService.deleteSavedGraph(id);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @Hidden
    @RequestMapping(value={"/samples"}, method={RequestMethod.GET})
    public ResponseEntity<List<VisualGraphConfig>> getSampleConfigs() {
        ArrayList<VisualGraphConfig> samples = new ArrayList<VisualGraphConfig>();
        samples.add(this.graphConfigService.getBareMinimumConfig());
        samples.add(this.graphConfigService.getAdvancedConfig());
        samples.addAll(this.graphConfigService.getAllConfigs());
        return new ResponseEntity(samples, (HttpStatusCode)HttpStatus.OK);
    }

    private SemanticRepository getRepository() {
        return this.semanticDataManagement.getCurrentRepositoryOrThrow();
    }

    private static MultiValueMap<String, String> singletonHeader(String key, String value) {
        return new LinkedMultiValueMap(Collections.singletonMap(key, Collections.singletonList(value)));
    }

    private Literal getLiteralBindingOrNull(BindingSet bs, String name) {
        Value v;
        Binding b = bs.getBinding(name);
        if (b != null && (v = b.getValue()) instanceof Literal) {
            return (Literal)v;
        }
        return null;
    }

    private void getLinksFromQuery(List<Link> links, RepositoryConnection connection, String queryString, Resource resource, boolean isOntopRepo, boolean includeInferred, boolean sameAsState) {
        TupleQuery query = connection.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
        query.setBinding("node", (Value)resource);
        if (!isOntopRepo) {
            query.setIncludeInferred(includeInferred);
            this.addSameAsGraph((Query)query, sameAsState);
        }
        try (TupleQueryResult tupleQueryResult = query.evaluate();){
            while (tupleQueryResult.hasNext()) {
                BindingSet next = (BindingSet)tupleQueryResult.next();
                if (!next.hasBinding("peer")) continue;
                String[] predicates = next.getValue("preds").stringValue().split("<>");
                Value peer = next.getValue("peer");
                this.createLinkFromTriple(links, peer);
                for (String predicate : predicates) {
                    char direction = predicate.charAt(0);
                    char isTriple = predicate.charAt(1);
                    predicate = predicate.substring(3, predicate.length() - 1);
                    IRI predIRI = VF.createIRI(predicate);
                    Link l = new Link();
                    if (direction == 'L') {
                        l.setSource((Value)resource);
                        l.setTarget(peer);
                        if (isTriple == 'Y') {
                            this.getLinksFromQuery(links, connection, queryString, (Resource)VF.createTriple(resource, predIRI, peer), isOntopRepo, includeInferred, sameAsState);
                        }
                    } else {
                        l.setSource(peer);
                        l.setTarget((Value)resource);
                        if (isTriple == 'Y') {
                            this.getLinksFromQuery(links, connection, queryString, (Resource)VF.createTriple((Resource)peer, predIRI, (Value)resource), isOntopRepo, includeInferred, sameAsState);
                        }
                    }
                    this.addPredicate(links, predIRI, l);
                }
            }
        }
    }

    private void createLinkFromTriple(List<Link> links, Value value) {
        if (value instanceof Triple) {
            Link link = new Link();
            link.setSource((Value)((Triple)value).getSubject());
            link.setTarget(((Triple)value).getObject());
            this.addPredicate(links, ((Triple)value).getPredicate(), link);
        }
    }

    private void addPredicate(List<Link> links, IRI predIRI, Link l) {
        Link foundLink = links.stream().filter(link -> link.getSource().equals(l.getSource()) && link.getTarget().equals(l.getTarget())).findFirst().orElse(null);
        if (foundLink != null) {
            foundLink.addRawPredicate(predIRI);
        } else {
            l.addRawPredicate(predIRI);
            links.add(l);
        }
    }

    private static class VarNamesVisitor
    extends AbstractQueryModelVisitor<RuntimeException> {
        Set<String> varNames = new HashSet<String>();

        VarNamesVisitor(TupleExpr tupleExpr) {
            tupleExpr.visit((QueryModelVisitor)this);
        }

        public void meet(Var node) throws RuntimeException {
            super.meet(node);
            this.varNames.add(node.getName());
        }

        public boolean hasVarName(String varName) {
            return this.varNames.contains(varName);
        }
    }
}

