/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.graphexplore;

import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.SparqlService;
import com.ontotext.forest.core.semantic.repository.SemanticRepository;
import com.ontotext.forest.core.service.URIPrefixService;
import com.ontotext.forest.graphexplore.model.Graph;
import com.ontotext.forest.graphexplore.service.DomainRangeGraphService;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/rest/domain-range"})
@RestController
public class DomainRangeGraphController {
    private static final Logger LOG = LoggerFactory.getLogger(DomainRangeGraphController.class);
    private final SemanticDataManagement semanticDataManagement;
    private final SparqlService sparqlService;
    private final DomainRangeGraphService domainRangeGraphService;
    private final URIPrefixService uriPrefixService;

    @Autowired
    public DomainRangeGraphController(SparqlService sparqlService, DomainRangeGraphService domainRangeGraphService, SemanticDataManagement semanticDataManagement, URIPrefixService uriPrefixService) {
        this.sparqlService = sparqlService;
        this.domainRangeGraphService = domainRangeGraphService;
        this.semanticDataManagement = semanticDataManagement;
        this.uriPrefixService = uriPrefixService;
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.HEAD}, produces={"application/json"})
    public ResponseEntity<Graph> getDomainRangeOfProperty(final @RequestParam(value="collapsed", required=false, defaultValue="true") boolean collapsed, final @RequestParam(value="targetUri") String targetUri) throws GraphDBWorkbenchException {
        SemanticRepository repo = this.semanticDataManagement.getCurrentRepositoryOrThrow();
        final List namespaces = repo.getNamespaces();
        SemanticRepository semanticRepository = repo;
        Objects.requireNonNull(semanticRepository);
        Graph propertiesGraph = (Graph)new SemanticRepository.WithConnection<Graph>(semanticRepository){

            protected Graph doInConnection() throws RepositoryException {
                try {
                    String queryString = DomainRangeGraphController.this.sparqlService.readQueryString("dataviz-queries/getPredicateDomainRangeTypeProperty");
                    queryString = queryString.replaceAll(Pattern.quote("{{target_class}}"), "<" + targetUri + ">");
                    TupleQueryResult queryResult = this.prepareAndEvaluate(queryString);
                    Map rawResults = DomainRangeGraphController.this.sparqlService.getResultsForAllQueryBindings(queryResult);
                    Map resolvedResults = DomainRangeGraphController.this.uriPrefixService.resolveNamespacesForMultipleBindings(rawResults, namespaces, new String[0]);
                    if (collapsed) {
                        return DomainRangeGraphController.this.domainRangeGraphService.constructCollapsedPropertiesGraph(rawResults, resolvedResults, targetUri);
                    }
                    return DomainRangeGraphController.this.domainRangeGraphService.constructPropertiesGraph(rawResults, resolvedResults, targetUri);
                }
                catch (Exception e) {
                    LOG.error("Cannot get domain-range graph ", (Throwable)e);
                    return null;
                }
            }
        }.run();
        if (propertiesGraph == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        if (propertiesGraph.getNodes().size() == 1) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity((Object)propertiesGraph, (HttpStatusCode)HttpStatus.OK);
    }
}

