/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.graphexplore;

import com.fasterxml.jackson.annotation.JsonView;
import com.google.common.collect.Maps;
import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.repository.SemanticRepository;
import com.ontotext.forest.core.service.URIPrefixService;
import com.ontotext.forest.graphexplore.model.RdfClass;
import com.ontotext.forest.graphexplore.service.ClassHierachyStorageService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.helpers.NTriplesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/rest/class-hierarchy"})
@RestController
public class ClassHierarchyController {
    private static final Logger LOG = LoggerFactory.getLogger(ClassHierarchyController.class);
    private final SemanticDataManagement semanticDataManagement;
    private final URIPrefixService uriPrefixService;
    private ClassHierachyStorageService classHierachyStorageService;

    @Autowired
    public ClassHierarchyController(SemanticDataManagement semanticDataManagement, URIPrefixService uriPrefixService, ClassHierachyStorageService classHierachyStorageService) {
        this.semanticDataManagement = semanticDataManagement;
        this.uriPrefixService = uriPrefixService;
        this.classHierachyStorageService = classHierachyStorageService;
    }

    @JsonView(value={RdfClass.UIView.class})
    @RequestMapping(method={RequestMethod.GET, RequestMethod.HEAD}, produces={"application/json"})
    public ResponseEntity<?> getRdfClassHierarchyFromImportedData(@RequestParam(value="doReload", required=false) boolean doReload, @RequestParam(required=false, defaultValue="") String graphURI) throws GraphDBWorkbenchException {
        try {
            RdfClass.ClassHierarchy classHierarchy = this.classHierachyStorageService.getClassHierarchy(doReload, graphURI);
            if (classHierarchy.isUpdated()) {
                return new ResponseEntity((Object)classHierarchy, (HttpStatusCode)HttpStatus.MULTI_STATUS);
            }
            if (classHierarchy.getChildren().isEmpty()) {
                return new ResponseEntity((Object)classHierarchy, (HttpStatusCode)HttpStatus.NO_CONTENT);
            }
            return new ResponseEntity((Object)classHierarchy, (HttpStatusCode)HttpStatus.OK);
        }
        catch (GraphDBWorkbenchException ex) {
            return new ResponseEntity((Object)ex.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/class-instances"}, method={RequestMethod.GET, RequestMethod.HEAD}, produces={"application/json"})
    public ResponseEntity<Map<String, String>> getClassInstances(final @RequestParam(value="targetUri", required=true) String targetURI) throws GraphDBWorkbenchException {
        SemanticRepository repo = this.semanticDataManagement.getCurrentRepositoryOrThrow();
        final List namespaces = repo.getNamespaces();
        SemanticRepository semanticRepository = repo;
        Objects.requireNonNull(semanticRepository);
        Map classInstances = (Map)new SemanticRepository.WithConnection<Map<String, String>>(semanticRepository){

            protected Map<String, String> doInConnection() throws RepositoryException {
                try {
                    HashMap resultMap = Maps.newHashMap();
                    List<String> rawClassInstances = this.getInstancesOfClass(targetURI);
                    List resolvedClassInstances = ClassHierarchyController.this.uriPrefixService.resolveNamespaces((Collection)namespaces, rawClassInstances);
                    for (int i = 0; i < rawClassInstances.size(); ++i) {
                        resultMap.put((String)resolvedClassInstances.get(i), rawClassInstances.get(i));
                    }
                    return resultMap;
                }
                catch (Exception e) {
                    LOG.error("Cannot get class instances of " + targetURI + ".", (Throwable)e);
                    return null;
                }
            }

            private List<String> getInstancesOfClass(String rdfClassUri) throws Exception {
                String listInstancesQuery = String.format("PREFIX onto: <http://www.ontotext.com/> SELECT ?s FROM onto:disable-sameAs { ?s a <%s> . } LIMIT 1000", rdfClassUri);
                ArrayList<String> instancesList = new ArrayList<String>();
                TupleQueryResult tqr = this.prepareAndEvaluate(listInstancesQuery);
                while (tqr.hasNext()) {
                    BindingSet bs = (BindingSet)tqr.next();
                    Value value = bs.getValue("s");
                    if (value instanceof Triple) {
                        instancesList.add(NTriplesUtil.toNTriplesString((Value)value));
                        continue;
                    }
                    instancesList.add(value.stringValue());
                }
                return instancesList;
            }
        }.run();
        if (classInstances == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        if (classInstances.isEmpty()) {
            return new ResponseEntity((Object)classInstances, (HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity((Object)classInstances, (HttpStatusCode)HttpStatus.OK);
    }
}

