/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.reformulation.rewriting.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.answering.reformulation.rewriting.impl.DownwardSaturatedImmutableSet;
import it.unibz.inf.ontop.answering.reformulation.rewriting.impl.TreeWitnessGenerator;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.spec.ontology.ClassExpression;
import it.unibz.inf.ontop.spec.ontology.ClassifiedTBox;
import it.unibz.inf.ontop.spec.ontology.Equivalences;
import it.unibz.inf.ontop.spec.ontology.ObjectPropertyExpression;
import it.unibz.inf.ontop.spec.ontology.ObjectSomeValuesFrom;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Stream;

public class TreeWitnessRewriterReasoner {
    private final ClassifiedTBox classifiedTBox;
    private final ImmutableList<TreeWitnessGenerator> treeWitnessGenerators;

    TreeWitnessRewriterReasoner(ClassifiedTBox classifiedTBox) {
        this.classifiedTBox = classifiedTBox;
        this.treeWitnessGenerators = (ImmutableList)classifiedTBox.classesDAG().stream().flatMap(this::getTreeWitnessGenerators).collect(ImmutableCollectors.toList());
    }

    public ClassifiedTBox getClassifiedTBox() {
        return this.classifiedTBox;
    }

    public DownwardSaturatedImmutableSet<ObjectPropertyExpression> getSubProperties(Collection<DataAtom<RDFAtomPredicate>> atoms, Map.Entry<VariableOrGroundTerm, VariableOrGroundTerm> idx) {
        return atoms.stream().map(a -> this.getSubProperties((DataAtom<RDFAtomPredicate>)a, idx)).collect(DownwardSaturatedImmutableSet.toIntersection());
    }

    private DownwardSaturatedImmutableSet<ObjectPropertyExpression> getSubProperties(DataAtom<RDFAtomPredicate> atom, Map.Entry<VariableOrGroundTerm, VariableOrGroundTerm> idx) {
        return ((RDFAtomPredicate)atom.getPredicate()).getPropertyIRI(atom.getArguments()).filter(i -> this.classifiedTBox.objectProperties().contains(i)).map(i -> (ObjectPropertyExpression)this.classifiedTBox.objectProperties().get(i)).map(p -> this.isInverse(atom, idx) ? p.getInverse() : p).map(p -> DownwardSaturatedImmutableSet.create(this.classifiedTBox.objectPropertiesDAG().getSubRepresentatives(p))).orElse(DownwardSaturatedImmutableSet.bottom());
    }

    private boolean isInverse(DataAtom<RDFAtomPredicate> a, Map.Entry<VariableOrGroundTerm, VariableOrGroundTerm> idx) {
        VariableOrGroundTerm subject = (VariableOrGroundTerm)((RDFAtomPredicate)a.getPredicate()).getSubject(a.getArguments());
        VariableOrGroundTerm object = (VariableOrGroundTerm)((RDFAtomPredicate)a.getPredicate()).getObject(a.getArguments());
        if (subject.equals(idx.getKey()) && object.equals(idx.getValue())) {
            return false;
        }
        if (subject.equals(idx.getValue()) && object.equals(idx.getKey())) {
            return true;
        }
        throw new MinorOntopInternalBugException("non-matching arguments: " + a + " " + idx);
    }

    public DownwardSaturatedImmutableSet<ClassExpression> getSubConcepts(Collection<DataAtom<RDFAtomPredicate>> atoms) {
        return atoms.stream().map(this::getSubConcepts).collect(DownwardSaturatedImmutableSet.toIntersection());
    }

    private DownwardSaturatedImmutableSet<ClassExpression> getSubConcepts(DataAtom<RDFAtomPredicate> atom) {
        return ((RDFAtomPredicate)atom.getPredicate()).getClassIRI(atom.getArguments()).filter(i -> this.classifiedTBox.classes().contains(i)).map(i -> this.getSubConcepts((ClassExpression)this.classifiedTBox.classes().get(i))).orElse(DownwardSaturatedImmutableSet.bottom());
    }

    public DownwardSaturatedImmutableSet<ClassExpression> getSubConcepts(ClassExpression c) {
        return DownwardSaturatedImmutableSet.create(this.classifiedTBox.classesDAG().getSubRepresentatives((Object)c));
    }

    public ImmutableList<TreeWitnessGenerator> getTreeWitnessGenerators() {
        return this.treeWitnessGenerators;
    }

    private Stream<TreeWitnessGenerator> getTreeWitnessGenerators(Equivalences<ClassExpression> eq) {
        ImmutableList properties = (ImmutableList)this.getDistinctRepresentativesForProperties(eq).collect(ImmutableCollectors.toList());
        if (properties.isEmpty()) {
            return Stream.of(new TreeWitnessGenerator[0]);
        }
        ImmutableSet maximalRepresentatives = (ImmutableSet)Stream.concat(this.classifiedTBox.classesDAG().getDirectSub(eq).stream().map(Equivalences::getRepresentative), this.getNonTrivialEquivalents(eq)).collect(ImmutableCollectors.toSet());
        if (maximalRepresentatives.isEmpty()) {
            return Stream.of(new TreeWitnessGenerator[0]);
        }
        return properties.stream().map(p -> new TreeWitnessGenerator((ObjectPropertyExpression)p, this.getSubConcepts((ClassExpression)eq.getRepresentative()), (ImmutableSet<ClassExpression>)maximalRepresentatives));
    }

    private Stream<ClassExpression> getNonTrivialEquivalents(Equivalences<ClassExpression> eq) {
        if (!(eq.getRepresentative() instanceof ObjectSomeValuesFrom)) {
            return Stream.of((ClassExpression)eq.getRepresentative());
        }
        ObjectPropertyExpression property = ((ObjectSomeValuesFrom)eq.getRepresentative()).getProperty();
        return this.getDistinctRepresentativesForProperties(eq).filter(p -> p != property).map(ObjectPropertyExpression::getDomain);
    }

    private Stream<ObjectPropertyExpression> getDistinctRepresentativesForProperties(Equivalences<ClassExpression> eq) {
        return eq.stream().filter(ce -> ce instanceof ObjectSomeValuesFrom).map(ce -> (ObjectSomeValuesFrom)ce).map(ObjectSomeValuesFrom::getProperty).map(p -> this.classifiedTBox.objectPropertiesDAG().getVertex(p)).map(Equivalences::getRepresentative).distinct();
    }
}

