/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.reformulation.rewriting.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.answering.reformulation.rewriting.impl.DownwardSaturatedImmutableSet;
import it.unibz.inf.ontop.answering.reformulation.rewriting.impl.QueryConnectedComponent;
import it.unibz.inf.ontop.answering.reformulation.rewriting.impl.TreeWitness;
import it.unibz.inf.ontop.answering.reformulation.rewriting.impl.TreeWitnessGenerator;
import it.unibz.inf.ontop.answering.reformulation.rewriting.impl.TreeWitnessSet;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.spec.ontology.ClassExpression;
import it.unibz.inf.ontop.spec.ontology.ObjectPropertyExpression;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryFolding {
    private final TreeWitnessSet.CachedClassifiedTBoxWrapper cache;
    private DownwardSaturatedImmutableSet<ObjectPropertyExpression> properties;
    private final Set<QueryConnectedComponent.Loop> roots;
    private DownwardSaturatedImmutableSet<ClassExpression> internalRootConcepts;
    private Set<VariableOrGroundTerm> internalRoots;
    private Set<VariableOrGroundTerm> internalDomain;
    private List<TreeWitness> interior;
    private TreeWitness.TermCover terms;
    private boolean status;
    private static final Logger log = LoggerFactory.getLogger(QueryFolding.class);

    public String toString() {
        return "Query Folding: " + this.roots + ", internal roots " + this.internalRoots + " and domain: " + this.internalDomain + " with properties: " + this.properties;
    }

    public QueryFolding(TreeWitnessSet.CachedClassifiedTBoxWrapper cache) {
        this.cache = cache;
        this.properties = DownwardSaturatedImmutableSet.top();
        this.roots = new HashSet<QueryConnectedComponent.Loop>();
        this.internalRootConcepts = DownwardSaturatedImmutableSet.top();
        this.internalRoots = new HashSet<VariableOrGroundTerm>();
        this.internalDomain = new HashSet<VariableOrGroundTerm>();
        this.interior = Collections.emptyList();
        this.status = true;
    }

    public QueryFolding(QueryFolding qf) {
        this.cache = qf.cache;
        this.properties = qf.properties;
        this.roots = new HashSet<QueryConnectedComponent.Loop>(qf.roots);
        this.internalRootConcepts = qf.internalRootConcepts;
        this.internalRoots = new HashSet<VariableOrGroundTerm>(qf.internalRoots);
        this.internalDomain = new HashSet<VariableOrGroundTerm>(qf.internalDomain);
        this.interior = new LinkedList<TreeWitness>(qf.interior);
        this.status = qf.status;
    }

    public QueryFolding extend(TreeWitness tw) {
        assert (this.status);
        QueryFolding c = new QueryFolding(this);
        c.internalRoots.addAll((Collection<VariableOrGroundTerm>)tw.getRoots());
        c.internalDomain.addAll((Collection<VariableOrGroundTerm>)tw.getDomain());
        c.interior.add(tw);
        c.internalRootConcepts = DownwardSaturatedImmutableSet.intersectionOf(c.internalRootConcepts, tw.getRootConcepts());
        if (c.internalRootConcepts.isBottom()) {
            c.status = false;
        }
        return c;
    }

    public boolean extend(QueryConnectedComponent.Loop root, QueryConnectedComponent.Edge edge, QueryConnectedComponent.Loop internalRoot) {
        assert (this.status);
        this.properties = DownwardSaturatedImmutableSet.intersectionOf(this.properties, this.cache.getEdgeProperties(edge, root.getTerm(), internalRoot.getTerm()));
        if (!this.properties.isBottom()) {
            this.internalRootConcepts = DownwardSaturatedImmutableSet.intersectionOf(this.internalRootConcepts, this.cache.getLoopConcepts(internalRoot));
            if (!this.internalRootConcepts.isBottom()) {
                this.roots.add(root);
                return true;
            }
        }
        this.status = false;
        return false;
    }

    public void newOneStepFolding(VariableOrGroundTerm t) {
        this.properties = DownwardSaturatedImmutableSet.top();
        this.roots.clear();
        this.internalRootConcepts = DownwardSaturatedImmutableSet.top();
        this.internalDomain = Collections.singleton(t);
        this.terms = null;
        this.status = true;
    }

    public void newQueryFolding(TreeWitness tw) {
        this.properties = DownwardSaturatedImmutableSet.top();
        this.roots.clear();
        this.internalRootConcepts = tw.getRootConcepts();
        this.internalRoots = new HashSet<VariableOrGroundTerm>((Collection<VariableOrGroundTerm>)tw.getRoots());
        this.internalDomain = new HashSet<VariableOrGroundTerm>((Collection<VariableOrGroundTerm>)tw.getDomain());
        this.interior = new LinkedList<TreeWitness>();
        this.interior.add(tw);
        this.terms = null;
        this.status = true;
    }

    public DownwardSaturatedImmutableSet<ObjectPropertyExpression> getProperties() {
        return this.properties;
    }

    public boolean isValid() {
        return this.status;
    }

    public Set<QueryConnectedComponent.Loop> getRoots() {
        return this.roots;
    }

    public boolean hasRoot() {
        return !this.roots.isEmpty();
    }

    public boolean canBeAttachedToAnInternalRoot(QueryConnectedComponent.Loop t0, QueryConnectedComponent.Loop t1) {
        return this.internalRoots.contains(t0.getTerm()) && !this.internalDomain.contains(t1.getTerm());
    }

    public DownwardSaturatedImmutableSet<ClassExpression> getInternalRootConcepts() {
        return this.internalRootConcepts;
    }

    public Collection<TreeWitness> getInteriorTreeWitnesses() {
        return this.interior;
    }

    public TreeWitness.TermCover getTerms() {
        if (this.terms == null) {
            ImmutableSet rootNewLiterals = (ImmutableSet)this.roots.stream().map(QueryConnectedComponent.Loop::getTerm).collect(ImmutableCollectors.toSet());
            ImmutableSet domain = (ImmutableSet)Stream.concat(this.internalDomain.stream(), rootNewLiterals.stream()).collect(ImmutableCollectors.toSet());
            this.terms = new TreeWitness.TermCover((ImmutableSet<VariableOrGroundTerm>)domain, (ImmutableSet<VariableOrGroundTerm>)rootNewLiterals);
        }
        return this.terms;
    }

    public TreeWitness getTreeWitness(ImmutableList<TreeWitnessGenerator> twg, Collection<QueryConnectedComponent.Edge> edges) {
        DownwardSaturatedImmutableSet<Object> rootType;
        log.debug("NEW TREE WITNESS");
        log.debug("  PROPERTIES {}", this.properties);
        log.debug("  ENDTYPE {}", this.internalRootConcepts);
        boolean nonExistentialRoot = this.roots.stream().anyMatch(r -> !r.isExistentialVariable());
        ImmutableList edgesInRoots = (ImmutableList)edges.stream().filter(edge -> this.roots.contains(edge.getLoop0()) && this.roots.contains(edge.getLoop1())).collect(ImmutableCollectors.toList());
        ImmutableSet rootAtoms = (ImmutableSet)Stream.concat(this.roots.stream().flatMap(root -> root.getAtoms().stream()), edgesInRoots.stream().flatMap(edge -> edge.getBAtoms().stream())).collect(ImmutableCollectors.toSet());
        log.debug("  ROOTTYPE {}", (Object)rootAtoms);
        if (nonExistentialRoot || !edgesInRoots.isEmpty()) {
            rootType = DownwardSaturatedImmutableSet.bottom();
            if (nonExistentialRoot) {
                log.debug("  NOT MERGEABLE: {} ARE NOT QUANTIFIED", this.roots.stream().filter(r -> r.isExistentialVariable()).collect(ImmutableCollectors.toList()));
            }
            if (!edgesInRoots.isEmpty()) {
                log.debug("  NOT MERGEABLE: {} ARE WITHIN THE ROOTS", (Object)edgesInRoots);
            }
        } else {
            rootType = this.roots.stream().map(root -> this.cache.getLoopConcepts((QueryConnectedComponent.Loop)root)).collect(DownwardSaturatedImmutableSet.toIntersection());
            if (rootType.isBottom()) {
                log.debug("  NOT MERGEABLE: BOTTOM ROOT CONCEPT");
            }
        }
        return new TreeWitness(twg, this.getTerms(), (ImmutableSet<DataAtom<RDFAtomPredicate>>)rootAtoms, rootType);
    }
}

