/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.reformulation.rewriting.impl;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.answering.reformulation.rewriting.impl.TreeWitness;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CompatibleTreeWitnessSetIterator
implements Iterator<ImmutableCollection<TreeWitness>> {
    private final ImmutableList<TreeWitness> tws;
    private final boolean[] in;
    private ImmutableList<TreeWitness> nextSet = null;

    CompatibleTreeWitnessSetIterator(ImmutableList<TreeWitness> tws) {
        this.tws = tws;
        this.in = new boolean[tws.size()];
    }

    @Override
    public ImmutableCollection<TreeWitness> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("The next method was called when no more objects remained.");
        }
        ImmutableList<TreeWitness> result = this.nextSet;
        this.nextSet = null;
        return result;
    }

    @Override
    public boolean hasNext() {
        if (this.nextSet != null) {
            return !this.isLast();
        }
        while (!this.isLast()) {
            boolean carry = true;
            for (int i = 0; i < this.in.length && carry; ++i) {
                carry = this.in[i];
                this.in[i] = !this.in[i];
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < this.in.length; ++i) {
                if (!this.in[i]) continue;
                builder.add((Object)((TreeWitness)this.tws.get(i)));
            }
            this.nextSet = builder.build();
            if (TreeWitness.isCompatible(this.nextSet)) {
                return true;
            }
            this.nextSet = null;
        }
        return false;
    }

    private boolean isLast() {
        for (boolean b : this.in) {
            if (b) continue;
            return false;
        }
        return true;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("The CompatibleTreeWitnessSetIterator class does not support the remove method.");
    }
}

