/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.logging.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.IntensionalDataNode;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.iq.visit.impl.AbstractPredicateExtractor;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.vocabulary.RDF;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.IRI;

@Singleton
public class ClassAndPropertyExtractor
extends AbstractPredicateExtractor<IntensionalDataNode> {
    @Inject
    protected ClassAndPropertyExtractor() {
    }

    public ClassesAndProperties extractClassesAndProperties(IQ iq) {
        ImmutableList atoms = (ImmutableList)((Stream)iq.getTree().acceptVisitor((IQVisitor)this)).map(IntensionalDataNode::getProjectionAtom).filter(a -> a.getPredicate() instanceof RDFAtomPredicate).map(a -> a).collect(ImmutableCollectors.toList());
        ImmutableSet classes = (ImmutableSet)atoms.stream().map(a -> ((RDFAtomPredicate)a.getPredicate()).getClassIRI(a.getArguments())).flatMap(Optional::stream).collect(ImmutableCollectors.toSet());
        ImmutableSet properties = (ImmutableSet)atoms.stream().map(a -> ((RDFAtomPredicate)a.getPredicate()).getPropertyIRI(a.getArguments())).flatMap(Optional::stream).filter(p -> !p.equals((Object)RDF.TYPE)).collect(ImmutableCollectors.toSet());
        return new ClassesAndProperties((ImmutableSet<IRI>)classes, (ImmutableSet<IRI>)properties);
    }

    public Stream<IntensionalDataNode> visitIntensionalData(IntensionalDataNode dataNode) {
        return Stream.of(dataNode);
    }

    public Stream<IntensionalDataNode> visitExtensionalData(ExtensionalDataNode dataNode) {
        return Stream.empty();
    }

    public static class ClassesAndProperties {
        private final ImmutableSet<IRI> classes;
        private final ImmutableSet<IRI> properties;

        protected ClassesAndProperties(ImmutableSet<IRI> classes, ImmutableSet<IRI> properties) {
            this.classes = classes;
            this.properties = properties;
        }

        public ImmutableSet<IRI> getClasses() {
            return this.classes;
        }

        public ImmutableSet<IRI> getProperties() {
            return this.properties;
        }
    }
}

