/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesItem;
import com.azure.ai.openai.responses.models.ResponsesStreamEvent;
import com.azure.ai.openai.responses.models.ResponsesStreamEventType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResponsesStreamEventOutputItemAdded
extends ResponsesStreamEvent {
    private ResponsesStreamEventType type = ResponsesStreamEventType.RESPONSE_OUTPUT_ITEM_ADDED;
    private final int outputIndex;
    private final ResponsesItem item;

    private ResponsesStreamEventOutputItemAdded(int outputIndex, ResponsesItem item) {
        this.outputIndex = outputIndex;
        this.item = item;
    }

    @Override
    public ResponsesStreamEventType getType() {
        return this.type;
    }

    public int getOutputIndex() {
        return this.outputIndex;
    }

    public ResponsesItem getItem() {
        return this.item;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("output_index", this.outputIndex);
        jsonWriter.writeJsonField("item", (JsonSerializable)this.item);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesStreamEventOutputItemAdded fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesStreamEventOutputItemAdded)jsonReader.readObject(reader -> {
            int outputIndex = 0;
            ResponsesItem item = null;
            ResponsesStreamEventType type = ResponsesStreamEventType.RESPONSE_OUTPUT_ITEM_ADDED;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("output_index".equals(fieldName)) {
                    outputIndex = reader.getInt();
                    continue;
                }
                if ("item".equals(fieldName)) {
                    item = ResponsesItem.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = ResponsesStreamEventType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesStreamEventOutputItemAdded deserializedResponsesStreamEventOutputItemAdded = new ResponsesStreamEventOutputItemAdded(outputIndex, item);
            deserializedResponsesStreamEventOutputItemAdded.type = type;
            return deserializedResponsesStreamEventOutputItemAdded;
        });
    }
}

