/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesAssistantMessage;
import com.azure.ai.openai.responses.models.ResponsesDeveloperMessage;
import com.azure.ai.openai.responses.models.ResponsesItem;
import com.azure.ai.openai.responses.models.ResponsesItemType;
import com.azure.ai.openai.responses.models.ResponsesMessageRole;
import com.azure.ai.openai.responses.models.ResponsesMessageStatus;
import com.azure.ai.openai.responses.models.ResponsesSystemMessage;
import com.azure.ai.openai.responses.models.ResponsesUserMessage;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class ResponsesMessage
extends ResponsesItem {
    private ResponsesItemType type = ResponsesItemType.MESSAGE;
    private ResponsesMessageRole role;
    private ResponsesMessageStatus status;

    @Override
    public ResponsesItemType getType() {
        return this.type;
    }

    public ResponsesMessageRole getRole() {
        return this.role;
    }

    public ResponsesMessageStatus getStatus() {
        return this.status;
    }

    ResponsesMessage setStatus(ResponsesMessageStatus status) {
        this.status = status;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesMessage fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesMessage)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                ResponsesMessage responsesMessage;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("role".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("user".equals(discriminatorValue)) {
                    responsesMessage = ResponsesUserMessage.fromJson(readerToUse.reset());
                    return responsesMessage;
                }
                if ("system".equals(discriminatorValue)) {
                    responsesMessage = ResponsesSystemMessage.fromJson(readerToUse.reset());
                    return responsesMessage;
                }
                if ("developer".equals(discriminatorValue)) {
                    responsesMessage = ResponsesDeveloperMessage.fromJson(readerToUse.reset());
                    return responsesMessage;
                }
                if ("assistant".equals(discriminatorValue)) {
                    responsesMessage = ResponsesAssistantMessage.fromJson(readerToUse.reset());
                    return responsesMessage;
                }
                responsesMessage = ResponsesMessage.fromJsonKnownDiscriminator(readerToUse.reset());
                return responsesMessage;
            }
        });
    }

    static ResponsesMessage fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (ResponsesMessage)jsonReader.readObject(reader -> {
            ResponsesMessage deserializedResponsesMessage = new ResponsesMessage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedResponsesMessage.setId(reader.getString());
                    continue;
                }
                if ("role".equals(fieldName)) {
                    deserializedResponsesMessage.role = ResponsesMessageRole.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedResponsesMessage.status = ResponsesMessageStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResponsesMessage;
        });
    }
}

