/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ChatMessageContentItem;
import com.azure.ai.openai.models.ChatRequestMessage;
import com.azure.ai.openai.models.ChatRole;
import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class ChatRequestToolMessage
extends ChatRequestMessage {
    private final BinaryData content;
    private final String stringContent;
    private final List<ChatMessageContentItem> chatMessageContentItems;
    private final String toolCallId;
    private ChatRole role = ChatRole.TOOL;

    public BinaryData getContent() {
        return this.content;
    }

    public String getStringContent() {
        return this.stringContent;
    }

    public List<ChatMessageContentItem> getListContent() {
        return this.chatMessageContentItems;
    }

    public ChatMessageContentItem[] getArrayContent() {
        return this.chatMessageContentItems == null ? null : this.chatMessageContentItems.toArray(new ChatMessageContentItem[0]);
    }

    public String getToolCallId() {
        return this.toolCallId;
    }

    @Override
    public ChatRole getRole() {
        return this.role;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.stringContent != null) {
            jsonWriter.writeStringField("content", this.stringContent);
        } else if (this.chatMessageContentItems != null) {
            jsonWriter.writeArrayField("content", this.chatMessageContentItems, JsonWriter::writeJson);
        } else {
            jsonWriter.writeNullField("content");
        }
        jsonWriter.writeStringField("tool_call_id", this.toolCallId);
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        return jsonWriter.writeEndObject();
    }

    public static ChatRequestToolMessage fromJson(JsonReader jsonReader) throws IOException {
        return (ChatRequestToolMessage)jsonReader.readObject(reader -> {
            Object content = null;
            String stringContent = null;
            List chatMessageContentItem = null;
            String toolCallId = null;
            ChatRole role = ChatRole.TOOL;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    if (reader.currentToken() == JsonToken.STRING) {
                        stringContent = reader.getString();
                        continue;
                    }
                    if (reader.currentToken() == JsonToken.START_ARRAY) {
                        chatMessageContentItem = reader.readArray(arrayReader -> (ChatMessageContentItem)arrayReader.readObject(ChatMessageContentItem::fromJson));
                        continue;
                    }
                    if (reader.currentToken() == JsonToken.NULL) {
                        content = null;
                        continue;
                    }
                    throw new IllegalStateException("Unexpected 'content' type found when deserializing ChatRequestToolMessage JSON object: " + reader.currentToken());
                }
                if ("tool_call_id".equals(fieldName)) {
                    toolCallId = reader.getString();
                    continue;
                }
                if ("role".equals(fieldName)) {
                    role = ChatRole.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ChatRequestToolMessage deserializedChatRequestToolMessage = CoreUtils.isNullOrEmpty(stringContent) && chatMessageContentItem == null ? new ChatRequestToolMessage(content, toolCallId) : (CoreUtils.isNullOrEmpty(stringContent) ? new ChatRequestToolMessage(chatMessageContentItem, toolCallId) : new ChatRequestToolMessage(stringContent, toolCallId));
            deserializedChatRequestToolMessage.role = role;
            return deserializedChatRequestToolMessage;
        });
    }

    private ChatRequestToolMessage(BinaryData content, String toolCallId) {
        this.content = content;
        this.toolCallId = toolCallId;
        this.stringContent = null;
        this.chatMessageContentItems = null;
    }

    public ChatRequestToolMessage(String content, String toolCallId) {
        this.content = BinaryData.fromString((String)content);
        this.toolCallId = toolCallId;
        this.stringContent = content;
        this.chatMessageContentItems = null;
    }

    public ChatRequestToolMessage(List<ChatMessageContentItem> content, String toolCallId) {
        this.content = BinaryData.fromObject(content);
        this.toolCallId = toolCallId;
        this.stringContent = null;
        this.chatMessageContentItems = content;
    }

    public ChatRequestToolMessage(ChatMessageContentItem[] content, String toolCallId) {
        this.content = BinaryData.fromObject((Object)content);
        this.toolCallId = toolCallId;
        this.stringContent = null;
        this.chatMessageContentItems = Arrays.asList(content);
    }
}

