/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.filter;

import com.ontotext.trree.plugin.externalsync.api.ConnectorUserException;
import com.ontotext.trree.plugin.externalsync.filter.AndExpression;
import com.ontotext.trree.plugin.externalsync.filter.BoundExpression;
import com.ontotext.trree.plugin.externalsync.filter.ConnectorFilterBaseVisitor;
import com.ontotext.trree.plugin.externalsync.filter.ConnectorFilterParser;
import com.ontotext.trree.plugin.externalsync.filter.ConstantOperand;
import com.ontotext.trree.plugin.externalsync.filter.EntityTypeExpression;
import com.ontotext.trree.plugin.externalsync.filter.EqExpression;
import com.ontotext.trree.plugin.externalsync.filter.ExistsExpression;
import com.ontotext.trree.plugin.externalsync.filter.Expression;
import com.ontotext.trree.plugin.externalsync.filter.FilterType;
import com.ontotext.trree.plugin.externalsync.filter.GreaterThanEqualExpression;
import com.ontotext.trree.plugin.externalsync.filter.GreaterThanExpression;
import com.ontotext.trree.plugin.externalsync.filter.InExpression;
import com.ontotext.trree.plugin.externalsync.filter.IsExplicitExpression;
import com.ontotext.trree.plugin.externalsync.filter.LessThanEqualExpression;
import com.ontotext.trree.plugin.externalsync.filter.LessThanExpression;
import com.ontotext.trree.plugin.externalsync.filter.NotEqExpression;
import com.ontotext.trree.plugin.externalsync.filter.NotExpression;
import com.ontotext.trree.plugin.externalsync.filter.Operand;
import com.ontotext.trree.plugin.externalsync.filter.OrExpression;
import com.ontotext.trree.plugin.externalsync.filter.RegexExpression;
import com.ontotext.trree.plugin.externalsync.impl.Property;
import com.ontotext.trree.plugin.externalsync.impl.TypeAndPropertyKeeper;
import com.ontotext.trree.sdk.Entities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.tree.RuleNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;

public class ConnectorFilterExpressionVisitor
extends ConnectorFilterBaseVisitor<Expression> {
    private static final ValueFactory VF = SimpleValueFactory.getInstance();
    private final Property contextProperty;
    private final Entities entities;
    private final TypeAndPropertyKeeper typeAndPropertyKeeper;
    private final Set<Property> filterDependencies;
    private final List<Operand> operands;
    private final FilterType filterType;
    private boolean needsToCollectGraph;

    private static String getCleanString(String s) {
        return s.substring(1, s.length() - 1).replaceAll("\\\\\"", "\"");
    }

    private static String getString(Token tn) {
        return tn != null ? tn.getText() : null;
    }

    private static IRI getCleanURI(String uri) {
        if (uri != null) {
            if ("type".equalsIgnoreCase(uri)) {
                return RDF.TYPE;
            }
            if (uri.startsWith("rdf:")) {
                return VF.createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#" + uri.substring("rdf:".length()));
            }
            if (uri.startsWith("xsd:")) {
                return VF.createIRI("http://www.w3.org/2001/XMLSchema#" + uri.substring("xsd:".length()));
            }
            return VF.createIRI(uri.substring(1, uri.length() - 1));
        }
        return null;
    }

    public ConnectorFilterExpressionVisitor(Property contextProperty, Entities entities, TypeAndPropertyKeeper typeAndPropertyKeeper, FilterType filterType) {
        this.contextProperty = contextProperty;
        this.entities = entities;
        this.typeAndPropertyKeeper = typeAndPropertyKeeper;
        this.operands = new ArrayList<Operand>();
        this.filterType = filterType;
        this.filterDependencies = new HashSet<Property>();
    }

    public boolean needsToCollectGraph() {
        return this.needsToCollectGraph;
    }

    @Override
    public Expression visitSingle_rule(@NotNull ConnectorFilterParser.Single_ruleContext ctx) {
        String operator = ctx.single_x().getText().toLowerCase();
        Operand operand = this.createOperand(ctx.operandOrValue(), true);
        if (operand.isGraph) {
            throw new ConnectorUserException(operator + "() in filter may not be applied on graphs.");
        }
        switch (operator) {
            case "bound": {
                if (operand.parentCount > 0 && operand.nexthopId == 0L) {
                    throw new ConnectorUserException(operator + "() in filter makes no sense when combined with parent() without looking at next hop.");
                }
                return new BoundExpression(operand);
            }
            case "isliteral": {
                return new EntityTypeExpression(operand, Entities.Type.LITERAL);
            }
            case "isiri": {
                return new EntityTypeExpression(operand, Entities.Type.URI);
            }
            case "exists": {
                return new ExistsExpression(operand);
            }
        }
        throw new ConnectorUserException("Unknown operator: " + operator);
    }

    @Override
    public Expression visitSingle_graph_rule(ConnectorFilterParser.Single_graph_ruleContext ctx) {
        String operator = ctx.single_graph_x().getText().toLowerCase();
        Operand operand = this.createOperand(ctx.baseOperand());
        if ("isexplicit".equals(operator)) {
            return new IsExplicitExpression(operand);
        }
        throw new ConnectorUserException("Unknown operator: " + operator);
    }

    @Override
    public Expression visitIn_rule(@NotNull ConnectorFilterParser.In_ruleContext ctx) {
        Operand operand = this.createOperand(ctx.operandOrValue(), true);
        List<ConnectorFilterParser.OperandOrValueContext> elements = ctx.in_x().operandOrValueList().elements;
        ArrayList<Operand> operands = new ArrayList<Operand>(elements.size());
        for (ConnectorFilterParser.OperandOrValueContext t : elements) {
            Operand operand2 = this.createOperand(t, false);
            operands.add(operand2);
        }
        Expression expr = new InExpression(operand, operands);
        if (ctx.in_x().NOT() != null) {
            expr = new NotExpression(expr);
        }
        return expr;
    }

    @Override
    public Expression visitRegex_rule(ConnectorFilterParser.Regex_ruleContext ctx) {
        String pattern = ConnectorFilterExpressionVisitor.getCleanString(ctx.pattern.getText());
        String flags = ctx.flags != null ? ConnectorFilterExpressionVisitor.getCleanString(ctx.flags.getText()) : null;
        Operand operand = this.createOperand(ctx.operandOrValue(), true);
        return new RegexExpression(operand, pattern, flags);
    }

    @Override
    public Expression visitExpression(@NotNull ConnectorFilterParser.ExpressionContext ctx) {
        if (ctx.AND() != null) {
            Expression e0 = this.visitExpression(ctx.expression(0));
            Expression e1 = this.visitExpression(ctx.expression(1));
            return new AndExpression(e0, e1);
        }
        if (ctx.OR() != null) {
            Expression e0 = this.visitExpression(ctx.expression(0));
            Expression e1 = this.visitExpression(ctx.expression(1));
            return new OrExpression(e0, e1);
        }
        if (ctx.NOT() != null) {
            return new NotExpression(this.visitExpression(ctx.expression(0)));
        }
        if (!ctx.expression().isEmpty()) {
            return this.visitExpression(ctx.expression(0));
        }
        return (Expression)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public Expression visitField_with_parent(@NotNull ConnectorFilterParser.Field_with_parentContext ctx) {
        return (Expression)super.visitField_with_parent(ctx);
    }

    @Override
    public Expression visitExp_rule(ConnectorFilterParser.Exp_ruleContext ctx) {
        String operator;
        Operand operand1 = this.createOperand(ctx.operandOrValue(0), true);
        Operand operand2 = this.createOperand(ctx.operandOrValue(1), false);
        switch (operator = ctx.exp_x().getText()) {
            case ">": {
                return new GreaterThanExpression(operand1, operand2);
            }
            case ">=": {
                return new GreaterThanEqualExpression(operand1, operand2);
            }
            case "<": {
                return new LessThanExpression(operand1, operand2);
            }
            case "<=": {
                return new LessThanEqualExpression(operand1, operand2);
            }
            case "=": {
                return new EqExpression(operand1, operand2);
            }
            case "!=": {
                return new NotEqExpression(operand1, operand2);
            }
        }
        throw new ConnectorUserException("Unknown operator: " + operator);
    }

    public List<Operand> getOperands() {
        return this.operands;
    }

    public Set<Property> getFilterDependencies() {
        return this.filterDependencies;
    }

    private Operand createOperand(ConnectorFilterParser.OperandOrValueContext octx, boolean isMainOperand) {
        Operand operand;
        if (octx.value() != null) {
            if (isMainOperand) {
                throw new ConnectorUserException("The first operand must be a variable and not a constant");
            }
            operand = new ConstantOperand(this.convertValue(octx.value()));
            this.operands.add(operand);
        } else {
            operand = this.createOperand(octx.operand().baseOperand());
        }
        return operand;
    }

    private Operand createOperand(ConnectorFilterParser.BaseOperandContext octx) {
        Set<Property> props;
        String expressionFieldName;
        long nexthopId = 0L;
        IRI uri = ConnectorFilterExpressionVisitor.getCleanURI(ConnectorFilterExpressionVisitor.getString(octx.field_with_parent_and_type().uri));
        if (uri != null) {
            nexthopId = this.entities.put((Value)uri, Entities.Scope.DEFAULT);
        }
        boolean isLang = octx.lang;
        boolean isThis = octx.isThis;
        boolean partial = false;
        String operandFieldName = expressionFieldName = octx.fieldName;
        Object propertyLookupFieldName = expressionFieldName;
        if (this.filterType != FilterType.NESTED_DOCUMENT && this.filterType != FilterType.PER_FIELD_VALUE && octx.outerCount > 0) {
            throw new ConnectorUserException("$outer can be used only in nested document filter");
        }
        if (octx.isThis) {
            if (this.filterType == FilterType.PER_FIELD_VALUE) {
                props = Collections.singleton(this.contextProperty);
                operandFieldName = this.contextProperty.getFieldNameWithSuffix();
                isThis = false;
                partial = true;
            } else {
                props = Collections.singleton(this.typeAndPropertyKeeper.getOrCreateThisProperty(this.entities));
                if (this.filterType == FilterType.NESTED_DOCUMENT) {
                    operandFieldName = this.contextProperty.getFieldName().fullyQualifiedNameWithSuffix;
                    if (octx.parentCount > 0) {
                        throw new ConnectorUserException("Using `PARENT($this)' in a nested document filter is not possible.");
                    }
                } else {
                    if (octx.graph && nexthopId == 0L) {
                        throw new ConnectorUserException("Using `GRAPH($this)' in the top-level filters is not possible.");
                    }
                    if (octx.parentCount > 0) {
                        throw new ConnectorUserException("Using `PARENT($this)' in the top-level filters is not possible.");
                    }
                }
            }
        } else {
            if (this.filterType == FilterType.NESTED_DOCUMENT || this.filterType == FilterType.PER_FIELD_VALUE) {
                int numberOfLevelsUp = octx.outerCount;
                if (this.filterType == FilterType.PER_FIELD_VALUE) {
                    ++numberOfLevelsUp;
                }
                Property property = this.contextProperty;
                for (int i = 0; i < numberOfLevelsUp; ++i) {
                    if (property == null) {
                        throw new ConnectorUserException("Cannot dereference $outer property, too many $outer. prefixes");
                    }
                    property = property.getParentProperty();
                }
                if (property != null) {
                    propertyLookupFieldName = property.getFieldName().fullyQualifiedNameWithSuffix + "." + expressionFieldName;
                }
            } else if (this.filterType == FilterType.VALUE) {
                throw new ConnectorUserException("Top-level value filter may only use $this and no field names");
            }
            props = this.typeAndPropertyKeeper.getPropertiesByFieldName((String)propertyLookupFieldName);
        }
        if (props.isEmpty()) {
            throw new ConnectorUserException("Field `" + expressionFieldName + "' not found in fields definition.");
        }
        for (Property p : props) {
            if (p.isReferenceTo()) {
                throw new ConnectorUserException("Field `" + expressionFieldName + "' is a referring field. Referring fields may not be used in filters.");
            }
            if (p.getPropertyChain().size() < octx.parentCount + 1) {
                throw new ConnectorUserException("Filter for field '" + expressionFieldName + "' uses more parents than there are in one of the sets of property chains.");
            }
            p.setHasFilterAtPosition(true, p.getPropertyChain().size() - octx.parentCount - 1);
            if (nexthopId != 0L) {
                p.addNextHopIdAtPosition(nexthopId, p.getPropertyChain().size() - octx.parentCount - 1);
            }
            if (octx.lang && p.isLang()) {
                throw new ConnectorUserException("Field `" + expressionFieldName + "' already references the language, don't use LANG(?x) with it.");
            }
            if (octx.graph && p.isGraph()) {
                throw new ConnectorUserException("Field `" + expressionFieldName + "' already references the graph, don't use GRAPH(?x) with it.");
            }
            isLang |= p.isLang();
        }
        this.filterDependencies.addAll(props);
        Operand operand = new Operand(operandFieldName, octx.parentCount, octx.outerCount, nexthopId, octx.graph, isLang, octx.all, isThis, partial);
        this.operands.add(operand);
        if (!(this.filterType != FilterType.DOCUMENT && this.filterType != FilterType.NESTED_DOCUMENT || operand.nexthopId != 0L || operand.isThis)) {
            this.needsToCollectGraph |= operand.isGraph;
        }
        return operand;
    }

    private Value convertValue(ConnectorFilterParser.ValueContext valueContext) {
        if (valueContext.literal != null) {
            String literalString = ConnectorFilterExpressionVisitor.getCleanString(valueContext.literal.getText());
            if (valueContext.datatype != null) {
                return VF.createLiteral(literalString, ConnectorFilterExpressionVisitor.getCleanURI(valueContext.datatype.getText()));
            }
            if (valueContext.language != null) {
                return VF.createLiteral(literalString, valueContext.language.getText().substring(1));
            }
            return VF.createLiteral(literalString);
        }
        return ConnectorFilterExpressionVisitor.getCleanURI(valueContext.getText());
    }
}

