/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.rdfrank;

import com.ontotext.trree.StatementIdIterator;
import com.ontotext.trree.big.collections.PairCollection;
import com.ontotext.trree.transactions.TransactionException;
import java.io.File;
import java.util.Arrays;
import org.slf4j.LoggerFactory;

public class TableStorage {
    private final long rows;
    private final long cols;
    private final PairCollection collection;
    private PairCollection.PairConnection connection;

    public TableStorage(String pathPrefix, long x, long y, int valuesBitSize) {
        this.rows = x;
        this.cols = y;
        File main_file = new File(pathPrefix);
        File index_file = new File(pathPrefix + ".index");
        main_file.delete();
        index_file.delete();
        this.collection = new PairCollection(main_file, 1000, valuesBitSize);
        try {
            this.collection.initialize();
        }
        catch (TransactionException e) {
            LoggerFactory.getLogger(this.getClass()).error("Failed initializing collection", (Throwable)e);
            return;
        }
        this.connection = this.collection.getConnection();
        try {
            this.connection.beginTransaction();
        }
        catch (TransactionException e) {
            LoggerFactory.getLogger(this.getClass()).error("Failed starting transaction", (Throwable)e);
            this.connection = null;
        }
    }

    public void add(long x, long y) {
        if (0L > x || x >= this.rows || 0L > y || y >= this.cols) {
            throw new IndexOutOfBoundsException();
        }
        if (this.connection == null) {
            throw new IllegalStateException("Storage not initialized");
        }
        this.connection.add(x, y);
    }

    public Iterator rowIterator(final long row) {
        return new Iterator(){
            private long[] values = new long[10];
            private int size;
            private int curr;
            {
                try (StatementIdIterator iter = TableStorage.this.connection.get(row, Long.MIN_VALUE, row, Long.MAX_VALUE);){
                    while (iter.hasNext()) {
                        if (this.size >= this.values.length) {
                            this.values = Arrays.copyOf(this.values, this.values.length * 2);
                        }
                        this.values[this.size++] = iter.pred;
                        iter.next();
                    }
                }
            }

            @Override
            public boolean hasNext() {
                return this.curr < this.size;
            }

            @Override
            public long next() {
                return this.values[this.curr++];
            }

            @Override
            public long size() {
                return this.size;
            }
        };
    }

    public void shutDown() {
        try {
            if (this.connection != null) {
                this.connection.commit();
            }
        }
        catch (TransactionException ex) {
            LoggerFactory.getLogger(this.getClass()).error("Failed committing collection", (Throwable)ex);
        }
        finally {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        this.collection.shutdown();
    }

    public static abstract class Iterator {
        public abstract boolean hasNext();

        public abstract long next();

        public abstract long size();
    }
}

