/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.rdfrank;

import com.ontotext.trree.plugin.rdfrank.GraphReader;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.StatementIterator;
import com.ontotext.trree.sdk.Statements;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class FilteredGraphReader
extends GraphReader {
    private static final Set<Long> EMPTY = Collections.emptySet();
    private Statements statements;
    private Entities entities;
    private Collection<StatementIterator> statementIterators;
    private Iterator<StatementIterator> statementIteratorsIterator;
    private StatementIterator currentStatementIterator = StatementIterator.EMPTY;
    private Set<Long> includedPredicates;
    private Set<Long> excludedPredicates;
    private Set<Long> includedGraphs;
    private Set<Long> excludedGraphs;
    private long object;
    private boolean includeImplicit;
    private boolean includeExplicit;
    private long size = 0L;

    FilteredGraphReader(Statements statements, Entities entities, Set<Long> includedPredicates, Set<Long> includedGraphs, Set<Long> excludedPredicates, Set<Long> excludedGraphs, boolean includeExplicit, boolean includeImplicit, long object) {
        this.statements = statements;
        this.entities = entities;
        this.includedPredicates = includedPredicates != null ? includedPredicates : EMPTY;
        this.excludedPredicates = excludedPredicates != null ? excludedPredicates : EMPTY;
        this.includedGraphs = includedGraphs != null ? includedGraphs : EMPTY;
        this.excludedGraphs = excludedGraphs != null ? excludedGraphs : EMPTY;
        this.includeImplicit = includeImplicit;
        this.includeExplicit = includeExplicit;
        this.object = object;
    }

    @Override
    public long nodeCount() {
        return this.entities.size();
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public void reset() {
        this.close();
        this.statementIterators = new LinkedList<StatementIterator>();
        if (this.includedPredicates.isEmpty()) {
            this.includedPredicates.add(0L);
        }
        if (this.includedGraphs.isEmpty()) {
            this.includedGraphs.add(0L);
        }
        for (long predicate : this.includedPredicates) {
            for (long graph : this.includedGraphs) {
                this.size += this.statements.estimateSize(0L, predicate, this.object, graph);
                this.statementIterators.add(this.statements.get(0L, predicate, this.object, graph));
            }
        }
        this.statementIteratorsIterator = this.statementIterators.iterator();
    }

    @Override
    public boolean next() {
        if (this.currentStatementIterator.next()) {
            while (this.isExcluded()) {
                if (this.currentStatementIterator.next()) continue;
                return false;
            }
            this.to = this.currentStatementIterator.object;
            this.from = this.currentStatementIterator.subject;
            return true;
        }
        if (this.statementIteratorsIterator.hasNext()) {
            this.currentStatementIterator = this.statementIteratorsIterator.next();
            return this.next();
        }
        return false;
    }

    @Override
    public void close() {
        if (this.statementIterators != null) {
            for (StatementIterator iterator : this.statementIterators) {
                iterator.close();
            }
        }
    }

    private boolean isExcluded() {
        return !this.includeImplicit && this.currentStatementIterator.isImplicit() || this.excludedPredicates.contains(this.currentStatementIterator.predicate) || this.excludedGraphs.contains(this.currentStatementIterator.context) || !this.includeExplicit && this.currentStatementIterator.isExplicit();
    }
}

