/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.rdfrank;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

class FileRankReader {
    private static final int SIZE_OF_RECORD = 12;
    private static final int PAGE_SIZE = 1000;
    private static final int MAX_PAGES = 1000;
    private String file;
    private long size;
    private int headerSize;
    private int availablePages;
    private double[] thresholds;
    private Page[] pages;

    FileRankReader(String rankFile) {
        this.file = rankFile;
        this.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void reload() {
        DataInputStream stream;
        this.headerSize = 0;
        try {
            stream = new DataInputStream(new FileInputStream(this.file));
        }
        catch (FileNotFoundException e) {
            return;
        }
        try {
            int magic2332 = stream.readInt();
            this.headerSize += 4;
            if (magic2332 != 279803902) {
                throw new RuntimeException("Invalid PageRank data detected. Please recompute PageRank values.");
            }
            int version = stream.readInt();
            this.headerSize += 4;
            if (version != 1) {
                throw new RuntimeException("Different PageRank data version detected. Please recompute PageRank values.");
            }
            int numberOfThresholds = stream.readInt();
            this.headerSize += 4;
            this.thresholds = new double[numberOfThresholds];
            for (int idx = 0; idx < this.thresholds.length; this.headerSize += 8, ++idx) {
                this.thresholds[idx] = stream.readDouble();
            }
        }
        catch (IOException e) {
            try {
                stream.close();
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            stream.close();
        }
        catch (IOException magic2332) {}
        this.size = (new File(this.file).length() - (long)this.headerSize) / 12L;
        assert (this.size / 1000L < Integer.MAX_VALUE);
        this.pages = new Page[(int)(this.size / 1000L) + 1];
        this.availablePages = 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private Page getPage(int pageIndex) throws IOException {
        Object object;
        Page[] pagesArray = this.pages;
        Page page = pagesArray[pageIndex];
        if (page == null) {
            object = pagesArray;
            // MONITORENTER : pagesArray
            if (pagesArray[pageIndex] == null) {
                if (this.availablePages == 0) {
                    int min = -1;
                    for (int idx = 0; idx < pagesArray.length; ++idx) {
                        if (pagesArray[idx] == null || min >= 0 && pagesArray[idx].hits >= pagesArray[min].hits) continue;
                        min = idx;
                    }
                    assert (min >= 0);
                    pagesArray[min] = null;
                    ++this.availablePages;
                }
                pagesArray[pageIndex] = new Page();
                --this.availablePages;
            }
            page = pagesArray[pageIndex];
            // MONITOREXIT : object
        }
        assert (page != null);
        object = page;
        // MONITORENTER : object
        if (!page.isInitialized) {
            try (FileInputStream fis = new FileInputStream(this.file);){
                fis.getChannel().position((long)this.headerSize + (long)pageIndex * 1000L * 12L);
                try (DataInputStream in = new DataInputStream(new BufferedInputStream(fis));){
                    long numberOfRanksInPage = Math.min((long)page.ranks.length, this.size - (long)pageIndex * 1000L);
                    int idx = 0;
                    while ((long)idx < numberOfRanksInPage) {
                        in.readInt();
                        ((Page)page).ranks[idx] = in.readDouble();
                        ++idx;
                    }
                }
            }
            page.isInitialized = true;
        }
        page.hits++;
        // MONITOREXIT : object
        return page;
    }

    long size() {
        return this.size;
    }

    double[] getThresholds() {
        return this.thresholds;
    }

    double read(long id) {
        if (id < 1L || id >= this.size) {
            return -1.0;
        }
        try {
            Page page = this.getPage((int)(id / 1000L));
            if (page == null) {
                return -1.0;
            }
            return page.ranks[(int)(id % 1000L)];
        }
        catch (IOException iox) {
            return -1.0;
        }
    }

    private static class Page {
        private boolean isInitialized;
        private double[] ranks = new double[1000];
        private int hits = 0;

        private Page() {
        }
    }
}

