/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.rdfrank;

import com.ontotext.trree.sdk.PluginException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class Configuration {
    private static final ValueFactory VF = SimpleValueFactory.getInstance();
    private final String file;
    private Properties properties;

    public Configuration(String file) {
        this.file = file;
    }

    public void initialize() {
        this.loadProperties();
    }

    public void save() {
        this.persistProperties();
    }

    public long getLastRankedId() {
        return Long.parseLong(this.getProperty(RDFRankProperty.LAST_RANKED_ID_PROPERTY));
    }

    public void setLastRankedId(long value) {
        this.setProperty(RDFRankProperty.LAST_RANKED_ID_PROPERTY, Long.toString(value));
    }

    public double getMinRank() {
        return Double.parseDouble(this.getProperty(RDFRankProperty.MIN_RANK_PROPERTY));
    }

    public void setMinRank(double value) {
        this.setProperty(RDFRankProperty.MIN_RANK_PROPERTY, Double.toString(value));
    }

    public double getMaxRank() {
        return Double.parseDouble(this.getProperty(RDFRankProperty.MAX_RANK_PROPERTY));
    }

    public void setMaxRank(double value) {
        this.setProperty(RDFRankProperty.MAX_RANK_PROPERTY, Double.toString(value));
    }

    public boolean getFilteringEnabled() {
        return Boolean.parseBoolean(this.getProperty(RDFRankProperty.FILTERING));
    }

    public void setFilteringEnabled(boolean value) {
        this.setProperty(RDFRankProperty.FILTERING, Boolean.toString(value));
    }

    public boolean getIncludeExplicit() {
        return Boolean.parseBoolean(this.getProperty(RDFRankProperty.INCLUDE_EXPLICIT));
    }

    public void setIncludeExplicit(boolean value) {
        this.setProperty(RDFRankProperty.INCLUDE_EXPLICIT, Boolean.toString(value));
    }

    public boolean getIncludeImplicit() {
        return Boolean.parseBoolean(this.getProperty(RDFRankProperty.INCLUDE_IMPLICIT));
    }

    public void setIncludeImplicit(boolean value) {
        this.setProperty(RDFRankProperty.INCLUDE_IMPLICIT, Boolean.toString(value));
    }

    public Collection<Value> getIncludedPredicates() {
        return this.getValueCollection(RDFRankProperty.INCLUDED_PREDICATES_PROPERTY);
    }

    public void setIncludedPredicates(Collection<Value> value) {
        this.setValueCollection(RDFRankProperty.INCLUDED_PREDICATES_PROPERTY, value);
    }

    public Collection<Value> getIncludedGraphs() {
        return this.getValueCollection(RDFRankProperty.INCLUDED_GRAPHS_PROPERTY);
    }

    public void setIncludedGraphs(Collection<Value> value) {
        this.setValueCollection(RDFRankProperty.INCLUDED_GRAPHS_PROPERTY, value);
    }

    public Collection<Value> getExcludedPredicates() {
        return this.getValueCollection(RDFRankProperty.EXCLUDED_PREDICATES_PROPERTY);
    }

    public void setExcludedPredicates(Collection<Value> value) {
        this.setValueCollection(RDFRankProperty.EXCLUDED_PREDICATES_PROPERTY, value);
    }

    public Collection<Value> getExcludedGraphs() {
        return this.getValueCollection(RDFRankProperty.EXCLUDED_GRAPHS_PROPERTY);
    }

    public void setExcludedGraphs(Collection<Value> value) {
        this.setValueCollection(RDFRankProperty.EXCLUDED_GRAPHS_PROPERTY, value);
    }

    public int getLastConfigCash() {
        return Integer.parseInt(this.getProperty(RDFRankProperty.COMPUTED_CONFIG_HASH));
    }

    public void setComputedConfigCash(int value) {
        this.setProperty(RDFRankProperty.COMPUTED_CONFIG_HASH, String.valueOf(value));
    }

    public Collection<Value> getValueCollection(RDFRankProperty property) {
        return Stream.of(this.getProperty(property).split("\n")).filter(iri -> !iri.equals("")).map(arg_0 -> ((ValueFactory)VF).createIRI(arg_0)).collect(Collectors.toList());
    }

    public void setValueCollection(RDFRankProperty property, Collection<? extends Value> value) {
        this.setProperty(property, value.stream().map(String::valueOf).collect(Collectors.joining("\n")));
    }

    private void loadProperties() {
        block9: {
            this.properties = new Properties();
            File propertiesFile = new File(this.file);
            if (propertiesFile.exists()) {
                try (BufferedReader reader = Files.newBufferedReader(propertiesFile.toPath());){
                    this.properties.load(reader);
                    break block9;
                }
                catch (IOException e) {
                    throw new PluginException("Can't load RDFRank properties", (Throwable)e);
                }
            }
            this.fillWithDefaultValues();
            this.persistProperties();
        }
    }

    private void fillWithDefaultValues() {
        this.setProperty(RDFRankProperty.LAST_RANKED_ID_PROPERTY, "0");
        this.setProperty(RDFRankProperty.MIN_RANK_PROPERTY, "");
        this.setProperty(RDFRankProperty.MAX_RANK_PROPERTY, "");
        this.setProperty(RDFRankProperty.FILTERING, "false");
        this.setProperty(RDFRankProperty.INCLUDED_PREDICATES_PROPERTY, "");
        this.setProperty(RDFRankProperty.INCLUDED_GRAPHS_PROPERTY, "");
        this.setProperty(RDFRankProperty.EXCLUDED_PREDICATES_PROPERTY, "");
        this.setProperty(RDFRankProperty.EXCLUDED_GRAPHS_PROPERTY, "");
        this.setProperty(RDFRankProperty.INCLUDE_EXPLICIT, "true");
        this.setProperty(RDFRankProperty.INCLUDE_IMPLICIT, "true");
        this.setProperty(RDFRankProperty.COMPUTED_CONFIG_HASH, "0");
    }

    private void persistProperties() {
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(this.file, new String[0]), new OpenOption[0]);){
            this.properties.store(writer, "RDFRank properties");
        }
        catch (IOException e) {
            throw new PluginException("Can't load RDFRank properties", (Throwable)e);
        }
    }

    private String getProperty(RDFRankProperty property) {
        return this.properties.get(property.toString()).toString();
    }

    private void setProperty(RDFRankProperty property, String value) {
        this.properties.setProperty(property.toString(), value);
    }

    public int hashCode() {
        int hash = Objects.hash(this.getIncludedPredicates(), this.getIncludedGraphs(), this.getExcludedPredicates(), this.getExcludedGraphs(), this.getIncludeExplicit(), this.getIncludeImplicit());
        hash = this.getFilteringEnabled() ? hash | 1 : hash & 0xFFFFFFFE;
        return hash;
    }

    public static enum RDFRankProperty {
        LAST_RANKED_ID_PROPERTY("lastRankedID"),
        MIN_RANK_PROPERTY("minRank"),
        MAX_RANK_PROPERTY("maxRank"),
        FILTERING("filtering"),
        INCLUDED_PREDICATES_PROPERTY("includedPredicates"),
        INCLUDED_GRAPHS_PROPERTY("includedGraphs"),
        EXCLUDED_PREDICATES_PROPERTY("excludedPredicates"),
        EXCLUDED_GRAPHS_PROPERTY("excludedGraphs"),
        INCLUDE_EXPLICIT("includeExplicit"),
        INCLUDE_IMPLICIT("includeImplicit"),
        COMPUTED_CONFIG_HASH("computedConfigHash");

        private String name;

        private RDFRankProperty(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

