/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.tasks.processing;

import com.ontotext.soaas.common.concurrent.MonitoredOperationInfo;
import com.ontotext.soaas.common.concurrent.MonitoredService;
import com.ontotext.soaas.common.concurrent.Timer;
import com.ontotext.soaas.common.logging.Loggers;
import com.ontotext.tasks.DataEndpoint;
import com.ontotext.tasks.Task;
import com.ontotext.tasks.processing.JobContext;
import com.ontotext.tasks.processing.RetryingTaskDispatcher;
import com.ontotext.tasks.processing.TaskDispatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MonitoredRetryingTaskDispatcher<T extends Task, E extends DataEndpoint>
extends RetryingTaskDispatcher<T, E>
implements MonitoredService {
    private Map<Thread, MonitoredOperationInfo> statuses = new ConcurrentHashMap<Thread, MonitoredOperationInfo>();

    public MonitoredRetryingTaskDispatcher(TaskDispatcher<T, E> delegate) {
        super(delegate);
    }

    public MonitoredRetryingTaskDispatcher(TaskDispatcher<T, E> delegate, long retryDelay) {
        super(delegate, retryDelay);
    }

    public List<MonitoredOperationInfo> getFullInfo() {
        return new ArrayList<MonitoredOperationInfo>(this.statuses.values());
    }

    public List<MonitoredOperationInfo> getSummaryInfo() {
        return new ArrayList<MonitoredOperationInfo>(this.statuses.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(T task, E dataEndpoint, JobContext jobContext) {
        this.begin(task, jobContext);
        try {
            super.dispatch(task, dataEndpoint, jobContext);
        }
        finally {
            this.end(task, jobContext);
        }
    }

    protected void begin(T task, JobContext jobContext) {
        MonitoredOperationInfo previousValue = this.statuses.put(Thread.currentThread(), new MonitoredOperationInfo(this.resolveOperation(task, jobContext), this.resolveId(task, jobContext), Timer.start(), Integer.valueOf(1), Thread.currentThread().getName()));
        if (previousValue != null) {
            Loggers.tasksLogger().warn("Detected recursive TaskDispatcher.dispatch call. If interested if supporting such monitoring contact the OTP team.");
        }
    }

    protected void end(T task, JobContext jobContext) {
        this.statuses.remove(Thread.currentThread());
    }

    protected String resolveOperation(T task, JobContext jobContext) {
        return task.getClass().getSimpleName();
    }

    protected String resolveId(T task, JobContext jobContext) {
        return task.getName();
    }
}

