/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.tasks.processing;

import com.ontotext.tasks.processing.TaskEvaluator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class AsyncTaskEvaluator
implements TaskEvaluator {
    private ExecutorService executorService;
    private final int maxConcurrentTasks;

    public AsyncTaskEvaluator(int maxConcurrentTasks) {
        this.maxConcurrentTasks = maxConcurrentTasks;
    }

    @Override
    public Future<?> submitTask(Runnable runnable) {
        return this.getExecutorService().submit(runnable);
    }

    public int getMaxConcurrentTasks() {
        return this.maxConcurrentTasks;
    }

    protected ExecutorService getExecutorService() {
        return this.getExecutorService(this.maxConcurrentTasks, this::getThreadFactory);
    }

    protected synchronized ExecutorService getExecutorService(int concurrencyLevel, Supplier<ThreadFactory> factorySupplier) {
        if (this.executorService == null) {
            this.executorService = concurrencyLevel == 1 ? Executors.newSingleThreadExecutor(factorySupplier.get()) : Executors.newFixedThreadPool(concurrencyLevel, factorySupplier.get());
        }
        return this.executorService;
    }

    @NotNull
    protected ThreadFactory getThreadFactory() {
        ThreadFactory factory = Executors.defaultThreadFactory();
        return runnable -> {
            Thread thread = factory.newThread(runnable);
            thread.setName("processing-" + thread.getName());
            thread.setDaemon(true);
            return thread;
        };
    }
}

