/*
 * Decompiled with CFR 0.152.
 */
package com.github.tkurz.media.fragments.base;

import com.github.tkurz.media.fragments.FragmentParser;
import com.github.tkurz.media.fragments.ParseException;
import com.github.tkurz.media.fragments.base.MediaFragment;
import com.github.tkurz.media.fragments.exceptions.MediaFragmentURISyntaxException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;

public class MediaFragmentURI {
    private URI uri;
    private MediaFragment mediaFragment;

    public MediaFragmentURI(String uri_string) throws MediaFragmentURISyntaxException {
        try {
            this.uri = new URI(uri_string);
            if (this.uri.getFragment() != null) {
                FragmentParser p1 = new FragmentParser(new StringReader(this.uri.getFragment()));
                this.mediaFragment = p1.run(MediaFragment.Type.FRAGMENT);
            } else if (this.uri.getQuery() != null) {
                FragmentParser p1 = new FragmentParser(new StringReader(this.uri.getQuery()));
                this.mediaFragment = p1.run(MediaFragment.Type.QUERY);
            } else {
                this.mediaFragment = new MediaFragment();
            }
        }
        catch (ParseException | URISyntaxException e) {
            throw new MediaFragmentURISyntaxException(e);
        }
    }

    public String getScheme() {
        return this.uri.getScheme();
    }

    public String getAuthority() {
        return this.uri.getAuthority();
    }

    public String getPath() {
        return this.uri.getPath();
    }

    public String getAbsolutePath() {
        StringBuilder b = new StringBuilder();
        b.append(this.uri.getScheme());
        b.append("://");
        b.append(this.uri.getAuthority());
        b.append(this.uri.getPath());
        return b.toString();
    }

    public MediaFragment getMediaFragment() {
        return this.mediaFragment;
    }

    public String toString() {
        return this.mediaFragment != null ? this.getAbsolutePath() + this.mediaFragment.toString() : this.getAbsolutePath();
    }

    public MediaFragmentURI toPixel(double width, double height) {
        this.mediaFragment = this.mediaFragment != null ? this.mediaFragment.toPixel(width, height) : null;
        return this;
    }

    public MediaFragmentURI toPercent(double width, double height) {
        this.mediaFragment = this.mediaFragment != null ? this.mediaFragment.toPercent(width, height) : null;
        return this;
    }

    public String stringValue() {
        return this.toString();
    }
}

