/*
 * Decompiled with CFR 0.152.
 */
package com.github.tkurz.media.fragments.base;

import com.github.tkurz.media.fragments.FragmentParser;
import com.github.tkurz.media.fragments.ParseException;
import com.github.tkurz.media.fragments.spatial.SpatialFragment;
import com.github.tkurz.media.fragments.temporal.TemporalFragment;
import com.github.tkurz.media.ontology.impl.Rectangle;
import com.github.tkurz.media.ontology.type.Coordinate;
import com.github.tkurz.media.ontology.type.SpatialEntity;
import com.github.tkurz.media.ontology.type.SpatialTemporalEntity;
import com.github.tkurz.media.ontology.type.Time;
import java.awt.geom.Area;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MediaFragment
implements SpatialTemporalEntity {
    public static final Type DEFAULT_TYPE = Type.FRAGMENT;
    public Type type;
    private String id;
    private String track;
    private TemporalFragment temporalFragment;
    private SpatialFragment spatialFragment;

    public static MediaFragment create(String s) throws ParseException {
        Type _type = DEFAULT_TYPE;
        if (s.startsWith("?")) {
            _type = Type.QUERY;
            s = s.substring(1);
        }
        if (s.startsWith("#")) {
            _type = Type.FRAGMENT;
            s = s.substring(1);
        }
        FragmentParser p1 = new FragmentParser(new StringReader(s));
        return p1.run(_type);
    }

    public MediaFragment() {
        this.type = DEFAULT_TYPE;
    }

    public MediaFragment(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean hasId() {
        return this.id != null;
    }

    public boolean hasTrack() {
        return this.track != null;
    }

    public boolean hasTemporalFragment() {
        return this.temporalFragment != null;
    }

    public boolean hasSpatialFragment() {
        return this.spatialFragment != null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTrack() {
        return this.track;
    }

    public void setTrack(String track) {
        this.track = track;
    }

    public TemporalFragment getTemporalFragment() {
        return this.temporalFragment;
    }

    public void setTemporalFragment(TemporalFragment temporalFragment) {
        this.temporalFragment = temporalFragment;
    }

    public SpatialFragment getSpatialFragment() {
        return this.spatialFragment;
    }

    public void setSpatialFragment(SpatialFragment spatialFragment) {
        this.spatialFragment = spatialFragment;
    }

    public String toString() {
        return this.stringValue();
    }

    @Override
    public Coordinate getCenter() {
        return this.spatialFragment != null ? this.spatialFragment.getCenter() : null;
    }

    @Override
    public Rectangle getBoundingBox() {
        return this.spatialFragment != null ? this.spatialFragment.getBoundingBox() : null;
    }

    @Override
    public Area getArea() {
        return this.spatialFragment != null ? this.spatialFragment.getArea() : null;
    }

    @Override
    public Time getStart() {
        return this.temporalFragment != null ? this.temporalFragment.getStart() : null;
    }

    @Override
    public Time getEnd() {
        return this.temporalFragment != null ? this.temporalFragment.getEnd() : null;
    }

    @Override
    public String stringValue() {
        String separator = this.type.getDelimiter();
        if (this.id != null) {
            return separator + "id=" + this.id;
        }
        ArrayList<String> list = new ArrayList<String>();
        if (this.track != null) {
            list.add("track=" + this.track);
        }
        if (this.temporalFragment != null) {
            list.add(this.temporalFragment.stringValue());
        }
        if (this.spatialFragment != null) {
            list.add(this.spatialFragment.stringValue());
        }
        return this.join(list, separator);
    }

    @Override
    public String stringValue(SpatialEntity.Format format) {
        return this.stringValue();
    }

    private String join(List list, String separator) {
        StringBuilder b = new StringBuilder();
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            b.append(separator);
        }
        while (iterator.hasNext()) {
            b.append(iterator.next());
            if (!iterator.hasNext()) continue;
            b.append("&");
        }
        return b.toString();
    }

    public MediaFragment toPixel(double width, double height) {
        this.spatialFragment = this.spatialFragment != null ? this.spatialFragment.toPixel(width, height) : null;
        return this;
    }

    public MediaFragment toPercent(double width, double height) {
        this.spatialFragment = this.spatialFragment != null ? this.spatialFragment.toPercent(width, height) : null;
        return this;
    }

    public static enum Type {
        FRAGMENT("#"),
        QUERY("?");

        private String delimiter;

        private Type(String delimiter) {
            this.delimiter = delimiter;
        }

        public String getDelimiter() {
            return this.delimiter;
        }
    }
}

