/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.rdfrank.controller;

import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.repository.SemanticRepository;
import com.ontotext.license.License;
import com.ontotext.license.LicenseRegistry;
import com.ontotext.trree.sdk.PluginException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/rest/rdfrank"})
public class RDFRankController {
    public static final String PREFIX = "PREFIX rank: <http://www.ontotext.com/owlim/RDFRank#> ";
    public static final String RANK_COMPUTE_ASK = "PREFIX rank: <http://www.ontotext.com/owlim/RDFRank#>  ASK { _:b1 rank:computeAsync _:b2 . }";
    public static final String RANK_COMPUTE_INSERT = "PREFIX rank: <http://www.ontotext.com/owlim/RDFRank#>  INSERT DATA { _:b1 rank:computeAsync true . }";
    public static final String RANK_COMPUTE_INSERT_CLUSTER = "PREFIX rank: <http://www.ontotext.com/owlim/RDFRank#>  INSERT DATA { _:b1 rank:compute _:b2 . }";
    public static final String RANK_COMPUTE_INCREMENTAL_ASK = "PREFIX rank: <http://www.ontotext.com/owlim/RDFRank#>  ASK { _:b1 rank:computeIncrementalAsync _:b2 . }";
    public static final String RANK_COMPUTE_INCREMENTAL_INSERT = "PREFIX rank: <http://www.ontotext.com/owlim/RDFRank#>  INSERT DATA { _:b1 rank:computeIncrementalAsync true . }";
    public static final String RANK_COMPUTE_INCREMENTAL_INSERT_CLUSTER = "PREFIX rank: <http://www.ontotext.com/owlim/RDFRank#>  INSERT DATA { _:b1 rank:computeIncremental true . }";
    public static final String RANK_COMPUTATION_INTERRUPT_ASK = "PREFIX rank: <http://www.ontotext.com/owlim/RDFRank#>  ASK { _:b1 rank:interrupt _:b2 . }";
    public static final String RANK_COMPUTATION_INTERRUPT_INSERT = "PREFIX rank: <http://www.ontotext.com/owlim/RDFRank#>  INSERT DATA { _:b1 rank:interrupt true . }";
    public static final String SET_PROPERTY_ASK = "PREFIX rank: <http://www.ontotext.com/owlim/RDFRank#>  ASK { rank:%s rank:setParam %s . }";
    public static final String SET_PROPERTY_INSERT = "PREFIX rank: <http://www.ontotext.com/owlim/RDFRank#>  INSERT DATA { rank:%s rank:setParam %s . }";
    public static final String MODIFY_FILTER_LIST_ASK = "PREFIX rank: <http://www.ontotext.com/owlim/RDFRank#>  ASK { <%s> rank:%s \"%s\" . }";
    public static final String MODIFY_FILTER_LIST_INSERT = "PREFIX rank: <http://www.ontotext.com/owlim/RDFRank#>  INSERT DATA { <%s> rank:%s \"%s\" . }";
    public static final String GET_FILTER_LIST = "PREFIX rank: <http://www.ontotext.com/owlim/RDFRank#>  SELECT ?s WHERE { ?s rank:%s ?o . }";
    public static final String GET_INCLUDE_EXPLICIT = "PREFIX rank: <http://www.ontotext.com/owlim/RDFRank#>  ASK { _:b1 rank:includeExplicit _:b2 . }";
    public static final String GET_INCLUDE_IMPLICIT = "PREFIX rank: <http://www.ontotext.com/owlim/RDFRank#>  ASK { _:b1 rank:includeImplicit _:b2 . }";
    public static final String RANK_STATUS = "PREFIX rank: <http://www.ontotext.com/owlim/RDFRank#>  SELECT ?o WHERE { ?s rank:status ?o . }";
    public static final String PLUGIN_PRESENT = "PREFIX rank: <http://www.ontotext.com/owlim/RDFRank#>  ASK { _:b1 rank:present _:b2 . }";
    public static final String FILTERING = "PREFIX rank: <http://www.ontotext.com/owlim/RDFRank#>  ASK { _:b1 rank:filtering _:b2 . }";
    private final Logger LOGGER = LoggerFactory.getLogger(RDFRankController.class);
    @Autowired
    private SemanticDataManagement semanticDataManagement;

    @RequestMapping(value={"compute"}, method={RequestMethod.POST})
    public ResponseEntity<String> compute() {
        return this.getStringResponse(RANK_COMPUTE_ASK, this.semanticDataManagement.isClusterExisting() ? RANK_COMPUTE_INSERT_CLUSTER : RANK_COMPUTE_INSERT, "RDF Ranks will be recomputed...");
    }

    @RequestMapping(value={"compute-incremental"}, method={RequestMethod.POST})
    public ResponseEntity<String> computeIncremental() {
        return this.getStringResponse(RANK_COMPUTE_INCREMENTAL_ASK, this.semanticDataManagement.isClusterExisting() ? RANK_COMPUTE_INCREMENTAL_INSERT_CLUSTER : RANK_COMPUTE_INCREMENTAL_INSERT, "RDF Ranks will be recomputed incrementally...");
    }

    @RequestMapping(value={"interrupt"}, method={RequestMethod.POST})
    public ResponseEntity<String> interrupt() {
        return this.getStringResponse(RANK_COMPUTATION_INTERRUPT_ASK, RANK_COMPUTATION_INTERRUPT_INSERT, "RDF Ranks computation will be interrupted...");
    }

    @RequestMapping(value={"status"}, method={RequestMethod.GET})
    public ResponseEntity<String> status() {
        try {
            return new ResponseEntity((Object)this.getStatus(), (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"plugin-found"}, method={RequestMethod.GET})
    public ResponseEntity<?> pluginEnabled() {
        try {
            return new ResponseEntity((Object)this.evaluateBoolean(PLUGIN_PRESENT), (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"filtering"}, method={RequestMethod.GET})
    public ResponseEntity<Boolean> filteringEnabled() {
        try {
            return new ResponseEntity((Object)this.evaluateBoolean(FILTERING), (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            this.LOGGER.error("Error when retrieving RDFRank filtering status", (Throwable)e);
            return new ResponseEntity((Object)Boolean.FALSE, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"filtering"}, method={RequestMethod.POST})
    public ResponseEntity<String> setFilteringEnabled(@RequestParam(value="enabled") Boolean enabled) {
        return this.getStringResponse(String.format(SET_PROPERTY_ASK, "filtering", enabled.toString()), String.format(SET_PROPERTY_INSERT, "filtering", enabled.toString()), "Filter mode enabled set to " + enabled.toString());
    }

    @RequestMapping(value={"include-explicit"}, method={RequestMethod.GET})
    public ResponseEntity<Boolean> includeExplicit() {
        try {
            return new ResponseEntity((Object)this.evaluateBoolean(GET_INCLUDE_EXPLICIT), (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            this.LOGGER.error("Error when retrieving RDFRank filtering property", (Throwable)e);
            return new ResponseEntity((Object)Boolean.FALSE, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"include-explicit"}, method={RequestMethod.POST})
    public ResponseEntity<String> setIncludeExplicit(@RequestParam(value="enabled") Boolean enabled) {
        return this.getStringResponse(String.format(SET_PROPERTY_ASK, "includeExplicit", enabled.toString()), String.format(SET_PROPERTY_INSERT, "includeExplicit", enabled.toString()), "IncludeExplicit set to " + enabled.toString());
    }

    @RequestMapping(value={"include-implicit"}, method={RequestMethod.GET})
    public ResponseEntity<Boolean> includeImplicit() {
        try {
            return new ResponseEntity((Object)this.evaluateBoolean(GET_INCLUDE_IMPLICIT), (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            this.LOGGER.error("Error when retrieving RDFRank filtering property", (Throwable)e);
            return new ResponseEntity((Object)Boolean.FALSE, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"include-implicit"}, method={RequestMethod.POST})
    public ResponseEntity<String> setIncludeImplicit(@RequestParam(value="enabled") Boolean enabled) {
        return this.getStringResponse(String.format(SET_PROPERTY_ASK, "includeImplicit", enabled.toString()), String.format(SET_PROPERTY_INSERT, "includeImplicit", enabled.toString()), "IncludeImplicit set to " + enabled.toString());
    }

    @RequestMapping(value={"filtering/{list}"}, method={RequestMethod.GET})
    public ResponseEntity<List<String>> filterList(@PathVariable(value="list") String list) {
        return new ResponseEntity(this.getFilterList(list), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"filtering/{list}"}, method={RequestMethod.PUT})
    public ResponseEntity<String> addToFilterList(@PathVariable(value="list") String list, @RequestBody Map<String, Object> body) {
        String iri = body.get("iri").toString();
        try {
            String askQuery = String.format(MODIFY_FILTER_LIST_ASK, new Object[]{iri, FilterList.valueOf(list), "add"});
            String insertQuery = String.format(MODIFY_FILTER_LIST_INSERT, new Object[]{iri, FilterList.valueOf(list), "add"});
            return this.getStringResponse(askQuery, insertQuery, "IRI has been added to list");
        }
        catch (IllegalArgumentException e) {
            throw new PluginException("Invalid arguments", (Throwable)e);
        }
    }

    @RequestMapping(value={"filtering/{list}"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> removeFromFilterList(@PathVariable(value="list") String list, @RequestBody Map<String, Object> body) {
        String iri = body.get("iri").toString();
        try {
            String askQuery = String.format(MODIFY_FILTER_LIST_ASK, new Object[]{iri, FilterList.valueOf(list), "remove"});
            String insertQuery = String.format(MODIFY_FILTER_LIST_INSERT, new Object[]{iri, FilterList.valueOf(list), "remove"});
            return this.getStringResponse(askQuery, insertQuery, "IRI has been deleted from list");
        }
        catch (IllegalArgumentException e) {
            throw new PluginException("Invalid arguments", (Throwable)e);
        }
    }

    public List<String> getFilterList(final @PathVariable(value="list") String list) {
        SemanticRepository semanticRepository = this.semanticDataManagement.getCurrentRepositoryOrThrow();
        Objects.requireNonNull(semanticRepository);
        return (List)new SemanticRepository.WithConnection<List<String>>(this, semanticRepository){

            protected List<String> doInConnection() throws RepositoryException {
                try {
                    ArrayList<String> values = new ArrayList<String>();
                    TupleQueryResult result = this.prepareAndEvaluate(String.format(RDFRankController.GET_FILTER_LIST, list));
                    while (result.hasNext()) {
                        BindingSet next = (BindingSet)result.next();
                        values.add(next.getBinding("s").getValue().stringValue());
                    }
                    return values;
                }
                catch (MalformedQueryException | QueryEvaluationException e) {
                    throw new RepositoryException(e);
                }
            }
        }.run();
    }

    private ResponseEntity<String> getStringResponse(String queryAsk, String queryInsert, String successMessage) {
        try {
            if (this.useAskControl()) {
                this.evaluateBoolean(queryAsk);
            } else {
                this.executeUpdate(queryInsert);
            }
        }
        catch (Exception e) {
            this.LOGGER.error("Error when executing RDFRank query", (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)successMessage, (HttpStatusCode)HttpStatus.OK);
    }

    private boolean useAskControl() {
        return LicenseRegistry.getInstance().getProduct() != License.Product.GRAPHDB_ENTERPRISE;
    }

    private String getStatus() {
        return (String)new SemanticRepository.WithConnection<String>(this, this.semanticDataManagement.getCurrentRepositoryOrThrow()){

            protected String doInConnection() throws RepositoryException {
                try {
                    TupleQueryResult result = this.prepareAndEvaluate(RDFRankController.RANK_STATUS);
                    if (result.hasNext()) {
                        BindingSet next = (BindingSet)result.next();
                        return next.getBinding("o").getValue().stringValue();
                    }
                    return null;
                }
                catch (MalformedQueryException | QueryEvaluationException e) {
                    throw new RepositoryException(e);
                }
            }
        }.run();
    }

    private boolean evaluateBoolean(final String query) {
        SemanticRepository semanticRepository = this.semanticDataManagement.getCurrentRepositoryOrThrow();
        Objects.requireNonNull(semanticRepository);
        return (Boolean)new SemanticRepository.WithConnection<Boolean>(this, semanticRepository){

            protected Boolean doInConnection() throws RepositoryException {
                try {
                    return this.prepareAndEvaluateBoolean(query);
                }
                catch (MalformedQueryException | QueryEvaluationException e) {
                    throw new RepositoryException(e);
                }
            }
        }.run();
    }

    private void executeUpdate(final String query) throws GraphDBWorkbenchException {
        SemanticRepository semanticRepository = this.semanticDataManagement.getCurrentRepositoryOrThrow();
        Objects.requireNonNull(semanticRepository);
        new SemanticRepository.WithConnection(this, semanticRepository){

            protected Void doInConnection() throws RepositoryException {
                try {
                    this.prepareAndExecuteUpdate(query);
                }
                catch (MalformedQueryException | UpdateExecutionException e) {
                    throw new RepositoryException(e);
                }
                return null;
            }
        }.run();
    }

    private static enum FilterList {
        includedPredicates,
        includedGraphs,
        excludedPredicates,
        excludedGraphs;

    }
}

