/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.concurrency;

import java.util.concurrent.DelayQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.util.concurrency.BoundedTaskExecutor;
import org.jetbrains.kotlin.com.intellij.util.concurrency.SchedulingWrapper;

final class AppDelayQueue
extends DelayQueue<SchedulingWrapper.MyScheduledFutureTask<?>> {
    private static final Logger LOG = Logger.getInstance(AppDelayQueue.class);
    private final Thread scheduledToPooledTransferrer;
    private final AtomicBoolean shutdown = new AtomicBoolean();

    AppDelayQueue() {
        this.scheduledToPooledTransferrer = new Thread(() -> {
            while (!this.shutdown.get()) {
                try {
                    SchedulingWrapper.MyScheduledFutureTask task = (SchedulingWrapper.MyScheduledFutureTask)this.take();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Took " + BoundedTaskExecutor.info(task));
                    }
                    if (task.isDone()) continue;
                    try {
                        task.executeMeInBackendExecutor();
                    }
                    catch (Throwable e) {
                        try {
                            LOG.error("Error executing " + task, e);
                        }
                        catch (Throwable throwable) {
                        }
                    }
                }
                catch (InterruptedException e) {
                    if (this.shutdown.get()) continue;
                    LOG.error(e);
                }
            }
            LOG.debug("scheduledToPooledTransferrer Stopped");
        }, "Periodic tasks thread");
        this.scheduledToPooledTransferrer.setDaemon(true);
        this.scheduledToPooledTransferrer.start();
    }
}

