/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.ontop;

import com.ontotext.graphdb.Config;
import it.unibz.inf.ontop.injection.OntopSQLOWLAPIConfiguration;
import it.unibz.inf.ontop.injection.OntopSystemConfiguration;
import it.unibz.inf.ontop.rdf4j.repository.OntopRepository;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Configurations;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.model.vocabulary.CONFIG;
import org.eclipse.rdf4j.repository.config.AbstractRepositoryImplConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigSchema;

public class GraphDBOntopRepositoryConfig
extends AbstractRepositoryImplConfig {
    public static final String NAMESPACE = "http://inf.unibz.it/krdb/obda/quest#";
    public static final IRI OWLFILE;
    public static final IRI OBDAFILE;
    public static final IRI PROPERTIESFILE;
    public static final IRI CONSTRAINTFILE;
    public static final IRI DBMETADATAFILE;
    public static final IRI LENSESFILE;
    public static final IRI EXISTENTIAL;
    private String name;
    private Optional<File> owlFile;
    private File obdaFile;
    private File propertiesFile;
    private Optional<File> dbMetadataFile;
    private Optional<File> constraintFile;
    private Optional<File> lensesFile;
    private OntopRepository repository = null;

    public GraphDBOntopRepositoryConfig() {
        super("graphdb:OntopRepository");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void validate() throws RepositoryConfigException {
        this.buildRepository();
    }

    private void validateFields() throws RepositoryConfigException {
        try {
            File file;
            if (this.owlFile.filter(f -> !f.exists()).isPresent()) {
                throw new RepositoryConfigException(String.format("The OWL file %s does not exist!", this.owlFile.get().getAbsolutePath()));
            }
            if (this.owlFile.filter(f -> !f.canRead()).isPresent()) {
                throw new RepositoryConfigException(String.format("The OWL file %s is not accessible!", this.owlFile.get().getAbsolutePath()));
            }
            if (this.obdaFile == null) {
                throw new RepositoryConfigException(String.format("No mapping file specified for repository creation ", new Object[0]));
            }
            if (!this.obdaFile.exists()) {
                throw new RepositoryConfigException(String.format("The mapping file %s does not exist!", this.obdaFile.getAbsolutePath()));
            }
            if (!this.obdaFile.canRead()) {
                throw new RepositoryConfigException(String.format("The mapping file %s is not accessible!", this.obdaFile.getAbsolutePath()));
            }
            if (this.propertiesFile == null) {
                throw new RepositoryConfigException(String.format("No properties file specified for repository creation ", new Object[0]));
            }
            if (!this.propertiesFile.exists()) {
                throw new RepositoryConfigException(String.format("The properties file %s does not exist!", this.propertiesFile.getAbsolutePath()));
            }
            if (!this.propertiesFile.canRead()) {
                throw new RepositoryConfigException(String.format("The properties file %s is not accessible!", this.propertiesFile.getAbsolutePath()));
            }
            if (this.constraintFile.isPresent()) {
                file = this.constraintFile.get();
                if (!file.exists()) {
                    throw new RepositoryConfigException(String.format("The implicit key file %s does not exist!", file.getAbsolutePath()));
                }
                if (!file.canRead()) {
                    throw new RepositoryConfigException(String.format("The implicit key file %s is not accessible!", file.getAbsolutePath()));
                }
            }
            if (this.dbMetadataFile.isPresent()) {
                file = this.dbMetadataFile.get();
                if (!file.exists()) {
                    throw new RepositoryConfigException(String.format("The db-metadata file %s does not exist!", file.getAbsolutePath()));
                }
                if (!file.canRead()) {
                    throw new RepositoryConfigException(String.format("The db-metadata file %s is not accessible!", file.getAbsolutePath()));
                }
            }
            if (this.lensesFile.isPresent()) {
                file = this.lensesFile.get();
                if (!file.exists()) {
                    throw new RepositoryConfigException(String.format("The lenses file %s does not exist!", file.getAbsolutePath()));
                }
                if (!file.canRead()) {
                    throw new RepositoryConfigException(String.format("The lenses file %s is not accessible!", file.getAbsolutePath()));
                }
            }
        }
        catch (SecurityException e) {
            throw new RepositoryConfigException(e.getMessage());
        }
    }

    public OntopRepository buildRepository() throws RepositoryConfigException {
        if (this.repository != null) {
            return this.repository;
        }
        this.validateFields();
        try {
            OntopSQLOWLAPIConfiguration.Builder configurationBuilder = OntopSQLOWLAPIConfiguration.defaultBuilder();
            if (!this.obdaFile.getName().endsWith(".obda")) {
                configurationBuilder.r2rmlMappingFile(this.obdaFile);
            } else {
                configurationBuilder.nativeOntopMappingFile(this.obdaFile);
            }
            this.owlFile.ifPresent(arg_0 -> ((OntopSQLOWLAPIConfiguration.Builder)configurationBuilder).ontologyFile(arg_0));
            configurationBuilder.propertyFile(this.propertiesFile);
            this.constraintFile.ifPresent(arg_0 -> ((OntopSQLOWLAPIConfiguration.Builder)configurationBuilder).basicImplicitConstraintFile(arg_0));
            this.dbMetadataFile.ifPresent(arg_0 -> ((OntopSQLOWLAPIConfiguration.Builder)configurationBuilder).dbMetadataFile(arg_0));
            this.lensesFile.ifPresent(arg_0 -> ((OntopSQLOWLAPIConfiguration.Builder)configurationBuilder).lensesFile(arg_0));
            this.repository = OntopRepository.defaultRepository((OntopSystemConfiguration)configurationBuilder.build());
        }
        catch (Exception e) {
            throw new RepositoryConfigException("Could not create RDF4J repository: " + e.getMessage());
        }
        return this.repository;
    }

    public Resource export(Model graph) {
        Resource implNode = super.export(graph);
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        if (this.owlFile != null) {
            this.owlFile.map(File::getAbsolutePath).ifPresent(arg_0 -> GraphDBOntopRepositoryConfig.lambda$export$2(graph, implNode, (ValueFactory)vf, arg_0));
        }
        if (this.obdaFile != null) {
            graph.add(implNode, OBDAFILE, (Value)vf.createLiteral(this.obdaFile.getAbsolutePath()), new Resource[0]);
        }
        if (this.propertiesFile != null) {
            graph.add(implNode, PROPERTIESFILE, (Value)vf.createLiteral(this.propertiesFile.getAbsolutePath()), new Resource[0]);
        }
        if (this.constraintFile != null) {
            this.constraintFile.map(File::getAbsolutePath).ifPresent(arg_0 -> GraphDBOntopRepositoryConfig.lambda$export$3(graph, implNode, (ValueFactory)vf, arg_0));
        }
        if (this.dbMetadataFile != null) {
            this.dbMetadataFile.map(File::getAbsolutePath).ifPresent(arg_0 -> GraphDBOntopRepositoryConfig.lambda$export$4(graph, implNode, (ValueFactory)vf, arg_0));
        }
        if (this.lensesFile != null) {
            this.lensesFile.map(File::getAbsolutePath).ifPresent(arg_0 -> GraphDBOntopRepositoryConfig.lambda$export$5(graph, implNode, (ValueFactory)vf, arg_0));
        }
        return implNode;
    }

    public void parse(Model graph, Resource implNode) throws RepositoryConfigException {
        LinkedHashModel newGraph = new LinkedHashModel(graph);
        File directory = Configurations.getLiteralValue((Model)graph, null, (IRI)CONFIG.Rep.id, (IRI)RepositoryConfigSchema.REPOSITORYID).map(literal -> new File(Config.getDataDirectory() + "/repositories/" + literal.stringValue())).orElseThrow(() -> new RepositoryConfigException("Repository directory cannot be determined"));
        this.resolveFile((Model)newGraph, implNode, OWLFILE, directory);
        this.resolveFile((Model)newGraph, implNode, OBDAFILE, directory);
        this.resolveFile((Model)newGraph, implNode, PROPERTIESFILE, directory);
        this.resolveFile((Model)newGraph, implNode, CONSTRAINTFILE, directory);
        this.resolveFile((Model)newGraph, implNode, DBMETADATAFILE, directory);
        this.resolveFile((Model)newGraph, implNode, LENSESFILE, directory);
        super.parse((Model)newGraph, implNode);
        try {
            Configurations.getLiteralValue((Model)newGraph, null, (IRI)CONFIG.Rep.id, (IRI)RepositoryConfigSchema.REPOSITORYID).ifPresent(lit -> this.setName(lit.getLabel()));
            Configurations.getLiteralValue((Model)newGraph, (Resource)implNode, (IRI)CONFIG.Rep.type, (IRI)RepositoryConfigSchema.REPOSITORYTYPE).ifPresent(lit -> this.setType(lit.getLabel()));
            this.owlFile = Models.objectLiteral((Model)newGraph.filter(implNode, OWLFILE, null, new Resource[0])).filter(l -> !l.getLabel().isEmpty()).map(l -> new File(l.getLabel()));
            Models.objectLiteral((Model)newGraph.filter(implNode, OBDAFILE, null, new Resource[0])).ifPresent(lit -> {
                this.obdaFile = new File(lit.getLabel());
            });
            Models.objectLiteral((Model)newGraph.filter(implNode, PROPERTIESFILE, null, new Resource[0])).ifPresent(lit -> {
                this.propertiesFile = new File(lit.getLabel());
            });
            this.constraintFile = Models.objectLiteral((Model)newGraph.filter(implNode, CONSTRAINTFILE, null, new Resource[0])).filter(l -> !l.getLabel().isEmpty()).map(l -> new File(l.getLabel()));
            this.dbMetadataFile = Models.objectLiteral((Model)newGraph.filter(implNode, DBMETADATAFILE, null, new Resource[0])).filter(l -> !l.getLabel().isEmpty()).map(l -> new File(l.getLabel()));
            this.lensesFile = Models.objectLiteral((Model)newGraph.filter(implNode, LENSESFILE, null, new Resource[0])).filter(l -> !l.getLabel().isEmpty()).map(l -> new File(l.getLabel()));
        }
        catch (Exception e) {
            throw new RepositoryConfigException(e.getMessage(), (Throwable)e);
        }
    }

    private void resolveFile(Model graph, Resource implNode, IRI fileIri, File configPath) {
        LinkedHashModel newStatements = new LinkedHashModel();
        Iterator iterator = graph.filter(implNode, fileIri, null, new Resource[0]).iterator();
        while (iterator.hasNext()) {
            Statement s = (Statement)iterator.next();
            iterator.remove();
            if (StringUtils.isEmpty((CharSequence)s.getObject().stringValue())) continue;
            File file = new File(s.getObject().stringValue());
            if (!file.isAbsolute()) {
                file = new File(configPath, file.getPath());
            }
            newStatements.add(s.getSubject(), s.getPredicate(), (Value)SimpleValueFactory.getInstance().createLiteral(file.getAbsolutePath()), new Resource[0]);
        }
        graph.addAll((Collection)newStatements);
    }

    private static /* synthetic */ void lambda$export$5(Model graph, Resource implNode, ValueFactory vf, String path) {
        graph.add(implNode, LENSESFILE, (Value)vf.createLiteral(path), new Resource[0]);
    }

    private static /* synthetic */ void lambda$export$4(Model graph, Resource implNode, ValueFactory vf, String path) {
        graph.add(implNode, DBMETADATAFILE, (Value)vf.createLiteral(path), new Resource[0]);
    }

    private static /* synthetic */ void lambda$export$3(Model graph, Resource implNode, ValueFactory vf, String path) {
        graph.add(implNode, CONSTRAINTFILE, (Value)vf.createLiteral(path), new Resource[0]);
    }

    private static /* synthetic */ void lambda$export$2(Model graph, Resource implNode, ValueFactory vf, String path) {
        graph.add(implNode, OWLFILE, (Value)vf.createLiteral(path), new Resource[0]);
    }

    static {
        SimpleValueFactory factory = SimpleValueFactory.getInstance();
        OWLFILE = factory.createIRI(NAMESPACE, "owlFile");
        OBDAFILE = factory.createIRI(NAMESPACE, "obdaFile");
        PROPERTIESFILE = factory.createIRI(NAMESPACE, "propertiesFile");
        CONSTRAINTFILE = factory.createIRI(NAMESPACE, "constraintFile");
        DBMETADATAFILE = factory.createIRI(NAMESPACE, "dbMetadataFile");
        LENSESFILE = factory.createIRI(NAMESPACE, "lensesFile");
        EXISTENTIAL = factory.createIRI(NAMESPACE, "existential");
    }
}

