/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.ontop;

import com.ontotext.graphdb.Config;
import it.unibz.inf.ontop.injection.OntopSQLCredentialSettings;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphDBJDBCDriverUtil {
    private static final String JDBC_JAR_PATH_PROPERTY = "graphdb.ontop.jdbc.path";
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphDBJDBCDriverUtil.class);
    private static final AtomicBoolean methodReplaced = new AtomicBoolean();
    private static URLClassLoader classLoader;

    static void init() {
        try {
            if (methodReplaced.compareAndSet(false, true)) {
                TypeDescription commandBaseCreateConnnection = TypePool.Default.ofSystemLoader().describe("it.unibz.inf.ontop.utils.LocalJDBCConnectionUtils").resolve();
                new ByteBuddy().redefine(commandBaseCreateConnnection, ClassFileLocator.ForClassLoader.ofSystemLoader()).method((ElementMatcher)ElementMatchers.named((String)"createConnection")).intercept((Implementation)MethodDelegation.to(GraphDBJDBCDriverUtil.class)).make().load(ClassLoader.getSystemClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION);
                TypeDescription commandBaseGenerateProperties = TypePool.Default.ofSystemLoader().describe("it.unibz.inf.ontop.injection.impl.OntopSQLOWLAPIConfigurationImpl$BuilderImpl").resolve();
                new ByteBuddy().redefine(commandBaseGenerateProperties, ClassFileLocator.ForClassLoader.ofSystemLoader()).method((ElementMatcher)ElementMatchers.named((String)"generateProperties")).intercept((Implementation)MethodDelegation.to(GraphDBJDBCDriverUtil.class)).make().load(ClassLoader.getSystemClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION);
            }
        }
        catch (IllegalStateException e) {
            LOGGER.error(e.getMessage());
        }
    }

    private static synchronized ClassLoader getClassLoader() throws IOException {
        block10: {
            Path distPath = Paths.get(Config.getDistDirectory(), new String[0]);
            Path lib = distPath.resolve(Config.getProperty((String)JDBC_JAR_PATH_PROPERTY, (String)"lib/jdbc"));
            try (Stream<URL> jarStream = GraphDBJDBCDriverUtil.listJars(lib);){
                Object[] urls = (URL[])jarStream.toArray(URL[]::new);
                if (urls.length == 0) {
                    LOGGER.info("Found no jars in JDBC path {}, using system class path", (Object)lib);
                    classLoader = null;
                    break block10;
                }
                if (classLoader != null && Arrays.equals(classLoader.getURLs(), urls)) break block10;
                LOGGER.info("Found {} jars in JDBC path {}", (Object)urls.length, (Object)lib);
                if (classLoader != null) {
                    try {
                        classLoader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                classLoader = new URLClassLoader((URL[])urls);
            }
        }
        return classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
    }

    @NotNull
    public static Stream<URL> listJars(Path lib) throws IOException {
        if (!Files.isDirectory(lib, new LinkOption[0])) {
            return Stream.empty();
        }
        return Files.list(lib).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.getFileName().toString().toLowerCase(Locale.ROOT).endsWith(".jar")).map(p -> {
            try {
                return p.toUri().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static Connection createConnection(OntopSQLCredentialSettings settings) throws SQLException {
        return GraphDBJDBCDriverUtil.createConnection(settings.getJdbcDriver(), settings.getJdbcUrl(), settings.getJdbcUser(), settings.getJdbcPassword());
    }

    public static Connection createConnection(String driverClass, String url, Optional<String> user, Optional<String> password) throws SQLException {
        try {
            Driver driver = (Driver)Class.forName(driverClass, true, GraphDBJDBCDriverUtil.getClassLoader()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Properties info = new Properties();
            user.ifPresent(s -> info.put("user", s));
            password.ifPresent(s -> info.put("password", s));
            return driver.connect(url, info);
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new SQLException("Cannot load JDBC driver: " + driverClass, e);
        }
    }

    public static Properties generateProperties(@SuperCall Callable<Properties> superCall) {
        try {
            Properties p = superCall.call();
            GraphDBJDBCDriverUtil.mappingGraphDBToOntopProperties(p);
            p.put("it.unibz.inf.ontop.answering.connection.pool.JDBCConnectionPool", "it.unibz.inf.ontop.answering.connection.pool.impl.DummyJDBCConnectionPool");
            p.put("it.unibz.inf.ontop.answering.logging.QueryLogger", "com.ontotext.graphdb.ontop.GraphDBOntopQueryLoggerImpl");
            return p;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not change the JDBC properties as required", e);
        }
    }

    private static void mappingGraphDBToOntopProperties(Properties p) {
        Map configProperties = Config.getProperties();
        for (Map.Entry entry : configProperties.entrySet()) {
            if (!((String)entry.getKey()).contains("ontop")) continue;
            String ontopProperty = StringUtils.removeStart((String)((String)entry.getKey()), (String)"graphdb.");
            p.put(ontopProperty, entry.getValue());
        }
    }
}

