/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.Internal;
import graphql.language.FragmentDefinition;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;
import java.util.LinkedHashSet;
import java.util.Set;

@Internal
public class UniqueFragmentNames
extends AbstractRule {
    private Set<String> fragmentNames = new LinkedHashSet<String>();

    public UniqueFragmentNames(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkFragmentDefinition(FragmentDefinition fragmentDefinition) {
        String name = fragmentDefinition.getName();
        if (name == null) {
            return;
        }
        if (this.fragmentNames.contains(name)) {
            String message = this.i18n(ValidationErrorType.DuplicateFragmentName, "UniqueFragmentNames.oneFragment", name);
            this.addError(ValidationErrorType.DuplicateFragmentName, fragmentDefinition.getSourceLocation(), message);
        } else {
            this.fragmentNames.add(name);
        }
    }
}

