/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.metamodel.storage.memory;

import com.ontotext.metamodel.storage.ImmediateSchemaNotificationService;
import com.ontotext.metamodel.storage.SchemaBindingChanged;
import com.ontotext.metamodel.storage.SchemaEntity;
import com.ontotext.metamodel.storage.SchemaIdMismatchException;
import com.ontotext.metamodel.storage.SchemaNotificationService;
import com.ontotext.metamodel.storage.SomlAlreadyExistsException;
import com.ontotext.metamodel.storage.SomlIdManager;
import com.ontotext.metamodel.storage.SomlNotFoundException;
import com.ontotext.metamodel.storage.SomlSchemaStorage;
import com.ontotext.metamodel.storage.SomlSchemaStorageUpdate;
import com.ontotext.metamodel.storage.SomlStoreException;
import com.ontotext.metamodel.storage.UnreachableStoreException;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.SomlSchemaParser;
import com.ontotext.soaas.common.HealthResult;
import com.ontotext.soaas.common.Resettable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class InMemorySomlSchemaStorage
implements SomlSchemaStorage,
Resettable {
    private final AtomicInteger index = new AtomicInteger();
    private Map<String, SchemaEntity> schemas = new ConcurrentHashMap<String, SchemaEntity>();
    private SomlSchemaParser somlSchemaParser = new SomlSchemaParser();
    private SomlIdManager idManager = SomlIdManager.INSTANCE;
    private Queue<String> somlServiceAddresses = new ConcurrentLinkedDeque<String>();
    private SchemaNotificationService notificationService = new ImmediateSchemaNotificationService();
    private SomlSchemaStorage.SchemaExistsStrategy existsStrategy;

    @Override
    public String store(SchemaEntity entity) throws SomlStoreException {
        String schema = entity.getOriginalDefinition();
        String id = SomlSchemaParser.getId((String)schema);
        if (id == null) {
            id = this.idManager.referenceToSomlId("" + this.index.incrementAndGet());
            schema = SomlSchemaParser.setId((String)id, (String)schema);
        } else if (this.contains(id)) {
            this.getExistsStrategy().existsOnStore(entity);
            this.update(id, entity);
            return id;
        }
        this.schemas.put(id, InMemorySomlSchemaStorage.createEntity(schema, entity.getActive()));
        this.fireUpdateEvent(schema, SomlSchemaStorageUpdate.Type.INSERT);
        return id;
    }

    @NotNull
    private static SchemaEntity createEntity(String schema, Boolean active) {
        SchemaEntity entity = new SchemaEntity(schema);
        if (active != null) {
            entity.setActive(active);
        }
        return entity;
    }

    private void fireUpdateEvent(String soml, SomlSchemaStorageUpdate.Type operation) {
        this.notificationService.notifyListeners(new SomlSchemaStorageUpdate(SomlSchemaParser.getId((String)soml), soml, operation));
    }

    private void fireDeleteEvent(String id) {
        this.notificationService.notifyListeners(new SomlSchemaStorageUpdate(id, null, SomlSchemaStorageUpdate.Type.DELETE));
    }

    @Override
    public String update(String id, SchemaEntity entity) throws SomlStoreException {
        if (!this.contains(id)) {
            this.getExistsStrategy().notExistsOnUpdate(id, entity);
            this.store(entity);
            return entity.getOriginalDefinition();
        }
        String schema = entity.getOriginalDefinition();
        String existingId = SomlSchemaParser.getId((String)schema);
        if (existingId == null) {
            schema = SomlSchemaParser.setId((String)id, (String)schema);
            entity.setSchemaId(SomlSchemaParser.getId((String)schema));
        } else if (!existingId.equals(id)) {
            if ("/soml/soml-rbac".equals(id)) {
                throw new SchemaIdMismatchException(String.format("Mismatch between url-id '%s' and in-schema id '%s'", id, existingId));
            }
            if (this.contains(existingId)) {
                throw new SomlAlreadyExistsException("Cannot update schema with id '" + id + "' because the new schemaId '" + existingId + "' already exists in another schema. Schema IDs must be unique.");
            }
        }
        this.fireUpdateEvent(schema, SomlSchemaStorageUpdate.Type.UPDATE);
        this.schemas.put(entity.getSchemaId(), InMemorySomlSchemaStorage.createEntity(schema, entity.getActive()));
        return schema;
    }

    @Override
    public Optional<SomlSchema> getParsed(String id) {
        return this.get(id).map(arg_0 -> ((SomlSchemaParser)this.somlSchemaParser).parse(arg_0));
    }

    @Override
    public Collection<SchemaEntity> getAll(int skip, int limit, Date modifiedAfter, boolean includeDeleted, boolean includeInactive) {
        LinkedList<SchemaEntity> subset = new LinkedList<SchemaEntity>();
        int idx = 0;
        for (SchemaEntity entity : this.schemas.values()) {
            if (limit > 0 && subset.size() >= limit) break;
            if (!includeInactive && !Boolean.TRUE.equals(entity.getActive()) || idx++ < skip) continue;
            subset.add(InMemorySomlSchemaStorage.createEntity(entity.getOriginalDefinition(), entity.getActive()));
        }
        return subset;
    }

    @Override
    public Optional<String> get(String id) {
        return Optional.ofNullable(this.schemas.get(id)).map(SchemaEntity::getOriginalDefinition);
    }

    @Override
    public Optional<SchemaEntity> getEntity(String id) {
        SchemaEntity storedEntity = this.schemas.get(id);
        if (storedEntity == null) {
            return Optional.empty();
        }
        return Optional.of(InMemorySomlSchemaStorage.createEntity(storedEntity.getOriginalDefinition(), storedEntity.getActive()));
    }

    @Override
    public boolean remove(String id) {
        boolean result;
        boolean bl = result = this.schemas.remove(id) != null;
        if (result) {
            this.fireDeleteEvent(id);
        }
        return result;
    }

    @Override
    public boolean delete(String id) throws UnreachableStoreException {
        return this.remove(id);
    }

    @Override
    public long clear() {
        HashSet<String> keys = new HashSet<String>(this.schemas.keySet());
        keys.forEach(this::remove);
        this.schemas.clear();
        return keys.size();
    }

    @Override
    public int size() {
        return this.schemas.size();
    }

    @Override
    public void registerBindListener(Consumer<SchemaBindingChanged> consumer) {
        this.notificationService.registerBindListener(consumer);
    }

    @Override
    public void registerListener(Consumer<SomlSchemaStorageUpdate> consumer) {
        this.notificationService.registerListener(consumer);
    }

    @Override
    public void unregisterBindListener(Consumer<SchemaBindingChanged> consumer) {
        this.notificationService.unregisterBindListener(consumer);
    }

    @Override
    public void unregisterListener(Consumer<SomlSchemaStorageUpdate> consumer) {
        this.notificationService.unregisterListener(consumer);
    }

    public void reset() {
        this.index.set(0);
        this.schemas.clear();
        this.somlServiceAddresses.clear();
    }

    @Override
    public void registerSchemaService(String id, String serviceHostname) {
        this.somlServiceAddresses.add(serviceHostname);
        this.fireUpdateEvent(null, SomlSchemaStorageUpdate.Type.ADD_SERVICE);
    }

    @Override
    public void deregisterSchemaService(String id, String serviceHostname) {
        this.somlServiceAddresses.remove(serviceHostname);
        this.fireUpdateEvent(null, SomlSchemaStorageUpdate.Type.REMOVE_SERVICE);
    }

    @Override
    public List<String> getRegisteredSchemaServices(String id) throws SomlNotFoundException {
        if (!this.contains(id)) {
            throw new SomlNotFoundException("SOML schema is not present in the store: " + id);
        }
        return new LinkedList<String>(new LinkedHashSet<String>(this.somlServiceAddresses));
    }

    @Override
    public void setSchemaExistsStrategy(SomlSchemaStorage.SchemaExistsStrategy existsStrategy) {
        this.existsStrategy = existsStrategy;
    }

    @Override
    public SomlSchemaStorage.SchemaExistsStrategy getSchemaExistsStrategy() {
        return this.existsStrategy;
    }

    @Override
    public boolean contains(String id) {
        return this.schemas.containsKey(id);
    }

    private SomlSchemaStorage.SchemaExistsStrategy getExistsStrategy() {
        if (this.existsStrategy == null) {
            this.existsStrategy = new SomlSchemaStorage.DefaultSchemaExistsStrategy();
        }
        return this.existsStrategy;
    }

    public HealthResult runHealthCheck() {
        if (this.schemas.size() > 1000) {
            return new HealthResult("in-memory", HealthResult.Status.YELLOW, "Stored schemas " + this.schemas.size() + " exceed 1000, ");
        }
        return new HealthResult("in-memory", HealthResult.Status.GREEN);
    }

    @Override
    public void close() {
        this.clear();
    }
}

