/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.metamodel.storage.filesystem;

import com.ontotext.metamodel.ConfigurationException;
import com.ontotext.metamodel.storage.ConfigurationManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesFileConfigurationManager
implements ConfigurationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Map<String, ConfigurationManager> INSTANCES = new ConcurrentHashMap<String, ConfigurationManager>();
    private final String storageLocation;

    public static ConfigurationManager instance(String path) {
        Objects.requireNonNull(path, "Configuration path is required!");
        return INSTANCES.computeIfAbsent(PropertiesFileConfigurationManager.buildConfigPath(path), PropertiesFileConfigurationManager::new);
    }

    private static String buildConfigPath(String storageLocation) {
        if (storageLocation.endsWith(".properties")) {
            return storageLocation;
        }
        Object location = storageLocation;
        if (!storageLocation.endsWith("/") && !storageLocation.endsWith("\\")) {
            location = (String)location + File.separatorChar;
        }
        return (String)location + "config.properties";
    }

    private PropertiesFileConfigurationManager(String storageLocation) {
        this.storageLocation = storageLocation;
    }

    @Override
    public String get(String key) {
        return this.getProperties().getProperty(key);
    }

    @Override
    public synchronized void set(String key, String value) {
        Properties properties = this.getProperties();
        if (value == null) {
            properties.remove(key);
        } else {
            properties.put(key, value);
        }
        this.saveProperties(properties);
    }

    @Override
    public Set<String> keys() {
        return this.getProperties().keySet().stream().map(Object::toString).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public synchronized void setAll(Map<String, String> configurations) {
        Properties properties = this.getProperties();
        properties.putAll(configurations);
        this.saveProperties(properties);
    }

    private Properties getProperties() {
        File configFile = this.getConfigFile();
        Properties properties = new Properties();
        try (FileInputStream stream = new FileInputStream(configFile);){
            properties.load(stream);
        }
        catch (IOException ioe) {
            throw new ConfigurationException("Could not read configuration file: " + configFile.getPath(), ioe);
        }
        return properties;
    }

    private File getConfigFile() {
        File configFile = new File(this.storageLocation);
        File parentDirectory = configFile.getParentFile();
        if (!parentDirectory.exists() && !parentDirectory.mkdirs()) {
            throw new IllegalArgumentException("Cannot create store location at: " + this.storageLocation);
        }
        if (!configFile.exists()) {
            try {
                if (configFile.createNewFile()) {
                    LOGGER.info("Created configuration file: {}", (Object)configFile.getPath());
                }
            }
            catch (IOException ioe) {
                throw new ConfigurationException("Could not create configuration file: " + configFile.getPath(), ioe);
            }
        }
        return configFile;
    }

    private void saveProperties(Properties properties) {
        File configFile = this.getConfigFile();
        try (FileOutputStream outputStream = new FileOutputStream(configFile);){
            properties.store(outputStream, "");
        }
        catch (IOException ioe) {
            throw new ConfigurationException("Could not write configuration file: " + configFile.getPath(), ioe);
        }
    }
}

