/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.metamodel.storage;

import com.ontotext.metamodel.storage.SchemaEntity;
import com.ontotext.metamodel.storage.SomlSchemaStorage;
import com.ontotext.metamodel.storage.SomlStoreException;
import com.ontotext.metamodel.storage.UnreachableStoreException;
import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.soaas.common.ObjectsUtil;
import com.ontotext.soaas.common.exceptions.PlatformConfigurationException;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SomlSchemaStorageMigration
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int DEFAULT_PAGE = 50;
    private static final int MIN_DELAY = 100;
    private static final long DEFAULT_DELAY = 10000L;
    private static final int MAX_DELAY = 30000;
    private static final int MIN_RETRIES = 1;
    private static final int DEFAULT_RETRIES = 3;
    private static final int MAX_RETRIES = 50;
    private final SomlSchemaStorage source;
    private final SomlSchemaStorage destination;
    private final boolean cleanBeforeMigration;
    private final boolean forceStoreUpdate;
    private final boolean cleanOnComplete;
    private final int retries;
    private final long delay;
    private SomlSchemaStorage.SchemaExistsStrategy destinationExistsStrategy;

    public SomlSchemaStorageMigration(SomlSchemaStorage source, SomlSchemaStorage destination, boolean cleanBeforeMigration, boolean forceStoreUpdate, boolean cleanOnComplete, Integer retries, Long delay) {
        this.source = source;
        this.destination = destination;
        this.cleanBeforeMigration = cleanBeforeMigration;
        this.forceStoreUpdate = forceStoreUpdate;
        this.cleanOnComplete = cleanOnComplete;
        this.retries = (Integer)ObjectsUtil.getOrDefault((Object)retries, (Object)3);
        this.delay = (Long)ObjectsUtil.getOrDefault((Object)delay, (Object)10000L);
    }

    public boolean doMigration() throws MigrationFailedException, UnreachableStoreException {
        int toMigrateCount = this.getStoreSize(this.source);
        if (toMigrateCount == 0) {
            LOGGER.info("Source store is empty. Skipping migration");
            return false;
        }
        int destinationStoreSize = this.getStoreSize(this.destination);
        if (!(destinationStoreSize == 0 || destinationStoreSize == 1 && this.destination.contains("/soml/soml-rbac"))) {
            if (this.forceStoreUpdate) {
                this.onForceStoreUpdate();
            } else {
                String currentSchemas = this.destination.getAll().stream().map(SchemaEntity::getSchemaId).collect(Collectors.joining(", "));
                LOGGER.info("Destination store is not empty [{}]. Skipping migration", (Object)currentSchemas);
                return false;
            }
        }
        List<Throwable> failed = this.migrateInternal();
        LOGGER.info("Migrated {}/{} record", (Object)(toMigrateCount - failed.size()), (Object)toMigrateCount);
        return this.onComplete(failed);
    }

    private int getStoreSize(SomlSchemaStorage schemaStorage) throws MigrationFailedException {
        try {
            return schemaStorage.size();
        }
        catch (UnreachableStoreException re) {
            throw new StoreInaccessible(re);
        }
    }

    @NotNull
    private List<Throwable> migrateInternal() throws UnreachableStoreException {
        Collection<SchemaEntity> entities;
        LinkedList<Throwable> failed = new LinkedList<Throwable>();
        int skip = 0;
        while (!(entities = this.source.getAll(skip, 50, null, false, true)).isEmpty()) {
            for (SchemaEntity entity : entities) {
                try {
                    this.destination.store(entity);
                    Set<String> serviceAddresses = entity.getServiceAddresses();
                    for (String address : serviceAddresses) {
                        this.destination.registerSchemaService(entity.getSchemaId(), address);
                    }
                }
                catch (SomlStoreException | RuntimeException ex) {
                    failed.add(ex);
                }
            }
            skip += entities.size();
        }
        return failed;
    }

    private boolean onComplete(List<Throwable> failed) throws MigrationFailedException {
        if (!this.cleanBeforeMigration) {
            this.destination.setSchemaExistsStrategy(this.destinationExistsStrategy);
        }
        if (this.cleanOnComplete) {
            if (failed.isEmpty()) {
                long cleared = 0L;
                try {
                    cleared = this.source.clear();
                }
                catch (UnreachableStoreException use) {
                    failed.add(use);
                }
                LOGGER.info("Cleaned source store. Removed {} entries", (Object)cleared);
            } else {
                LOGGER.warn("Could not migrate {} records. Skipping source store cleanup.", (Object)failed.size());
            }
        }
        if (failed.isEmpty()) {
            return true;
        }
        throw new MigrationFailedException(failed);
    }

    private void onForceStoreUpdate() throws UnreachableStoreException {
        if (this.cleanBeforeMigration) {
            long clearCount = this.destination.clear();
            LOGGER.info("Cleared {} schemas from the destination", (Object)clearCount);
        } else {
            this.destinationExistsStrategy = this.destination.getSchemaExistsStrategy();
            this.destination.setSchemaExistsStrategy(SomlSchemaStorage.AllowUpsertSchemaStrategy.INSTANCE);
        }
    }

    @Override
    public void run() {
        LOGGER.info("Starting schema store migration {} -> {}", (Object)this.source.getClass().getSimpleName(), (Object)this.destination.getClass().getSimpleName());
        int remainingRetries = Math.min(50, Math.max(this.retries, 1));
        MigrationFailedException lastFailure = null;
        while (remainingRetries > 0) {
            this.waitBeforeRetry(remainingRetries);
            try {
                if (this.doMigration()) {
                    LOGGER.info("Migration completed successfully");
                } else {
                    LOGGER.info("Migration skipped. Check previous messages for the reason.");
                }
                return;
            }
            catch (MigrationFailedException sie) {
                --remainingRetries;
                lastFailure = sie;
            }
            catch (UnreachableStoreException use) {
                --remainingRetries;
                lastFailure = new StoreInaccessible(use);
            }
            if (remainingRetries != 0) continue;
            Set<String> failedMessages = SomlSchemaStorageMigration.getFailedMessages(lastFailure.getSuppressed());
            if (lastFailure instanceof StoreInaccessible) {
                throw new PlatformConfigurationException("Migration failed due to errors: " + String.valueOf(failedMessages), ErrorCode.SCHEMA_STORE_INACCESSIBLE);
            }
            LOGGER.warn("Migration finished with errors: {}", failedMessages);
        }
    }

    private void waitBeforeRetry(int retries) {
        if (retries != this.retries) {
            try {
                Thread.sleep(Math.min(30000L, Math.max(this.delay, 100L)));
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @NotNull
    private static Set<String> getFailedMessages(Throwable[] suppressed) {
        return Arrays.stream(suppressed).map(Throwable::getMessage).collect(Collectors.toSet());
    }

    public static class StoreInaccessible
    extends MigrationFailedException {
        StoreInaccessible(Throwable throwable) {
            super(Collections.singletonList(throwable));
        }
    }

    public static class MigrationFailedException
    extends Exception {
        MigrationFailedException(List<Throwable> throwables) {
            throwables.forEach(this::addSuppressed);
        }
    }
}

